/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy.pattern;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.connectors.kafka.sink.strategy.pattern.Pattern;
import org.neo4j.connectors.kafka.sink.strategy.pattern.PatternKt;
import org.neo4j.connectors.kafka.sink.strategy.pattern.PropertyMapping;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003JS\u0010\u001c\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0014\u0010\u0014\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/pattern/NodePattern;", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/Pattern;", "labels", "", "", "includeAllValueProperties", "", "keyProperties", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PropertyMapping;", "includeProperties", "excludeProperties", "<init>", "(Ljava/util/Set;ZLjava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "getLabels", "()Ljava/util/Set;", "getIncludeAllValueProperties", "()Z", "getKeyProperties", "getIncludeProperties", "getExcludeProperties", "text", "getText", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "sink"})
public final class NodePattern
implements Pattern {
    @NotNull
    private final Set<String> labels;
    private final boolean includeAllValueProperties;
    @NotNull
    private final Set<PropertyMapping> keyProperties;
    @NotNull
    private final Set<PropertyMapping> includeProperties;
    @NotNull
    private final Set<String> excludeProperties;

    public NodePattern(@NotNull Set<String> labels, boolean includeAllValueProperties, @NotNull Set<PropertyMapping> keyProperties, @NotNull Set<PropertyMapping> includeProperties, @NotNull Set<String> excludeProperties) {
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Intrinsics.checkNotNullParameter(keyProperties, (String)"keyProperties");
        Intrinsics.checkNotNullParameter(includeProperties, (String)"includeProperties");
        Intrinsics.checkNotNullParameter(excludeProperties, (String)"excludeProperties");
        this.labels = labels;
        this.includeAllValueProperties = includeAllValueProperties;
        this.keyProperties = keyProperties;
        this.includeProperties = includeProperties;
        this.excludeProperties = excludeProperties;
    }

    @NotNull
    public final Set<String> getLabels() {
        return this.labels;
    }

    @Override
    public boolean getIncludeAllValueProperties() {
        return this.includeAllValueProperties;
    }

    @Override
    @NotNull
    public Set<PropertyMapping> getKeyProperties() {
        return this.keyProperties;
    }

    @Override
    @NotNull
    public Set<PropertyMapping> getIncludeProperties() {
        return this.includeProperties;
    }

    @Override
    @NotNull
    public Set<String> getExcludeProperties() {
        return this.excludeProperties;
    }

    @Override
    @NotNull
    public String getText() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_text__u24lambda_u240 = stringBuilder = new StringBuilder().append("(");
        boolean bl = false;
        if (!((Collection)this.labels).isEmpty()) {
            $this$_get_text__u24lambda_u240.append(":");
        }
        $this$_get_text__u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)this.labels, (CharSequence)":", null, null, (int)0, null, NodePattern::_get_text_$lambda$0$0, (int)30, null));
        String string = stringBuilder.append(" ").append(PatternKt.propertiesAsText(this)).append(")").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final Set<String> component1() {
        return this.labels;
    }

    public final boolean component2() {
        return this.includeAllValueProperties;
    }

    @NotNull
    public final Set<PropertyMapping> component3() {
        return this.keyProperties;
    }

    @NotNull
    public final Set<PropertyMapping> component4() {
        return this.includeProperties;
    }

    @NotNull
    public final Set<String> component5() {
        return this.excludeProperties;
    }

    @NotNull
    public final NodePattern copy(@NotNull Set<String> labels, boolean includeAllValueProperties, @NotNull Set<PropertyMapping> keyProperties, @NotNull Set<PropertyMapping> includeProperties, @NotNull Set<String> excludeProperties) {
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Intrinsics.checkNotNullParameter(keyProperties, (String)"keyProperties");
        Intrinsics.checkNotNullParameter(includeProperties, (String)"includeProperties");
        Intrinsics.checkNotNullParameter(excludeProperties, (String)"excludeProperties");
        return new NodePattern(labels, includeAllValueProperties, keyProperties, includeProperties, excludeProperties);
    }

    public static /* synthetic */ NodePattern copy$default(NodePattern nodePattern, Set set, boolean bl, Set set2, Set set3, Set set4, int n, Object object) {
        if ((n & 1) != 0) {
            set = nodePattern.labels;
        }
        if ((n & 2) != 0) {
            bl = nodePattern.includeAllValueProperties;
        }
        if ((n & 4) != 0) {
            set2 = nodePattern.keyProperties;
        }
        if ((n & 8) != 0) {
            set3 = nodePattern.includeProperties;
        }
        if ((n & 0x10) != 0) {
            set4 = nodePattern.excludeProperties;
        }
        return nodePattern.copy(set, bl, set2, set3, set4);
    }

    @NotNull
    public String toString() {
        return "NodePattern(labels=" + this.labels + ", includeAllValueProperties=" + this.includeAllValueProperties + ", keyProperties=" + this.keyProperties + ", includeProperties=" + this.includeProperties + ", excludeProperties=" + this.excludeProperties + ")";
    }

    public int hashCode() {
        int result = ((Object)this.labels).hashCode();
        result = result * 31 + Boolean.hashCode(this.includeAllValueProperties);
        result = result * 31 + ((Object)this.keyProperties).hashCode();
        result = result * 31 + ((Object)this.includeProperties).hashCode();
        result = result * 31 + ((Object)this.excludeProperties).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NodePattern)) {
            return false;
        }
        NodePattern nodePattern = (NodePattern)other;
        if (!Intrinsics.areEqual(this.labels, nodePattern.labels)) {
            return false;
        }
        if (this.includeAllValueProperties != nodePattern.includeAllValueProperties) {
            return false;
        }
        if (!Intrinsics.areEqual(this.keyProperties, nodePattern.keyProperties)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.includeProperties, nodePattern.includeProperties)) {
            return false;
        }
        return Intrinsics.areEqual(this.excludeProperties, nodePattern.excludeProperties);
    }

    private static final CharSequence _get_text_$lambda$0$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PatternKt.trySanitize(it);
    }
}

