/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.dialect;

import com.networknt.schema.Error;
import com.networknt.schema.InvalidSchemaException;
import com.networknt.schema.SchemaRegistry;
import com.networknt.schema.dialect.AbstractDialectRegistry;
import com.networknt.schema.dialect.Dialect;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Function;

public class BasicDialectRegistry
extends AbstractDialectRegistry {
    protected final Function<String, Dialect> dialects;

    protected BasicDialectRegistry() {
        this.dialects = null;
    }

    public BasicDialectRegistry(Function<String, Dialect> dialects) {
        this.dialects = dialects;
    }

    public BasicDialectRegistry(Dialect dialect) {
        this.dialects = dialectId -> dialect.getId().equals(dialectId) ? dialect : null;
    }

    public BasicDialectRegistry(Collection<Dialect> dialects) {
        HashMap<String, Dialect> result = new HashMap<String, Dialect>();
        for (Dialect dialect : dialects) {
            result.put(dialect.getId(), dialect);
        }
        this.dialects = result::get;
    }

    @Override
    public Dialect getDialect(String dialectId, SchemaRegistry schemaRegistry) {
        Dialect dialect = this.dialects.apply(dialectId);
        if (dialect != null) {
            return dialect;
        }
        throw new InvalidSchemaException(((Error.Builder)((Error.Builder)Error.builder().message("Unknown dialect ''{0}''. Only dialects that are explicitly configured can be used.")).arguments(dialectId)).build());
    }
}

