/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cdc.client.model;

import java.util.Objects;
import org.neo4j.cdc.client.model.ChangeIdentifier;
import org.neo4j.cdc.client.model.Event;
import org.neo4j.cdc.client.model.Metadata;

public class ChangeEvent {
    private final ChangeIdentifier id;
    private final Long txId;
    private final Integer seq;
    private final Metadata metadata;
    private final Event event;

    public ChangeEvent(ChangeIdentifier id, Long txId, Integer seq, Metadata metadata, Event event) {
        this.id = Objects.requireNonNull(id);
        this.txId = Objects.requireNonNull(txId);
        this.seq = Objects.requireNonNull(seq);
        this.metadata = Objects.requireNonNull(metadata);
        this.event = Objects.requireNonNull(event);
    }

    public ChangeIdentifier getId() {
        return this.id;
    }

    public Long getTxId() {
        return this.txId;
    }

    public Integer getSeq() {
        return this.seq;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Event getEvent() {
        return this.event;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeEvent that = (ChangeEvent)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.txId.equals(that.txId)) {
            return false;
        }
        if (!this.seq.equals(that.seq)) {
            return false;
        }
        if (!this.metadata.equals(that.metadata)) {
            return false;
        }
        return this.event.equals(that.event);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.txId.hashCode();
        result = 31 * result + this.seq.hashCode();
        result = 31 * result + this.metadata.hashCode();
        result = 31 * result + this.event.hashCode();
        return result;
    }

    public String toString() {
        return String.format("ChangeEvent{id=%s, txId=%s, seq=%s, metadata=%s, event=%s}", this.id, this.txId, this.seq, this.metadata, this.event);
    }
}

