/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cdc.client.model;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;

class ModelUtils {
    private ModelUtils() {
    }

    static <K, V> Map<K, V> checkedMap(Map<?, ?> input, Class<K> keyType, Class<V> valueType) {
        if (input == null) {
            return null;
        }
        if (input.keySet().stream().anyMatch(k -> !keyType.isInstance(k))) {
            throw new IllegalArgumentException(String.format("There are keys of unsupported types in the provided map, expected: %s", keyType.getSimpleName()));
        }
        if (input.values().stream().anyMatch(v -> v != null && !valueType.isInstance(v))) {
            throw new IllegalArgumentException(String.format("There are values of unsupported types in the provided map, expected: %s", valueType.getSimpleName()));
        }
        return input;
    }

    static <K, V> Map<K, V> getMap(Map<String, Object> input, String key, Class<K> keyType, Class<V> valueType) {
        Object value = input.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return ModelUtils.checkedMap((Map)value, keyType, valueType);
        }
        throw new IllegalArgumentException(String.format("Unsupported type %s, expected Map", value.getClass().getSimpleName()));
    }

    static <T> List<T> getList(Map<String, Object> input, String key, Class<T> type) {
        Object value = MapUtils.getObject(input, (Object)key);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            if (((List)value).stream().anyMatch(v -> !type.isInstance(v))) {
                throw new IllegalArgumentException("There are elements of unsupported types in the provided list");
            }
            return (List)value;
        }
        throw new IllegalArgumentException(String.format("Unsupported type %s, expected List", value.getClass().getSimpleName()));
    }

    static ZonedDateTime getZonedDateTime(Map<String, Object> map, String key) {
        Object value = MapUtils.getObject(map, (Object)key);
        if (value == null) {
            return null;
        }
        if (value instanceof TemporalAccessor) {
            return ZonedDateTime.from((TemporalAccessor)value);
        }
        return ZonedDateTime.parse(value.toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSX"));
    }

    static Map<String, List<Map<String, Object>>> getNodesKeys(Map<String, Object> cypherMap) {
        Map<?, ?> keysMap = ModelUtils.coerseToMap(MapUtils.getObject(cypherMap, (Object)"keys"));
        if (keysMap == null) {
            return null;
        }
        if (keysMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Class<?> valueType = keysMap.values().iterator().next().getClass();
        if (Map.class.isAssignableFrom(valueType)) {
            Map<String, Map> preNode515keyMap = ModelUtils.checkedMap(keysMap, String.class, Map.class);
            return ModelUtils.transformMapValues(preNode515keyMap, e -> List.of(ModelUtils.checkedMap(e, String.class, Object.class)));
        }
        Map<String, List> postNode515KeyMap = ModelUtils.checkedMap(keysMap, String.class, List.class);
        return ModelUtils.transformMapValues(postNode515KeyMap, e -> ModelUtils.coerceToListOfMaps(e, String.class, Object.class));
    }

    static Map<?, ?> coerseToMap(Object input) {
        if (input == null) {
            return null;
        }
        if (!(input instanceof Map)) {
            throw new IllegalArgumentException(String.format("Unexpected type %s, expected Map", input.getClass().getSimpleName()));
        }
        return (Map)input;
    }

    static <K, V> List<Map<K, V>> coerceToListOfMaps(List<?> input, Class<K> keyType, Class<V> valueType) {
        if (input == null) {
            return null;
        }
        return input.stream().map(e -> {
            if (e != null && !(e instanceof Map)) {
                throw new IllegalArgumentException("There are elements of unsupported types in the provided list, expected Map");
            }
            try {
                return ModelUtils.checkedMap((Map)e, keyType, valueType);
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException("There are elements of unsupported types in the provided list", ex);
            }
        }).collect(Collectors.toList());
    }

    static <K, V1, V2> Map<K, V2> transformMapValues(Map<K, V1> input, Function<V1, V2> transform) {
        if (input == null) {
            return null;
        }
        return input.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> transform.apply(e.getValue())));
    }

    static List<Map<String, Object>> getRelationshipKeys(Map<String, Object> cypherMap) {
        List<Map> keysList = ModelUtils.getList(cypherMap, "keys", Map.class);
        if (keysList != null) {
            return ModelUtils.coerceToListOfMaps(keysList, String.class, Object.class);
        }
        Map<String, Object> keyMap = ModelUtils.getMap(cypherMap, "key", String.class, Object.class);
        if (keyMap == null) {
            return null;
        }
        return List.of(keyMap);
    }
}

