/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cdc.client.selector;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cdc.client.model.ChangeEvent;
import org.neo4j.cdc.client.model.EntityOperation;
import org.neo4j.cdc.client.model.NodeEvent;
import org.neo4j.cdc.client.selector.EntitySelector;

public class NodeSelector
extends EntitySelector {
    @NotNull
    private final Set<String> labels;
    @NotNull
    private final Map<String, Object> key;

    private NodeSelector(@Nullable EntityOperation change, @NotNull Set<String> changesTo, @NotNull Set<String> labels, @NotNull Map<String, Object> key, @Nullable String executingUser, @Nullable String authenticatedUser, @NotNull Map<String, Object> txMetadata, @NotNull Set<String> includeProperties, @NotNull Set<String> excludeProperties) {
        super(change, changesTo, executingUser, authenticatedUser, txMetadata, includeProperties, excludeProperties);
        this.labels = Objects.requireNonNull(labels);
        this.key = Objects.requireNonNull(key);
    }

    @NotNull
    public Set<String> getLabels() {
        return this.labels;
    }

    @NotNull
    public Map<String, Object> getKey() {
        return this.key;
    }

    @Override
    public boolean matches(ChangeEvent e) {
        if (!(e.getEvent() instanceof NodeEvent)) {
            return false;
        }
        if (!super.matches(e)) {
            return false;
        }
        NodeEvent nodeEvent = (NodeEvent)e.getEvent();
        if (this.labels.stream().anyMatch(l -> !nodeEvent.getLabels().contains(l))) {
            return false;
        }
        if (!this.key.isEmpty()) {
            if (nodeEvent.getKeys().values().stream().flatMap(Collection::stream).noneMatch(this.key::equals)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> result = new HashMap<String, Object>(super.asMap());
        result.put("select", "n");
        if (!this.labels.isEmpty()) {
            result.put("labels", this.labels);
        }
        if (!this.key.isEmpty()) {
            result.put("key", this.key);
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeSelector that = (NodeSelector)o;
        if (!this.labels.equals(that.labels)) {
            return false;
        }
        return this.key.equals(that.key);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.labels.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }

    public static NodeSelectorBuilder builder() {
        return new NodeSelectorBuilder();
    }

    public static class NodeSelectorBuilder
    extends EntitySelector.Builder<NodeSelectorBuilder, NodeSelector> {
        private Set<String> labels;
        private Map<String, Object> key;

        private NodeSelectorBuilder() {
        }

        public NodeSelectorBuilder withLabels(Set<String> labels) {
            this.labels = labels;
            return this;
        }

        public NodeSelectorBuilder withKey(Map<String, Object> key) {
            this.key = key;
            return this;
        }

        @Override
        public NodeSelector build() {
            return new NodeSelector(this.operation, Objects.requireNonNullElseGet(this.changesTo, Collections::emptySet), Objects.requireNonNullElseGet(this.labels, Collections::emptySet), Objects.requireNonNullElseGet(this.key, Collections::emptyMap), this.executingUser, this.authenticatedUser, Objects.requireNonNullElseGet(this.txMetadata, Collections::emptyMap), Objects.requireNonNullElseGet(this.includeProperties, Collections::emptySet), Objects.requireNonNullElseGet(this.excludeProperties, Collections::emptySet));
        }
    }
}

