/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.configuration;

import java.io.Closeable;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.errors.ConnectException;
import org.jetbrains.annotations.NotNull;
import org.neo4j.connectors.kafka.configuration.AuthenticationType;
import org.neo4j.connectors.kafka.configuration.ConnectorType;
import org.neo4j.connectors.kafka.configuration.Neo4jConfigurationDeclarationsKt;
import org.neo4j.connectors.kafka.configuration.helpers.ConfigUtils;
import org.neo4j.connectors.kafka.configuration.helpers.DurationKt;
import org.neo4j.connectors.kafka.configuration.helpers.Validators;
import org.neo4j.connectors.kafka.utils.Telemetry;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Logging;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.net.ServerAddress;
import org.neo4j.driver.net.ServerAddressResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 N2\u00020\u00012\u00020\u0002:\u0001NB'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010=\u001a\u00020>2\u0012\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0@\"\u00020A\u00a2\u0006\u0002\u0010BJ/\u0010C\u001a\u00020D2%\b\u0002\u0010E\u001a\u001f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020H0G\u0012\u0004\u0012\u00020I0F\u00a2\u0006\u0002\bJH\u0016J\u0014\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020H0\u0006H\u0016J\b\u0010L\u001a\u00020\u0010H\u0016J\b\u0010M\u001a\u00020IH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00198@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u001f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00198@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001bR\u0014\u0010$\u001a\u00020\u00198@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001bR\u0014\u0010&\u001a\u00020\u00198@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001bR\u0014\u0010(\u001a\u00020)8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00148@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0017R\u0014\u0010/\u001a\u0002008@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u0002048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u001b\u00107\u001a\u0002088FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b9\u0010:\u00a8\u0006O"}, d2={"Lorg/neo4j/connectors/kafka/configuration/Neo4jConfiguration;", "Lorg/apache/kafka/common/config/AbstractConfig;", "Ljava/io/Closeable;", "configDef", "Lorg/apache/kafka/common/config/ConfigDef;", "originals", "", "type", "Lorg/neo4j/connectors/kafka/configuration/ConnectorType;", "<init>", "(Lorg/apache/kafka/common/config/ConfigDef;Ljava/util/Map;Lorg/neo4j/connectors/kafka/configuration/ConnectorType;)V", "getType", "()Lorg/neo4j/connectors/kafka/configuration/ConnectorType;", "logger", "Lorg/slf4j/Logger;", "database", "", "getDatabase", "()Ljava/lang/String;", "uris", "", "Ljava/net/URI;", "getUris$common", "()Ljava/util/List;", "connectionTimeout", "Lkotlin/time/Duration;", "getConnectionTimeout-UwyO8pc$common", "()J", "maxRetryTime", "getMaxRetryTime-UwyO8pc$common", "maxConnectionPoolSize", "", "getMaxConnectionPoolSize$common", "()I", "connectionAcquisitionTimeout", "getConnectionAcquisitionTimeout-UwyO8pc$common", "idleTimeBeforeTest", "getIdleTimeBeforeTest-UwyO8pc$common", "maxConnectionLifetime", "getMaxConnectionLifetime-UwyO8pc$common", "encrypted", "", "getEncrypted$common", "()Z", "certFiles", "Ljava/io/File;", "getCertFiles$common", "authenticationToken", "Lorg/neo4j/driver/AuthToken;", "getAuthenticationToken$common", "()Lorg/neo4j/driver/AuthToken;", "trustStrategy", "Lorg/neo4j/driver/Config$TrustStrategy;", "getTrustStrategy$common", "()Lorg/neo4j/driver/Config$TrustStrategy;", "driver", "Lorg/neo4j/driver/Driver;", "getDriver", "()Lorg/neo4j/driver/Driver;", "driver$delegate", "Lkotlin/Lazy;", "sessionConfig", "Lorg/neo4j/driver/SessionConfig;", "bookmarks", "", "Lorg/neo4j/driver/Bookmark;", "([Lorg/neo4j/driver/Bookmark;)Lorg/neo4j/driver/SessionConfig;", "txConfig", "Lorg/neo4j/driver/TransactionConfig;", "applyCustomMetadata", "Lkotlin/Function1;", "", "", "", "Lkotlin/ExtensionFunctionType;", "telemetryData", "userAgentComment", "close", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nNeo4jConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Neo4jConfiguration.kt\norg/neo4j/connectors/kafka/configuration/Neo4jConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ConfigUtils.kt\norg/neo4j/connectors/kafka/configuration/helpers/ConfigUtils\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,300:1\n1586#2:301\n1661#2,3:302\n1586#2:305\n1661#2,3:306\n1586#2:319\n1661#2,3:320\n2792#2,3:323\n25#3,4:309\n25#3,4:313\n37#4,2:317\n*S KotlinDebug\n*F\n+ 1 Neo4jConfiguration.kt\norg/neo4j/connectors/kafka/configuration/Neo4jConfiguration\n*L\n70#1:301\n70#1:302,3\n105#1:305\n105#1:306,3\n156#1:319\n156#1:320,3\n177#1:323,3\n109#1:309,4\n134#1:313,4\n139#1:317,2\n*E\n"})
public class Neo4jConfiguration
extends AbstractConfig
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectorType type;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy driver$delegate;
    private static final long DEFAULT_MAX_RETRY_DURATION = kotlin.time.DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);
    @NotNull
    public static final String URI = "neo4j.uri";
    @NotNull
    public static final String DATABASE = "neo4j.database";
    @NotNull
    public static final String AUTHENTICATION_TYPE = "neo4j.authentication.type";
    @NotNull
    public static final String AUTHENTICATION_BASIC_USERNAME = "neo4j.authentication.basic.username";
    @NotNull
    public static final String AUTHENTICATION_BASIC_PASSWORD = "neo4j.authentication.basic.password";
    @NotNull
    public static final String AUTHENTICATION_BASIC_REALM = "neo4j.authentication.basic.realm";
    @NotNull
    public static final String AUTHENTICATION_KERBEROS_TICKET = "neo4j.authentication.kerberos.ticket";
    @NotNull
    public static final String AUTHENTICATION_BEARER_TOKEN = "neo4j.authentication.bearer.token";
    @NotNull
    public static final String AUTHENTICATION_CUSTOM_SCHEME = "neo4j.authentication.custom.scheme";
    @NotNull
    public static final String AUTHENTICATION_CUSTOM_PRINCIPAL = "neo4j.authentication.custom.principal";
    @NotNull
    public static final String AUTHENTICATION_CUSTOM_CREDENTIALS = "neo4j.authentication.custom.credentials";
    @NotNull
    public static final String AUTHENTICATION_CUSTOM_REALM = "neo4j.authentication.custom.realm";
    @NotNull
    public static final String MAX_TRANSACTION_RETRY_TIMEOUT = "neo4j.max-retry-time";
    @NotNull
    public static final String CONNECTION_TIMEOUT = "neo4j.connection-timeout";
    @NotNull
    public static final String POOL_MAX_CONNECTION_POOL_SIZE = "neo4j.pool.max-connection-pool-size";
    @NotNull
    public static final String POOL_CONNECTION_ACQUISITION_TIMEOUT = "neo4j.pool.connection-acquisition-timeout";
    @NotNull
    public static final String POOL_IDLE_TIME_BEFORE_TEST = "neo4j.pool.idle-time-before-connection-test";
    @NotNull
    public static final String POOL_MAX_CONNECTION_LIFETIME = "neo4j.pool.max-connection-lifetime";
    @NotNull
    public static final String SECURITY_ENCRYPTED = "neo4j.security.encrypted";
    @NotNull
    public static final String SECURITY_HOST_NAME_VERIFICATION_ENABLED = "neo4j.security.hostname-verification-enabled";
    @NotNull
    public static final String SECURITY_TRUST_STRATEGY = "neo4j.security.trust-strategy";
    @NotNull
    public static final String SECURITY_CERT_FILES = "neo4j.security.cert-files";

    public Neo4jConfiguration(@NotNull ConfigDef configDef, @NotNull Map<?, ?> originals, @NotNull ConnectorType type) {
        Intrinsics.checkNotNullParameter((Object)configDef, (String)"configDef");
        Intrinsics.checkNotNullParameter(originals, (String)"originals");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(configDef, originals);
        this.type = type;
        Logger logger = LoggerFactory.getLogger(Neo4jConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.driver$delegate = LazyKt.lazy(() -> Neo4jConfiguration.driver_delegate$lambda$0(this));
    }

    @NotNull
    public final ConnectorType getType() {
        return this.type;
    }

    @NotNull
    public final String getDatabase() {
        String string2 = this.getString(DATABASE);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<URI> getUris$common() {
        void $this$mapTo$iv$iv;
        List list = this.getList(URI);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new URI((String)it));
        }
        return (List)destination$iv$iv;
    }

    public final long getConnectionTimeout-UwyO8pc$common() {
        String string2 = this.getString(CONNECTION_TIMEOUT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return DurationKt.parseSimpleString(Duration.Companion, string2);
    }

    public final long getMaxRetryTime-UwyO8pc$common() {
        String string2 = this.getString(MAX_TRANSACTION_RETRY_TIMEOUT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return DurationKt.parseSimpleString(Duration.Companion, string2);
    }

    public final int getMaxConnectionPoolSize$common() {
        Integer n = this.getInt(POOL_MAX_CONNECTION_POOL_SIZE);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getInt(...)");
        return ((Number)n).intValue();
    }

    public final long getConnectionAcquisitionTimeout-UwyO8pc$common() {
        String string2 = this.getString(POOL_CONNECTION_ACQUISITION_TIMEOUT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return DurationKt.parseSimpleString(Duration.Companion, string2);
    }

    public final long getIdleTimeBeforeTest-UwyO8pc$common() {
        String string2 = this.getString(POOL_IDLE_TIME_BEFORE_TEST);
        if (string2 == null) {
            string2 = "";
        }
        String $this$getIdleTimeBeforeTest_UwyO8pc_u24lambda_u240 = string2;
        boolean bl = false;
        return ((CharSequence)$this$getIdleTimeBeforeTest_UwyO8pc_u24lambda_u240).length() == 0 ? kotlin.time.DurationKt.toDuration((int)-1, (DurationUnit)DurationUnit.MILLISECONDS) : DurationKt.parseSimpleString(Duration.Companion, $this$getIdleTimeBeforeTest_UwyO8pc_u24lambda_u240);
    }

    public final long getMaxConnectionLifetime-UwyO8pc$common() {
        String string2 = this.getString(POOL_MAX_CONNECTION_LIFETIME);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return DurationKt.parseSimpleString(Duration.Companion, string2);
    }

    public final boolean getEncrypted$common() {
        return Boolean.parseBoolean(this.getString(SECURITY_ENCRYPTED));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getCertFiles$common() {
        void $this$mapTo$iv$iv;
        List list = this.getList(SECURITY_CERT_FILES);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File((String)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AuthToken getAuthenticationToken$common() {
        AuthToken authToken;
        Enum enum_;
        ConfigUtils configUtils = ConfigUtils.INSTANCE;
        AbstractConfig abstractConfig = this;
        String key$iv = AUTHENTICATION_TYPE;
        boolean $i$f$getEnum = false;
        try {
            void config$iv;
            String string2 = config$iv.getString(key$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            enum_ = AuthenticationType.valueOf(string2);
        }
        catch (IllegalArgumentException e$iv) {
            enum_ = null;
        }
        AuthenticationType authenticationType = (AuthenticationType)enum_;
        switch (authenticationType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[authenticationType.ordinal()]) {
            case -1: {
                throw new ConnectException("Configuration 'neo4j.authentication.type' is not provided");
            }
            case 1: {
                AuthToken authToken2 = AuthTokens.none();
                authToken = authToken2;
                Intrinsics.checkNotNullExpressionValue((Object)authToken2, (String)"none(...)");
                break;
            }
            case 2: {
                AuthToken authToken3 = AuthTokens.basic((String)this.getString(AUTHENTICATION_BASIC_USERNAME), (String)this.getPassword(AUTHENTICATION_BASIC_PASSWORD).value(), (String)this.getString(AUTHENTICATION_BASIC_REALM));
                authToken = authToken3;
                Intrinsics.checkNotNullExpressionValue((Object)authToken3, (String)"basic(...)");
                break;
            }
            case 3: {
                AuthToken authToken4 = AuthTokens.kerberos((String)this.getPassword(AUTHENTICATION_KERBEROS_TICKET).value());
                authToken = authToken4;
                Intrinsics.checkNotNullExpressionValue((Object)authToken4, (String)"kerberos(...)");
                break;
            }
            case 4: {
                AuthToken authToken5 = AuthTokens.bearer((String)this.getPassword(AUTHENTICATION_BEARER_TOKEN).value());
                authToken = authToken5;
                Intrinsics.checkNotNullExpressionValue((Object)authToken5, (String)"bearer(...)");
                break;
            }
            case 5: {
                AuthToken authToken6 = AuthTokens.custom((String)this.getString(AUTHENTICATION_CUSTOM_PRINCIPAL), (String)this.getPassword(AUTHENTICATION_CUSTOM_CREDENTIALS).value(), (String)this.getString(AUTHENTICATION_CUSTOM_REALM), (String)this.getString(AUTHENTICATION_CUSTOM_SCHEME));
                authToken = authToken6;
                Intrinsics.checkNotNullExpressionValue((Object)authToken6, (String)"custom(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return authToken;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Config.TrustStrategy getTrustStrategy$common() {
        Config.TrustStrategy trustStrategy;
        Config.TrustStrategy trustStrategy2;
        Enum enum_;
        ConfigUtils configUtils = ConfigUtils.INSTANCE;
        AbstractConfig abstractConfig = this;
        String key$iv = SECURITY_TRUST_STRATEGY;
        boolean $i$f$getEnum = false;
        try {
            void config$iv;
            String string2 = config$iv.getString(key$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            enum_ = (Enum)Config.TrustStrategy.Strategy.valueOf((String)string2);
        }
        catch (IllegalArgumentException e$iv) {
            enum_ = null;
        }
        Config.TrustStrategy.Strategy strategy = (Config.TrustStrategy.Strategy)enum_;
        switch (strategy == null ? -1 : WhenMappings.$EnumSwitchMapping$1[strategy.ordinal()]) {
            case -1: {
                Config.TrustStrategy trustStrategy3 = Config.TrustStrategy.trustSystemCertificates();
                trustStrategy2 = trustStrategy3;
                Intrinsics.checkNotNullExpressionValue((Object)trustStrategy3, (String)"trustSystemCertificates(...)");
                break;
            }
            case 1: {
                Config.TrustStrategy trustStrategy4 = Config.TrustStrategy.trustAllCertificates();
                trustStrategy2 = trustStrategy4;
                Intrinsics.checkNotNullExpressionValue((Object)trustStrategy4, (String)"trustAllCertificates(...)");
                break;
            }
            case 2: {
                Config.TrustStrategy trustStrategy5 = Config.TrustStrategy.trustSystemCertificates();
                trustStrategy2 = trustStrategy5;
                Intrinsics.checkNotNullExpressionValue((Object)trustStrategy5, (String)"trustSystemCertificates(...)");
                break;
            }
            case 3: {
                Collection $this$toTypedArray$iv = this.getCertFiles$common();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                File[] fileArray = thisCollection$iv.toArray(new File[0]);
                Config.TrustStrategy trustStrategy6 = Config.TrustStrategy.trustCustomCertificateSignedBy((File[])Arrays.copyOf(fileArray, fileArray.length));
                trustStrategy2 = trustStrategy6;
                Intrinsics.checkNotNullExpressionValue((Object)trustStrategy6, (String)"trustCustomCertificateSignedBy(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Config.TrustStrategy strategy2 = trustStrategy2;
        if (Boolean.parseBoolean(this.getString(SECURITY_HOST_NAME_VERIFICATION_ENABLED))) {
            Config.TrustStrategy trustStrategy7 = strategy2.withHostnameVerification();
            Intrinsics.checkNotNull((Object)trustStrategy7);
            trustStrategy = trustStrategy7;
        } else {
            Config.TrustStrategy trustStrategy8 = strategy2.withoutHostnameVerification();
            Intrinsics.checkNotNull((Object)trustStrategy8);
            trustStrategy = trustStrategy8;
        }
        return trustStrategy;
    }

    @NotNull
    public final Driver getDriver() {
        Lazy lazy = this.driver$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Driver)object;
    }

    @NotNull
    public final SessionConfig sessionConfig(Bookmark ... bookmarks) {
        AccessMode accessMode;
        Intrinsics.checkNotNullParameter((Object)bookmarks, (String)"bookmarks");
        SessionConfig.Builder config = SessionConfig.builder();
        if (!StringsKt.isBlank((CharSequence)this.getDatabase())) {
            config.withDatabase(this.getDatabase());
        }
        if (!(bookmarks.length == 0)) {
            config.withBookmarks(Arrays.copyOf(bookmarks, bookmarks.length));
        }
        switch (WhenMappings.$EnumSwitchMapping$2[this.type.ordinal()]) {
            case 1: {
                accessMode = AccessMode.READ;
                break;
            }
            case 2: {
                accessMode = AccessMode.WRITE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        config.withDefaultAccessMode(accessMode);
        SessionConfig sessionConfig = config.build();
        Intrinsics.checkNotNullExpressionValue((Object)sessionConfig, (String)"build(...)");
        return sessionConfig;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public TransactionConfig txConfig(@NotNull Function1<? super Map<String, Object>, Unit> applyCustomMetadata) {
        void $this$txConfig_u24lambda_u241;
        Map map;
        Intrinsics.checkNotNullParameter(applyCustomMetadata, (String)"applyCustomMetadata");
        Map map2 = map = MapsKt.createMapBuilder();
        TransactionConfig.Builder builder = TransactionConfig.builder();
        boolean bl = false;
        applyCustomMetadata.invoke((Object)$this$txConfig_u24lambda_u241);
        $this$txConfig_u24lambda_u241.put("app", Telemetry.connectorInformation$common$default(Telemetry.INSTANCE, this.type.getDescription(), null, null, null, 14, null));
        Map<String, Object> metadata = this.telemetryData();
        if (!metadata.isEmpty()) {
            $this$txConfig_u24lambda_u241.put("metadata", metadata);
        }
        TransactionConfig transactionConfig = builder.withMetadata(MapsKt.build((Map)map)).build();
        Intrinsics.checkNotNullExpressionValue((Object)transactionConfig, (String)"build(...)");
        return transactionConfig;
    }

    public static /* synthetic */ TransactionConfig txConfig$default(Neo4jConfiguration neo4jConfiguration, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: txConfig");
        }
        if ((n & 1) != 0) {
            function1 = Neo4jConfiguration::txConfig$lambda$0;
        }
        return neo4jConfiguration.txConfig((Function1<? super Map<String, Object>, Unit>)function1);
    }

    @NotNull
    public Map<String, Object> telemetryData() {
        return MapsKt.emptyMap();
    }

    @NotNull
    public String userAgentComment() {
        return "";
    }

    @Override
    public void close() {
        try {
            this.getDriver().close();
        }
        catch (Throwable t) {
            this.logger.warn("unable to close driver", t);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Set driver_delegate$lambda$0$0(List $uri, ServerAddress serverAddress) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $uri;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            URI uRI = (URI)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ServerAddress.of((String)it.getHost(), (int)(it.getPort() == -1 ? 7687 : it.getPort())));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * Unable to fully structure code
     */
    private static final Driver driver_delegate$lambda$0(Neo4jConfiguration this$0) {
        block7: {
            block8: {
                config = org.neo4j.driver.Config.builder();
                uri = this$0.getUris$common();
                mainUri = (URI)CollectionsKt.first(uri);
                if (uri.size() > 1) {
                    config.withResolver((ServerAddressResolver)LambdaMetafactory.metafactory(null, null, null, (Lorg/neo4j/driver/net/ServerAddress;)Ljava/util/Set;, driver_delegate$lambda$0$0(java.util.List org.neo4j.driver.net.ServerAddress ), (Lorg/neo4j/driver/net/ServerAddress;)Ljava/util/Set;)(uri));
                }
                config.withUserAgent(Telemetry.userAgent$default(Telemetry.INSTANCE, this$0.type.getDescription(), this$0.userAgentComment(), null, 4, null));
                config.withConnectionAcquisitionTimeout(Duration.getInWholeMilliseconds-impl((long)this$0.getConnectionAcquisitionTimeout-UwyO8pc$common()), TimeUnit.MILLISECONDS);
                config.withConnectionTimeout(Duration.getInWholeMilliseconds-impl((long)this$0.getConnectionTimeout-UwyO8pc$common()), TimeUnit.MILLISECONDS);
                config.withMaxConnectionPoolSize(this$0.getMaxConnectionPoolSize$common());
                config.withConnectionLivenessCheckTimeout(Duration.getInWholeMilliseconds-impl((long)this$0.getIdleTimeBeforeTest-UwyO8pc$common()), TimeUnit.MILLISECONDS);
                config.withMaxConnectionLifetime(Duration.getInWholeMilliseconds-impl((long)this$0.getMaxConnectionLifetime-UwyO8pc$common()), TimeUnit.MILLISECONDS);
                config.withMaxTransactionRetryTime(Duration.getInWholeMilliseconds-impl((long)this$0.getMaxRetryTime-UwyO8pc$common()), TimeUnit.MILLISECONDS);
                $this$none$iv = uri;
                $i$f$none = false;
                if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) break block8;
                v0 = true;
                break block7;
            }
            for (T element$iv : $this$none$iv) {
                it = (URI)element$iv;
                $i$a$-none-Neo4jConfiguration$driver$2$2 = false;
                v1 = it.getScheme();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getScheme(...)");
                if (StringsKt.endsWith((String)v1, (String)"+s", (boolean)true)) ** GOTO lbl-1000
                v2 = it.getScheme();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getScheme(...)");
                if (StringsKt.endsWith((String)v2, (String)"+ssc", (boolean)true)) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = false;
                }
                if (!v3) continue;
                v0 = false;
                break block7;
            }
            v0 = true;
        }
        if (v0) {
            if (this$0.getEncrypted$common()) {
                config.withEncryption();
                v4 = config.withTrustStrategy(this$0.getTrustStrategy$common());
            } else {
                v4 = config.withoutEncryption();
            }
        }
        config.withLogging(Logging.slf4j());
        return GraphDatabase.driver((URI)mainUri, (AuthToken)this$0.getAuthenticationToken$common(), (org.neo4j.driver.Config)config.build());
    }

    private static final Unit txConfig$lambda$0(Map map) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"<this>");
        return Unit.INSTANCE;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0006\u0010\"\u001a\u00020$R\u0013\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/neo4j/connectors/kafka/configuration/Neo4jConfiguration$Companion;", "", "<init>", "()V", "DEFAULT_MAX_RETRY_DURATION", "Lkotlin/time/Duration;", "getDEFAULT_MAX_RETRY_DURATION-UwyO8pc", "()J", "J", "URI", "", "DATABASE", "AUTHENTICATION_TYPE", "AUTHENTICATION_BASIC_USERNAME", "AUTHENTICATION_BASIC_PASSWORD", "AUTHENTICATION_BASIC_REALM", "AUTHENTICATION_KERBEROS_TICKET", "AUTHENTICATION_BEARER_TOKEN", "AUTHENTICATION_CUSTOM_SCHEME", "AUTHENTICATION_CUSTOM_PRINCIPAL", "AUTHENTICATION_CUSTOM_CREDENTIALS", "AUTHENTICATION_CUSTOM_REALM", "MAX_TRANSACTION_RETRY_TIMEOUT", "CONNECTION_TIMEOUT", "POOL_MAX_CONNECTION_POOL_SIZE", "POOL_CONNECTION_ACQUISITION_TIMEOUT", "POOL_IDLE_TIME_BEFORE_TEST", "POOL_MAX_CONNECTION_LIFETIME", "SECURITY_ENCRYPTED", "SECURITY_HOST_NAME_VERIFICATION_ENABLED", "SECURITY_TRUST_STRATEGY", "SECURITY_CERT_FILES", "validate", "", "config", "Lorg/apache/kafka/common/config/Config;", "Lorg/apache/kafka/common/config/ConfigDef;", "common"})
    public static final class Companion {
        private Companion() {
        }

        public final long getDEFAULT_MAX_RETRY_DURATION-UwyO8pc() {
            return DEFAULT_MAX_RETRY_DURATION;
        }

        public final void validate(@NotNull Config config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Validators.INSTANCE.validateNonEmptyIfVisible(config, Neo4jConfiguration.AUTHENTICATION_BASIC_USERNAME);
            Validators.INSTANCE.validateNonEmptyIfVisible(config, Neo4jConfiguration.AUTHENTICATION_BASIC_PASSWORD);
            Validators.INSTANCE.validateNonEmptyIfVisible(config, Neo4jConfiguration.AUTHENTICATION_KERBEROS_TICKET);
            Validators.INSTANCE.validateNonEmptyIfVisible(config, Neo4jConfiguration.AUTHENTICATION_BEARER_TOKEN);
            Validators.INSTANCE.validateNonEmptyIfVisible(config, Neo4jConfiguration.AUTHENTICATION_CUSTOM_PRINCIPAL);
            Validators.INSTANCE.validateNonEmptyIfVisible(config, Neo4jConfiguration.AUTHENTICATION_CUSTOM_CREDENTIALS);
            Validators.INSTANCE.validateNonEmptyIfVisible(config, Neo4jConfiguration.AUTHENTICATION_CUSTOM_SCHEME);
            Validators.INSTANCE.validateNonEmptyIfVisible(config, Neo4jConfiguration.SECURITY_ENCRYPTED);
            Validators.INSTANCE.validateNonEmptyIfVisible(config, Neo4jConfiguration.SECURITY_HOST_NAME_VERIFICATION_ENABLED);
            Validators.INSTANCE.validateNonEmptyIfVisible(config, Neo4jConfiguration.SECURITY_TRUST_STRATEGY);
            Validators.INSTANCE.validateNonEmptyIfVisible(config, Neo4jConfiguration.SECURITY_CERT_FILES);
        }

        @NotNull
        public final ConfigDef config() {
            return Neo4jConfigurationDeclarationsKt.defineRetrySettings(Neo4jConfigurationDeclarationsKt.definePoolSettings(Neo4jConfigurationDeclarationsKt.defineEncryptionSettings(Neo4jConfigurationDeclarationsKt.defineConnectionSettings(new ConfigDef()))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[AuthenticationType.values().length];
            try {
                nArray[AuthenticationType.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthenticationType.BASIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthenticationType.KERBEROS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthenticationType.BEARER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthenticationType.CUSTOM.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Config.TrustStrategy.Strategy.values().length];
            try {
                nArray[Config.TrustStrategy.Strategy.TRUST_ALL_CERTIFICATES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Config.TrustStrategy.Strategy.TRUST_SYSTEM_CA_SIGNED_CERTIFICATES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Config.TrustStrategy.Strategy.TRUST_CUSTOM_CA_SIGNED_CERTIFICATES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ConnectorType.values().length];
            try {
                nArray[ConnectorType.SOURCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectorType.SINK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

