/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.configuration;

import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationUnit;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.jetbrains.annotations.NotNull;
import org.neo4j.connectors.kafka.configuration.AuthenticationType;
import org.neo4j.connectors.kafka.configuration.Groups;
import org.neo4j.connectors.kafka.configuration.Neo4jConfiguration;
import org.neo4j.connectors.kafka.configuration.helpers.ConfigKeyBuilder;
import org.neo4j.connectors.kafka.configuration.helpers.DurationKt;
import org.neo4j.connectors.kafka.configuration.helpers.Recommenders;
import org.neo4j.connectors.kafka.configuration.helpers.Validators;
import org.neo4j.driver.Config;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0002\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0001\u00a8\u0006\u0005"}, d2={"defineConnectionSettings", "Lorg/apache/kafka/common/config/ConfigDef;", "defineEncryptionSettings", "definePoolSettings", "defineRetrySettings", "common"})
public final class Neo4jConfigurationDeclarationsKt {
    @NotNull
    public static final ConfigDef defineConnectionSettings(@NotNull ConfigDef $this$defineConnectionSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$defineConnectionSettings, (String)"<this>");
        ConfigDef configDef = $this$defineConnectionSettings.define(ConfigKeyBuilder.Companion.of("neo4j.uri", ConfigDef.Type.LIST, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::defineConnectionSettings$lambda$0))).define(ConfigKeyBuilder.Companion.of("neo4j.database", ConfigDef.Type.STRING, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::defineConnectionSettings$lambda$1))).define(ConfigKeyBuilder.Companion.of("neo4j.authentication.type", ConfigDef.Type.STRING, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::defineConnectionSettings$lambda$2))).define(ConfigKeyBuilder.Companion.of("neo4j.authentication.basic.username", ConfigDef.Type.STRING, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::defineConnectionSettings$lambda$3))).define(ConfigKeyBuilder.Companion.of("neo4j.authentication.basic.password", ConfigDef.Type.PASSWORD, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::defineConnectionSettings$lambda$4))).define(ConfigKeyBuilder.Companion.of("neo4j.authentication.basic.realm", ConfigDef.Type.STRING, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::defineConnectionSettings$lambda$5))).define(ConfigKeyBuilder.Companion.of("neo4j.authentication.kerberos.ticket", ConfigDef.Type.PASSWORD, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::defineConnectionSettings$lambda$6))).define(ConfigKeyBuilder.Companion.of("neo4j.authentication.bearer.token", ConfigDef.Type.PASSWORD, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::defineConnectionSettings$lambda$7))).define(ConfigKeyBuilder.Companion.of("neo4j.authentication.custom.scheme", ConfigDef.Type.STRING, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::defineConnectionSettings$lambda$8))).define(ConfigKeyBuilder.Companion.of("neo4j.authentication.custom.principal", ConfigDef.Type.STRING, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::defineConnectionSettings$lambda$9))).define(ConfigKeyBuilder.Companion.of("neo4j.authentication.custom.credentials", ConfigDef.Type.PASSWORD, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::defineConnectionSettings$lambda$10))).define(ConfigKeyBuilder.Companion.of("neo4j.authentication.custom.realm", ConfigDef.Type.STRING, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::defineConnectionSettings$lambda$11)));
        Intrinsics.checkNotNullExpressionValue((Object)configDef, (String)"define(...)");
        return configDef;
    }

    @NotNull
    public static final ConfigDef defineEncryptionSettings(@NotNull ConfigDef $this$defineEncryptionSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$defineEncryptionSettings, (String)"<this>");
        ConfigDef configDef = $this$defineEncryptionSettings.define(ConfigKeyBuilder.Companion.of("neo4j.security.encrypted", ConfigDef.Type.STRING, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::defineEncryptionSettings$lambda$0))).define(ConfigKeyBuilder.Companion.of("neo4j.security.trust-strategy", ConfigDef.Type.STRING, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::defineEncryptionSettings$lambda$1))).define(ConfigKeyBuilder.Companion.of("neo4j.security.hostname-verification-enabled", ConfigDef.Type.STRING, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::defineEncryptionSettings$lambda$2))).define(ConfigKeyBuilder.Companion.of("neo4j.security.cert-files", ConfigDef.Type.LIST, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::defineEncryptionSettings$lambda$3)));
        Intrinsics.checkNotNullExpressionValue((Object)configDef, (String)"define(...)");
        return configDef;
    }

    @NotNull
    public static final ConfigDef definePoolSettings(@NotNull ConfigDef $this$definePoolSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$definePoolSettings, (String)"<this>");
        ConfigDef configDef = $this$definePoolSettings.define(ConfigKeyBuilder.Companion.of("neo4j.connection-timeout", ConfigDef.Type.STRING, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::definePoolSettings$lambda$0))).define(ConfigKeyBuilder.Companion.of("neo4j.pool.max-connection-pool-size", ConfigDef.Type.INT, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::definePoolSettings$lambda$1))).define(ConfigKeyBuilder.Companion.of("neo4j.pool.connection-acquisition-timeout", ConfigDef.Type.STRING, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::definePoolSettings$lambda$2))).define(ConfigKeyBuilder.Companion.of("neo4j.pool.max-connection-lifetime", ConfigDef.Type.STRING, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::definePoolSettings$lambda$3))).define(ConfigKeyBuilder.Companion.of("neo4j.pool.idle-time-before-connection-test", ConfigDef.Type.STRING, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::definePoolSettings$lambda$4)));
        Intrinsics.checkNotNullExpressionValue((Object)configDef, (String)"define(...)");
        return configDef;
    }

    @NotNull
    public static final ConfigDef defineRetrySettings(@NotNull ConfigDef $this$defineRetrySettings) {
        Intrinsics.checkNotNullParameter((Object)$this$defineRetrySettings, (String)"<this>");
        ConfigDef configDef = $this$defineRetrySettings.define(ConfigKeyBuilder.Companion.of("neo4j.max-retry-time", ConfigDef.Type.STRING, (Function1<? super ConfigKeyBuilder, Unit>)((Function1)Neo4jConfigurationDeclarationsKt::defineRetrySettings$lambda$0)));
        Intrinsics.checkNotNullExpressionValue((Object)configDef, (String)"define(...)");
        return configDef;
    }

    private static final Unit defineConnectionSettings$lambda$0(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.HIGH);
        $this$of.setGroup(Groups.CONNECTION.getTitle());
        String[] stringArray = new String[]{"neo4j", "neo4j+s", "neo4j+ssc", "bolt", "bolt+s", "bolt+ssc"};
        $this$of.setValidator(Validators.INSTANCE.uri(stringArray));
        return Unit.INSTANCE;
    }

    private static final Unit defineConnectionSettings$lambda$1(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.HIGH);
        $this$of.setDefaultValue("");
        $this$of.setGroup(Groups.CONNECTION.getTitle());
        $this$of.setValidator((ConfigDef.Validator)new ConfigDef.NonNullValidator());
        return Unit.INSTANCE;
    }

    private static final Unit defineConnectionSettings$lambda$2(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.HIGH);
        $this$of.setDefaultValue(AuthenticationType.BASIC.toString());
        $this$of.setGroup(Groups.CONNECTION.getTitle());
        $this$of.setValidator(Validators.INSTANCE.enum(AuthenticationType.class, new AuthenticationType[0]));
        $this$of.setRecommender(Recommenders.INSTANCE.enum(AuthenticationType.class, new AuthenticationType[0]));
        return Unit.INSTANCE;
    }

    private static final Unit defineConnectionSettings$lambda$3(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.HIGH);
        $this$of.setDefaultValue("");
        $this$of.setGroup(Groups.CONNECTION.getTitle());
        Predicate<Object> predicate = Predicate.isEqual(AuthenticationType.BASIC.toString());
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
        $this$of.setRecommender(Recommenders.INSTANCE.visibleIf("neo4j.authentication.type", predicate));
        return Unit.INSTANCE;
    }

    private static final Unit defineConnectionSettings$lambda$4(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.HIGH);
        $this$of.setDefaultValue("");
        $this$of.setGroup(Groups.CONNECTION.getTitle());
        Predicate<Object> predicate = Predicate.isEqual(AuthenticationType.BASIC.toString());
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
        $this$of.setRecommender(Recommenders.INSTANCE.visibleIf("neo4j.authentication.type", predicate));
        return Unit.INSTANCE;
    }

    private static final Unit defineConnectionSettings$lambda$5(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.LOW);
        $this$of.setDefaultValue("");
        $this$of.setGroup(Groups.CONNECTION.getTitle());
        Predicate<Object> predicate = Predicate.isEqual(AuthenticationType.BASIC.toString());
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
        $this$of.setRecommender(Recommenders.INSTANCE.visibleIf("neo4j.authentication.type", predicate));
        return Unit.INSTANCE;
    }

    private static final Unit defineConnectionSettings$lambda$6(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setGroup(Groups.CONNECTION.getTitle());
        $this$of.setImportance(ConfigDef.Importance.HIGH);
        $this$of.setDefaultValue("");
        Predicate<Object> predicate = Predicate.isEqual(AuthenticationType.KERBEROS.toString());
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
        $this$of.setRecommender(Recommenders.INSTANCE.visibleIf("neo4j.authentication.type", predicate));
        return Unit.INSTANCE;
    }

    private static final Unit defineConnectionSettings$lambda$7(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.HIGH);
        $this$of.setDefaultValue("");
        $this$of.setGroup(Groups.CONNECTION.getTitle());
        Predicate<Object> predicate = Predicate.isEqual(AuthenticationType.BEARER.toString());
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
        $this$of.setRecommender(Recommenders.INSTANCE.visibleIf("neo4j.authentication.type", predicate));
        return Unit.INSTANCE;
    }

    private static final Unit defineConnectionSettings$lambda$8(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.HIGH);
        $this$of.setDefaultValue("");
        $this$of.setGroup(Groups.CONNECTION.getTitle());
        Predicate<Object> predicate = Predicate.isEqual(AuthenticationType.CUSTOM.toString());
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
        $this$of.setRecommender(Recommenders.INSTANCE.visibleIf("neo4j.authentication.type", predicate));
        return Unit.INSTANCE;
    }

    private static final Unit defineConnectionSettings$lambda$9(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.HIGH);
        $this$of.setDefaultValue("");
        $this$of.setGroup(Groups.CONNECTION.getTitle());
        Predicate<Object> predicate = Predicate.isEqual(AuthenticationType.CUSTOM.toString());
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
        $this$of.setRecommender(Recommenders.INSTANCE.visibleIf("neo4j.authentication.type", predicate));
        return Unit.INSTANCE;
    }

    private static final Unit defineConnectionSettings$lambda$10(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.HIGH);
        $this$of.setDefaultValue("");
        $this$of.setGroup(Groups.CONNECTION.getTitle());
        Predicate<Object> predicate = Predicate.isEqual(AuthenticationType.CUSTOM.toString());
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
        $this$of.setRecommender(Recommenders.INSTANCE.visibleIf("neo4j.authentication.type", predicate));
        return Unit.INSTANCE;
    }

    private static final Unit defineConnectionSettings$lambda$11(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.HIGH);
        $this$of.setDefaultValue("");
        $this$of.setGroup(Groups.CONNECTION.getTitle());
        Predicate<Object> predicate = Predicate.isEqual(AuthenticationType.CUSTOM.toString());
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
        $this$of.setRecommender(Recommenders.INSTANCE.visibleIf("neo4j.authentication.type", predicate));
        return Unit.INSTANCE;
    }

    private static final Unit defineEncryptionSettings$lambda$0(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.LOW);
        $this$of.setDefaultValue("false");
        $this$of.setGroup(Groups.CONNECTION_TLS.getTitle());
        $this$of.setValidator(Validators.INSTANCE.bool());
        ConfigDef.Recommender[] recommenderArray = new ConfigDef.Recommender[]{Recommenders.INSTANCE.bool(), Recommenders.INSTANCE.visibleIf("neo4j.uri", new Predicate<Object>(){

            public boolean test(Object t) {
                boolean bl;
                block9: {
                    Object object = t;
                    if (object == null) {
                        bl = false;
                    } else if (object instanceof String) {
                        Object[] objectArray = new String[]{"bolt", "neo4j"};
                        bl = ArraysKt.contains((Object[])objectArray, (Object)new URI((String)t).getScheme());
                    } else if (object instanceof List) {
                        Iterable $this$any$iv = (Iterable)t;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            Iterator<T> iterator = $this$any$iv.iterator();
                            while (iterator.hasNext()) {
                                T element$iv;
                                T it = element$iv = iterator.next();
                                boolean bl2 = false;
                                if (!this.test((Object)it)) continue;
                                bl = true;
                                break block9;
                            }
                            bl = false;
                        }
                    } else {
                        throw new ConfigException("Must be a String or a List");
                    }
                }
                return bl;
            }
        })};
        $this$of.setRecommender(Recommenders.INSTANCE.and(recommenderArray));
        return Unit.INSTANCE;
    }

    private static final Unit defineEncryptionSettings$lambda$1(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.LOW);
        $this$of.setDefaultValue(Config.TrustStrategy.Strategy.TRUST_SYSTEM_CA_SIGNED_CERTIFICATES.toString());
        $this$of.setGroup(Groups.CONNECTION_TLS.getTitle());
        $this$of.setValidator(Validators.INSTANCE.enum(Config.TrustStrategy.Strategy.class, (Enum[])new Config.TrustStrategy.Strategy[0]));
        ConfigDef.Recommender[] recommenderArray = new ConfigDef.Recommender[3];
        recommenderArray[0] = Recommenders.INSTANCE.enum(Config.TrustStrategy.Strategy.class, (Enum[])new Config.TrustStrategy.Strategy[0]);
        recommenderArray[1] = Recommenders.INSTANCE.visibleIf("neo4j.uri", new Predicate<Object>(){

            public boolean test(Object t) {
                boolean bl;
                block9: {
                    Object object = t;
                    if (object == null) {
                        bl = false;
                    } else if (object instanceof String) {
                        Object[] objectArray = new String[]{"bolt", "neo4j"};
                        bl = ArraysKt.contains((Object[])objectArray, (Object)new URI((String)t).getScheme());
                    } else if (object instanceof List) {
                        Iterable $this$any$iv = (Iterable)t;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            Iterator<T> iterator = $this$any$iv.iterator();
                            while (iterator.hasNext()) {
                                T element$iv;
                                T it = element$iv = iterator.next();
                                boolean bl2 = false;
                                if (!this.test((Object)it)) continue;
                                bl = true;
                                break block9;
                            }
                            bl = false;
                        }
                    } else {
                        throw new ConfigException("Must be a String or a List");
                    }
                }
                return bl;
            }
        });
        Predicate<Object> predicate = Predicate.isEqual(true);
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
        recommenderArray[2] = Recommenders.INSTANCE.visibleIf("neo4j.security.encrypted", predicate);
        $this$of.setRecommender(Recommenders.INSTANCE.and(recommenderArray));
        return Unit.INSTANCE;
    }

    private static final Unit defineEncryptionSettings$lambda$2(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.LOW);
        $this$of.setDefaultValue("true");
        $this$of.setGroup(Groups.CONNECTION_TLS.getTitle());
        $this$of.setValidator(Validators.INSTANCE.bool());
        ConfigDef.Recommender[] recommenderArray = new ConfigDef.Recommender[3];
        recommenderArray[0] = Recommenders.INSTANCE.bool();
        recommenderArray[1] = Recommenders.INSTANCE.visibleIf("neo4j.uri", new Predicate<Object>(){

            public boolean test(Object t) {
                boolean bl;
                block9: {
                    Object object = t;
                    if (object == null) {
                        bl = false;
                    } else if (object instanceof String) {
                        Object[] objectArray = new String[]{"bolt", "neo4j"};
                        bl = ArraysKt.contains((Object[])objectArray, (Object)new URI((String)t).getScheme());
                    } else if (object instanceof List) {
                        Iterable $this$any$iv = (Iterable)t;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            Iterator<T> iterator = $this$any$iv.iterator();
                            while (iterator.hasNext()) {
                                T element$iv;
                                T it = element$iv = iterator.next();
                                boolean bl2 = false;
                                if (!this.test((Object)it)) continue;
                                bl = true;
                                break block9;
                            }
                            bl = false;
                        }
                    } else {
                        throw new ConfigException("Must be a String or a List");
                    }
                }
                return bl;
            }
        });
        Predicate<Object> predicate = Predicate.isEqual(true);
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
        recommenderArray[2] = Recommenders.INSTANCE.visibleIf("neo4j.security.encrypted", predicate);
        $this$of.setRecommender(Recommenders.INSTANCE.and(recommenderArray));
        return Unit.INSTANCE;
    }

    private static final Unit defineEncryptionSettings$lambda$3(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.LOW);
        $this$of.setDefaultValue("");
        $this$of.setGroup(Groups.CONNECTION_TLS.getTitle());
        ConfigDef.Validator[] validatorArray = new ConfigDef.Validator[]{Validators.INSTANCE.blank(), Validators.file$default(Validators.INSTANCE, false, false, 3, null)};
        $this$of.setValidator(Validators.INSTANCE.or(validatorArray));
        validatorArray = new ConfigDef.Recommender[3];
        validatorArray[0] = Recommenders.INSTANCE.visibleIf("neo4j.uri", new Predicate<Object>(){

            public boolean test(Object t) {
                boolean bl;
                block9: {
                    Object object = t;
                    if (object == null) {
                        bl = false;
                    } else if (object instanceof String) {
                        Object[] objectArray = new String[]{"bolt", "neo4j"};
                        bl = ArraysKt.contains((Object[])objectArray, (Object)new URI((String)t).getScheme());
                    } else if (object instanceof List) {
                        Iterable $this$any$iv = (Iterable)t;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            Iterator<T> iterator = $this$any$iv.iterator();
                            while (iterator.hasNext()) {
                                T element$iv;
                                T it = element$iv = iterator.next();
                                boolean bl2 = false;
                                if (!this.test((Object)it)) continue;
                                bl = true;
                                break block9;
                            }
                            bl = false;
                        }
                    } else {
                        throw new ConfigException("Must be a String or a List");
                    }
                }
                return bl;
            }
        });
        Predicate<Object> predicate = Predicate.isEqual(true);
        Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
        validatorArray[1] = Recommenders.INSTANCE.visibleIf("neo4j.security.encrypted", predicate);
        Predicate<Object> predicate2 = Predicate.isEqual(Config.TrustStrategy.Strategy.TRUST_CUSTOM_CA_SIGNED_CERTIFICATES.toString());
        Intrinsics.checkNotNullExpressionValue(predicate2, (String)"isEqual(...)");
        validatorArray[2] = Recommenders.INSTANCE.visibleIf("neo4j.security.trust-strategy", predicate2);
        $this$of.setRecommender(Recommenders.INSTANCE.and((ConfigDef.Recommender[])validatorArray));
        return Unit.INSTANCE;
    }

    private static final Unit definePoolSettings$lambda$0(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.LOW);
        $this$of.setDefaultValue(DurationKt.toSimpleString-LRDsOJo(kotlin.time.DurationKt.toDuration((int)Config.defaultConfig().connectionTimeoutMillis(), (DurationUnit)DurationUnit.MILLISECONDS)));
        $this$of.setGroup(Groups.CONNECTION_ADVANCED.getTitle());
        $this$of.setValidator(Validators.INSTANCE.pattern(DurationKt.getSIMPLE_DURATION_PATTERN()));
        return Unit.INSTANCE;
    }

    private static final Unit definePoolSettings$lambda$1(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.LOW);
        $this$of.setDefaultValue(Config.defaultConfig().maxConnectionPoolSize());
        $this$of.setGroup(Groups.CONNECTION_ADVANCED.getTitle());
        $this$of.setValidator((ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1));
        return Unit.INSTANCE;
    }

    private static final Unit definePoolSettings$lambda$2(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.LOW);
        $this$of.setDefaultValue(DurationKt.toSimpleString-LRDsOJo(kotlin.time.DurationKt.toDuration((long)Config.defaultConfig().connectionAcquisitionTimeoutMillis(), (DurationUnit)DurationUnit.MILLISECONDS)));
        $this$of.setGroup(Groups.CONNECTION_ADVANCED.getTitle());
        $this$of.setValidator(Validators.INSTANCE.pattern(DurationKt.getSIMPLE_DURATION_PATTERN()));
        return Unit.INSTANCE;
    }

    private static final Unit definePoolSettings$lambda$3(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.LOW);
        $this$of.setDefaultValue(DurationKt.toSimpleString-LRDsOJo(kotlin.time.DurationKt.toDuration((long)Config.defaultConfig().maxConnectionLifetimeMillis(), (DurationUnit)DurationUnit.MILLISECONDS)));
        $this$of.setGroup(Groups.CONNECTION_ADVANCED.getTitle());
        $this$of.setValidator(Validators.INSTANCE.pattern(DurationKt.getSIMPLE_DURATION_PATTERN()));
        return Unit.INSTANCE;
    }

    private static final Unit definePoolSettings$lambda$4(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.LOW);
        $this$of.setDefaultValue("");
        $this$of.setGroup(Groups.CONNECTION_ADVANCED.getTitle());
        ConfigDef.Validator[] validatorArray = new ConfigDef.Validator[]{Validators.INSTANCE.blank(), Validators.INSTANCE.pattern(DurationKt.getSIMPLE_DURATION_PATTERN())};
        $this$of.setValidator(Validators.INSTANCE.or(validatorArray));
        return Unit.INSTANCE;
    }

    private static final Unit defineRetrySettings$lambda$0(ConfigKeyBuilder $this$of) {
        Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
        $this$of.setImportance(ConfigDef.Importance.LOW);
        $this$of.setDefaultValue(DurationKt.toSimpleString-LRDsOJo(Neo4jConfiguration.Companion.getDEFAULT_MAX_RETRY_DURATION-UwyO8pc()));
        $this$of.setGroup(Groups.CONNECTION_ADVANCED.getTitle());
        $this$of.setValidator(Validators.INSTANCE.pattern(DurationKt.getSIMPLE_DURATION_PATTERN()));
        return Unit.INSTANCE;
    }
}

