/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.configuration.helpers;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.common.config.types.Password;
import org.jetbrains.annotations.NotNull;
import org.neo4j.connectors.kafka.configuration.helpers.Validators;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\t\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000b\u001a\u00020\u0005J\u001f\u0010\f\u001a\u00020\u00052\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0007\"\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ=\u0010\u0010\u001a\u00020\u0005\"\u000e\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00110\u0007\"\u0002H\u0011\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u0017\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u000eJ\u000e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019J\u001f\u0010\u001a\u001a\u00020\u00052\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0007\"\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u001c\u001a\u00020\u00052\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u001eJ\u0012\u0010 \u001a\u00020!*\u00020\"2\u0006\u0010#\u001a\u00020\u000e\u00a8\u0006$"}, d2={"Lorg/neo4j/connectors/kafka/configuration/helpers/Validators;", "", "<init>", "()V", "and", "Lorg/apache/kafka/common/config/ConfigDef$Validator;", "validators", "", "([Lorg/apache/kafka/common/config/ConfigDef$Validator;)Lorg/apache/kafka/common/config/ConfigDef$Validator;", "or", "blank", "notBlankOrEmpty", "string", "values", "", "([Ljava/lang/String;)Lorg/apache/kafka/common/config/ConfigDef$Validator;", "enum", "T", "", "cls", "Ljava/lang/Class;", "exclude", "(Ljava/lang/Class;[Ljava/lang/Enum;)Lorg/apache/kafka/common/config/ConfigDef$Validator;", "bool", "pattern", "Ljava/util/regex/Pattern;", "uri", "schemes", "file", "readable", "", "writable", "validateNonEmptyIfVisible", "", "Lorg/apache/kafka/common/config/Config;", "name", "common"})
@SourceDebugExtension(value={"SMAP\nValidators.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Validators.kt\norg/neo4j/connectors/kafka/configuration/helpers/Validators\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,219:1\n4273#2:220\n4375#2,2:221\n14060#2,2:231\n1586#3:223\n1661#3,3:224\n231#3,2:229\n37#4,2:227\n*S KotlinDebug\n*F\n+ 1 Validators.kt\norg/neo4j/connectors/kafka/configuration/helpers/Validators\n*L\n107#1:220\n107#1:221,2\n31#1:231,2\n107#1:223\n107#1:224,3\n197#1:229,2\n107#1:227,2\n*E\n"})
public final class Validators {
    @NotNull
    public static final Validators INSTANCE = new Validators();

    private Validators() {
    }

    @NotNull
    public final ConfigDef.Validator and(ConfigDef.Validator ... validators) {
        Intrinsics.checkNotNullParameter((Object)validators, (String)"validators");
        return (arg_0, arg_1) -> Validators.and$lambda$0(validators, arg_0, arg_1);
    }

    @NotNull
    public final ConfigDef.Validator or(ConfigDef.Validator ... validators) {
        Intrinsics.checkNotNullParameter((Object)validators, (String)"validators");
        return (arg_0, arg_1) -> Validators.or$lambda$0(validators, arg_0, arg_1);
    }

    @NotNull
    public final ConfigDef.Validator blank() {
        return Validators::blank$lambda$0;
    }

    @NotNull
    public final ConfigDef.Validator notBlankOrEmpty() {
        return Validators::notBlankOrEmpty$lambda$0;
    }

    @NotNull
    public final ConfigDef.Validator string(String ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return new ConfigDef.Validator(values){
            final /* synthetic */ String[] $values;
            {
                this.$values = $values;
            }

            public void ensureValid(String name, Object value) {
                if (value instanceof String) {
                    if (!(this.$values.length == 0) && !ArraysKt.contains((Object[])this.$values, (Object)value)) {
                        throw new ConfigException(name, value, "Must be one of: " + ArraysKt.joinToString$default((Object[])this.$values, null, null, null, (int)0, null, string.1::ensureValid$lambda$0, (int)31, null) + ".");
                    }
                } else if (value instanceof List) {
                    Iterable $this$forEach$iv = (Iterable)value;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv;
                        T it = element$iv = iterator.next();
                        boolean bl = false;
                        this.ensureValid(name, it);
                    }
                } else {
                    throw new ConfigException(name, value, "Must be a String or a List.");
                }
            }

            private static final CharSequence ensureValid$lambda$0(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return "'" + it + "'";
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends Enum<T>> ConfigDef.Validator enum(@NotNull Class<T> cls, T ... exclude) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        Intrinsics.checkNotNullParameter(exclude, (String)"exclude");
        T[] TArray = cls.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(TArray, (String)"getEnumConstants(...)");
        T[] TArray2 = TArray;
        Validators validators = this;
        boolean $i$f$filterNot = false;
        void var6_6 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Enum element$iv$iv : $this$filterNotTo$iv$iv) {
            Enum it = element$iv$iv;
            boolean bl = false;
            if (ArraysKt.contains((Object[])exclude, (Object)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Enum element$iv$iv;
            element$iv$iv = (Enum)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        return validators.string(Arrays.copyOf(stringArray, stringArray.length));
    }

    @NotNull
    public final ConfigDef.Validator bool() {
        String[] stringArray = new String[]{"true", "false"};
        return this.string(stringArray);
    }

    @NotNull
    public final ConfigDef.Validator pattern(@NotNull String pattern2) {
        Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
        Pattern pattern3 = Pattern.compile(pattern2);
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(...)");
        return this.pattern(pattern3);
    }

    @NotNull
    public final ConfigDef.Validator pattern(@NotNull Pattern pattern2) {
        Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
        Predicate<String> predicate = pattern2.asPredicate();
        return new ConfigDef.Validator(predicate, pattern2){
            final /* synthetic */ Predicate<String> $predicate;
            final /* synthetic */ Pattern $pattern;
            {
                this.$predicate = $predicate;
                this.$pattern = $pattern;
            }

            public void ensureValid(String name, Object value) {
                if (value instanceof String) {
                    if (!this.$predicate.test((String)value)) {
                        throw new ConfigException(name, value, "Must match pattern '" + this.$pattern.pattern() + "'.");
                    }
                } else if (value instanceof List) {
                    Iterable $this$forEach$iv = (Iterable)value;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv;
                        T it = element$iv = iterator.next();
                        boolean bl = false;
                        this.ensureValid(name, it);
                    }
                } else {
                    throw new ConfigException(name, value, "Must be a String or a List.");
                }
            }
        };
    }

    @NotNull
    public final ConfigDef.Validator uri(String ... schemes) {
        Intrinsics.checkNotNullParameter((Object)schemes, (String)"schemes");
        return new ConfigDef.Validator(schemes){
            final /* synthetic */ String[] $schemes;
            {
                this.$schemes = $schemes;
            }

            public void ensureValid(String name, Object value) {
                block6: {
                    Validators.INSTANCE.notBlankOrEmpty().ensureValid(name, value);
                    Object object = value;
                    if (object instanceof String) {
                        try {
                            URI parsed = new URI((String)value);
                            if (!(this.$schemes.length == 0) && !ArraysKt.contains((Object[])this.$schemes, (Object)parsed.getScheme())) {
                                throw new ConfigException(name, value, "Scheme must be one of: " + ArraysKt.joinToString$default((Object[])this.$schemes, null, null, null, (int)0, null, uri.1::ensureValid$lambda$0, (int)31, null) + ".");
                            }
                            break block6;
                        }
                        catch (URISyntaxException t) {
                            throw new ConfigException(name, value, "Must be a valid URI: " + t.getMessage());
                        }
                    }
                    if (object instanceof List) {
                        Iterable $this$forEach$iv = (Iterable)value;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv.iterator();
                        while (iterator.hasNext()) {
                            T element$iv;
                            T it = element$iv = iterator.next();
                            boolean bl = false;
                            this.ensureValid(name, it);
                        }
                    }
                }
            }

            private static final CharSequence ensureValid$lambda$0(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return "'" + it + "'";
            }
        };
    }

    @NotNull
    public final ConfigDef.Validator file(boolean readable, boolean writable) {
        return new ConfigDef.Validator(readable, writable){
            final /* synthetic */ boolean $readable;
            final /* synthetic */ boolean $writable;
            {
                this.$readable = $readable;
                this.$writable = $writable;
            }

            public void ensureValid(String name, Object value) {
                Validators.INSTANCE.notBlankOrEmpty().ensureValid(name, value);
                Object object = value;
                if (object instanceof String) {
                    File file2 = new File((String)value);
                    if (!file2.isAbsolute()) {
                        throw new ConfigException(name, value, "Must be an absolute path.");
                    }
                    if (!file2.isFile()) {
                        throw new ConfigException(name, value, "Must be a file.");
                    }
                    if (this.$readable && !file2.canRead()) {
                        throw new ConfigException(name, value, "Must be readable.");
                    }
                    if (this.$writable && !file2.canWrite()) {
                        throw new ConfigException(name, value, "Must be writable.");
                    }
                } else if (object instanceof List) {
                    Iterable $this$forEach$iv = (Iterable)value;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv;
                        T it = element$iv = iterator.next();
                        boolean bl = false;
                        this.ensureValid(name, it);
                    }
                }
            }
        };
    }

    public static /* synthetic */ ConfigDef.Validator file$default(Validators validators, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return validators.file(bl, bl2);
    }

    public final void validateNonEmptyIfVisible(@NotNull Config $this$validateNonEmptyIfVisible, @NotNull String name) {
        Object element$iv2;
        block15: {
            Intrinsics.checkNotNullParameter((Object)$this$validateNonEmptyIfVisible, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            List list = $this$validateNonEmptyIfVisible.configValues();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"configValues(...)");
            Iterable $this$first$iv = list;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                ConfigValue it = (ConfigValue)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name(), (Object)name)) continue;
                break block15;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        ConfigValue config = (ConfigValue)element$iv2;
        boolean bl = false;
        if (config.visible()) {
            boolean bl2;
            Object value = config.value();
            if (value == null) {
                bl2 = true;
            } else if (value instanceof Integer) {
                bl2 = false;
            } else if (value instanceof Boolean) {
                bl2 = false;
            } else if (value instanceof String) {
                bl2 = ((CharSequence)value).length() == 0;
            } else if (value instanceof Password) {
                CharSequence charSequence = ((Password)value).value();
                bl2 = charSequence == null || charSequence.length() == 0;
            } else if (value instanceof List) {
                bl2 = ((List)value).isEmpty();
            } else {
                throw new IllegalArgumentException("unexpected value '" + value + "' for configuration " + name);
            }
            if (bl2) {
                config.addErrorMessage("Invalid value for configuration " + name + ": Must not be blank.");
            }
        }
    }

    private static final void and$lambda$0(ConfigDef.Validator[] $validators, String name, Object value) {
        ConfigDef.Validator[] $this$forEach$iv = $validators;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ConfigDef.Validator element$iv;
            ConfigDef.Validator it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.ensureValid(name, value);
        }
    }

    private static final void or$lambda$0(ConfigDef.Validator[] $validators, String name, Object value) {
        ConfigException lastError = null;
        for (ConfigDef.Validator i : $validators) {
            try {
                i.ensureValid(name, value);
                return;
            }
            catch (ConfigException t) {
                lastError = t;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
    }

    private static final void blank$lambda$0(String name, Object value) {
        if (value instanceof String) {
            if (!StringsKt.isBlank((CharSequence)((CharSequence)value))) {
                throw new ConfigException(name, value, "Must be blank.");
            }
        } else if (value instanceof List) {
            if (CollectionsKt.any((Iterable)((Iterable)value))) {
                throw new ConfigException(name, value, "Must be empty.");
            }
        } else {
            throw new ConfigException(name, value, "Must be a String or a List.");
        }
    }

    private static final void notBlankOrEmpty$lambda$0(String name, Object value) {
        if (value instanceof String) {
            if (StringsKt.isBlank((CharSequence)((CharSequence)value))) {
                throw new ConfigException(name, value, "Must not be blank.");
            }
        } else if (value instanceof List) {
            if (((List)value).isEmpty()) {
                throw new ConfigException(name, value, "Must not be empty.");
            }
        } else {
            throw new ConfigException(name, value, "Must be a String or a List.");
        }
    }
}

