/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.connect;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.header.Header;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\u00012\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\r\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u00d6\u0083\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\u0003H\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/neo4j/connectors/kafka/connect/ConnectHeader;", "Lorg/apache/kafka/connect/header/Header;", "key", "", "schemaAndValue", "Lorg/apache/kafka/connect/data/SchemaAndValue;", "<init>", "(Ljava/lang/String;Lorg/apache/kafka/connect/data/SchemaAndValue;)V", "schema", "Lorg/apache/kafka/connect/data/Schema;", "value", "", "with", "rename", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "common"})
public final class ConnectHeader
implements Header {
    @NotNull
    private final String key;
    @NotNull
    private final SchemaAndValue schemaAndValue;

    public ConnectHeader(@NotNull String key, @NotNull SchemaAndValue schemaAndValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)schemaAndValue, (String)"schemaAndValue");
        this.key = key;
        this.schemaAndValue = schemaAndValue;
    }

    @NotNull
    public String key() {
        return this.key;
    }

    @NotNull
    public Schema schema() {
        Schema schema = this.schemaAndValue.schema();
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
        return schema;
    }

    @NotNull
    public Object value() {
        Object object = this.schemaAndValue.value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        return object;
    }

    @NotNull
    public Header with(@Nullable Schema schema, @Nullable Object value) {
        Schema schema2 = schema;
        Intrinsics.checkNotNull((Object)schema2);
        Object object = value;
        Intrinsics.checkNotNull((Object)object);
        return new ConnectHeader(this.key, new SchemaAndValue(schema2, object));
    }

    @NotNull
    public Header rename(@Nullable String key) {
        String string2 = key;
        Intrinsics.checkNotNull((Object)string2);
        return new ConnectHeader(string2, this.schemaAndValue);
    }

    private final String component1() {
        return this.key;
    }

    private final SchemaAndValue component2() {
        return this.schemaAndValue;
    }

    @NotNull
    public final ConnectHeader copy(@NotNull String key, @NotNull SchemaAndValue schemaAndValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)schemaAndValue, (String)"schemaAndValue");
        return new ConnectHeader(key, schemaAndValue);
    }

    public static /* synthetic */ ConnectHeader copy$default(ConnectHeader connectHeader, String string2, SchemaAndValue schemaAndValue, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = connectHeader.key;
        }
        if ((n & 2) != 0) {
            schemaAndValue = connectHeader.schemaAndValue;
        }
        return connectHeader.copy(string2, schemaAndValue);
    }

    @NotNull
    public String toString() {
        return "ConnectHeader(key=" + this.key + ", schemaAndValue=" + this.schemaAndValue + ")";
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = result * 31 + this.schemaAndValue.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConnectHeader)) {
            return false;
        }
        ConnectHeader connectHeader = (ConnectHeader)other;
        if (!Intrinsics.areEqual((Object)this.key, (Object)connectHeader.key)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.schemaAndValue, (Object)connectHeader.schemaAndValue);
    }
}

