/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.data;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cdc.client.model.ChangeEvent;
import org.neo4j.cdc.client.model.ChangeIdentifier;
import org.neo4j.cdc.client.model.EntityOperation;
import org.neo4j.cdc.client.model.Event;
import org.neo4j.cdc.client.model.EventType;
import org.neo4j.cdc.client.model.Node;
import org.neo4j.cdc.client.model.NodeEvent;
import org.neo4j.cdc.client.model.NodeState;
import org.neo4j.cdc.client.model.RelationshipEvent;
import org.neo4j.cdc.client.model.RelationshipState;
import org.neo4j.connectors.kafka.data.DynamicTypes;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0004\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0004H\u0000\u001a\f\u0010\t\u001a\u00020\n*\u00020\u0004H\u0002\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\u0004H\u0000\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u0004H\u0000\u001a\u001c\u0010\u000f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010*\u00020\u0004H\u0000\u001a\u001c\u0010\u0012\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0010*\u00020\u0004H\u0000\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0004H\u0000\u00a8\u0006\u0016"}, d2={"extractEventSchema", "Lorg/apache/kafka/connect/data/Schema;", "Lorg/apache/kafka/connect/data/SchemaAndValue;", "extractEventValue", "Lorg/apache/kafka/connect/data/Struct;", "toChangeEvent", "Lorg/neo4j/cdc/client/model/ChangeEvent;", "toMetadata", "Lorg/neo4j/cdc/client/model/Metadata;", "toEvent", "Lorg/neo4j/cdc/client/model/Event;", "toNodeEvent", "Lorg/neo4j/cdc/client/model/NodeEvent;", "toRelationshipEvent", "Lorg/neo4j/cdc/client/model/RelationshipEvent;", "toNodeState", "Lkotlin/Pair;", "Lorg/neo4j/cdc/client/model/NodeState;", "toRelationshipState", "Lorg/neo4j/cdc/client/model/RelationshipState;", "toNode", "Lorg/neo4j/cdc/client/model/Node;", "common"})
public final class ChangeEventExtensionsKt {
    @NotNull
    public static final Schema extractEventSchema(@NotNull SchemaAndValue $this$extractEventSchema) {
        Intrinsics.checkNotNullParameter((Object)$this$extractEventSchema, (String)"<this>");
        Schema schema = $this$extractEventSchema.schema().field("event").schema();
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
        return schema;
    }

    @NotNull
    public static final Struct extractEventValue(@NotNull SchemaAndValue $this$extractEventValue) {
        Intrinsics.checkNotNullParameter((Object)$this$extractEventValue, (String)"<this>");
        Object value = $this$extractEventValue.value();
        if (!(value instanceof Struct)) {
            Object object = value;
            throw new IllegalArgumentException("expected value to be a struct, but got: " + (object != null ? object.getClass() : null));
        }
        Object eventData = ((Struct)value).get("event");
        if (!(eventData instanceof Struct)) {
            throw new IllegalArgumentException("expected event attribute to be a struct, but got: " + value.getClass());
        }
        return (Struct)eventData;
    }

    @NotNull
    public static final ChangeEvent toChangeEvent(@NotNull Struct $this$toChangeEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$toChangeEvent, (String)"<this>");
        ChangeIdentifier changeIdentifier = new ChangeIdentifier($this$toChangeEvent.getString("id"));
        Long l = $this$toChangeEvent.getInt64("txId");
        Integer n = (int)$this$toChangeEvent.getInt64("seq").longValue();
        Struct struct = $this$toChangeEvent.getStruct("metadata");
        Intrinsics.checkNotNullExpressionValue((Object)struct, (String)"getStruct(...)");
        org.neo4j.cdc.client.model.Metadata metadata = ChangeEventExtensionsKt.toMetadata(struct);
        Struct struct2 = $this$toChangeEvent.getStruct("event");
        Intrinsics.checkNotNullExpressionValue((Object)struct2, (String)"getStruct(...)");
        return new ChangeEvent(changeIdentifier, l, n, metadata, ChangeEventExtensionsKt.toEvent(struct2));
    }

    @NotNull
    public static final org.neo4j.cdc.client.model.Metadata toMetadata(@NotNull Struct $this$toMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$toMetadata, (String)"<this>");
        Schema schema = $this$toMetadata.schema();
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
        Object object = DynamicTypes.fromConnectValue$default(DynamicTypes.INSTANCE, schema, $this$toMetadata, false, 4, null);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
        org.neo4j.cdc.client.model.Metadata metadata = org.neo4j.cdc.client.model.Metadata.fromMap((Map)((Map)object));
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"fromMap(...)");
        return metadata;
    }

    private static final Event toEvent(Struct $this$toEvent) {
        Event event;
        String eventType = $this$toEvent.getString("eventType");
        if (Intrinsics.areEqual((Object)eventType, (Object)"NODE") || Intrinsics.areEqual((Object)eventType, (Object)EventType.NODE.shorthand)) {
            event = (Event)ChangeEventExtensionsKt.toNodeEvent($this$toEvent);
        } else if (Intrinsics.areEqual((Object)eventType, (Object)"RELATIONSHIP") || Intrinsics.areEqual((Object)eventType, (Object)EventType.RELATIONSHIP.shorthand)) {
            event = (Event)ChangeEventExtensionsKt.toRelationshipEvent($this$toEvent);
        } else {
            throw new IllegalArgumentException("unsupported event type " + eventType);
        }
        return event;
    }

    @NotNull
    public static final NodeEvent toNodeEvent(@NotNull Struct $this$toNodeEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$toNodeEvent, (String)"<this>");
        Struct struct = $this$toNodeEvent.getStruct("state");
        Intrinsics.checkNotNullExpressionValue((Object)struct, (String)"getStruct(...)");
        Pair<NodeState, NodeState> pair = ChangeEventExtensionsKt.toNodeState(struct);
        boolean bl = false;
        NodeState before = (NodeState)pair.component1();
        NodeState after = (NodeState)pair.component2();
        String string2 = $this$toNodeEvent.getString("elementId");
        String string3 = $this$toNodeEvent.getString("operation");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        EntityOperation entityOperation = EntityOperation.valueOf((String)string3);
        List list = $this$toNodeEvent.getArray("labels");
        Schema schema = $this$toNodeEvent.schema().field("keys").schema();
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
        return new NodeEvent(string2, entityOperation, list, (Map)DynamicTypes.INSTANCE.fromConnectValue(schema, $this$toNodeEvent.get("keys"), true), before, after);
    }

    @NotNull
    public static final RelationshipEvent toRelationshipEvent(@NotNull Struct $this$toRelationshipEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$toRelationshipEvent, (String)"<this>");
        Struct struct = $this$toRelationshipEvent.getStruct("state");
        Intrinsics.checkNotNullExpressionValue((Object)struct, (String)"getStruct(...)");
        Pair<RelationshipState, RelationshipState> pair = ChangeEventExtensionsKt.toRelationshipState(struct);
        boolean bl = false;
        RelationshipState before = (RelationshipState)pair.component1();
        RelationshipState after = (RelationshipState)pair.component2();
        String string2 = $this$toRelationshipEvent.getString("elementId");
        String string3 = $this$toRelationshipEvent.getString("type");
        Struct struct2 = $this$toRelationshipEvent.getStruct("start");
        Intrinsics.checkNotNullExpressionValue((Object)struct2, (String)"getStruct(...)");
        Node node = ChangeEventExtensionsKt.toNode(struct2);
        Struct struct3 = $this$toRelationshipEvent.getStruct("end");
        Intrinsics.checkNotNullExpressionValue((Object)struct3, (String)"getStruct(...)");
        Node node2 = ChangeEventExtensionsKt.toNode(struct3);
        Schema schema = $this$toRelationshipEvent.schema().field("keys").schema();
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
        List list = (List)DynamicTypes.INSTANCE.fromConnectValue(schema, $this$toRelationshipEvent.get("keys"), true);
        String string4 = $this$toRelationshipEvent.getString("operation");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
        return new RelationshipEvent(string2, string3, node, node2, list, EntityOperation.valueOf((String)string4), before, after);
    }

    @NotNull
    public static final Pair<NodeState, NodeState> toNodeState(@NotNull Struct $this$toNodeState) {
        NodeState nodeState;
        NodeState nodeState2;
        Map properties;
        Field propertiesField;
        List labels;
        Struct it;
        Intrinsics.checkNotNullParameter((Object)$this$toNodeState, (String)"<this>");
        Struct struct = $this$toNodeState.getStruct("before");
        if (struct != null) {
            Map map;
            it = struct;
            boolean bl = false;
            labels = it.getArray("labels");
            propertiesField = it.schema().field("properties");
            Schema.Type type = propertiesField.schema().type();
            switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    map = it.getMap("properties");
                    break;
                }
                case 2: {
                    map = it.getStruct("properties");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported schema type for properties");
                }
            }
            properties = map;
            Schema schema = propertiesField.schema();
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
            Object object = DynamicTypes.INSTANCE.fromConnectValue(schema, properties, true);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            nodeState2 = new NodeState(labels, (Map)object);
        } else {
            nodeState2 = null;
        }
        Struct struct2 = $this$toNodeState.getStruct("after");
        if (struct2 != null) {
            Map map;
            it = struct2;
            NodeState nodeState3 = nodeState2;
            boolean bl = false;
            labels = it.getArray("labels");
            propertiesField = it.schema().field("properties");
            Schema.Type type = propertiesField.schema().type();
            switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    map = it.getMap("properties");
                    break;
                }
                case 2: {
                    map = it.getStruct("properties");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported schema type for properties");
                }
            }
            properties = map;
            Schema schema = propertiesField.schema();
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
            Object object = DynamicTypes.INSTANCE.fromConnectValue(schema, properties, true);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            nodeState = new NodeState(labels, (Map)object);
            nodeState2 = nodeState3;
        } else {
            nodeState = null;
        }
        NodeState nodeState4 = nodeState;
        NodeState nodeState5 = nodeState2;
        return new Pair(nodeState5, nodeState4);
    }

    @NotNull
    public static final Pair<RelationshipState, RelationshipState> toRelationshipState(@NotNull Struct $this$toRelationshipState) {
        RelationshipState relationshipState;
        RelationshipState relationshipState2;
        Map properties;
        Field propertiesField;
        Struct it;
        Intrinsics.checkNotNullParameter((Object)$this$toRelationshipState, (String)"<this>");
        Struct struct = $this$toRelationshipState.getStruct("before");
        if (struct != null) {
            Map map;
            it = struct;
            boolean bl = false;
            propertiesField = it.schema().field("properties");
            Schema.Type type = propertiesField.schema().type();
            switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    map = it.getMap("properties");
                    break;
                }
                case 2: {
                    map = it.getStruct("properties");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported schema type for properties");
                }
            }
            properties = map;
            Schema schema = propertiesField.schema();
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
            Object object = DynamicTypes.INSTANCE.fromConnectValue(schema, properties, true);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            relationshipState2 = new RelationshipState((Map)object);
        } else {
            relationshipState2 = null;
        }
        Struct struct2 = $this$toRelationshipState.getStruct("after");
        if (struct2 != null) {
            Map map;
            it = struct2;
            RelationshipState relationshipState3 = relationshipState2;
            boolean bl = false;
            propertiesField = it.schema().field("properties");
            Schema.Type type = propertiesField.schema().type();
            switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    map = it.getMap("properties");
                    break;
                }
                case 2: {
                    map = it.getStruct("properties");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported schema type for properties");
                }
            }
            properties = map;
            Schema schema = propertiesField.schema();
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
            Object object = DynamicTypes.INSTANCE.fromConnectValue(schema, properties, true);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            relationshipState = new RelationshipState((Map)object);
            relationshipState2 = relationshipState3;
        } else {
            relationshipState = null;
        }
        RelationshipState relationshipState4 = relationshipState;
        RelationshipState relationshipState5 = relationshipState2;
        return new Pair(relationshipState5, relationshipState4);
    }

    @NotNull
    public static final Node toNode(@NotNull Struct $this$toNode) {
        Intrinsics.checkNotNullParameter((Object)$this$toNode, (String)"<this>");
        String string2 = $this$toNode.getString("elementId");
        List list = $this$toNode.getArray("labels");
        Schema schema = $this$toNode.schema().field("keys").schema();
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
        Object object = DynamicTypes.INSTANCE.fromConnectValue(schema, $this$toNode.get("keys"), true);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.collections.List<kotlin.collections.Map<kotlin.String, kotlin.Any>>>");
        return new Node(string2, list, (Map)object);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Schema.Type.values().length];
            try {
                nArray[Schema.Type.MAP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.STRUCT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

