/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.utils;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.neo4j.connectors.kafka.utils.StreamsPoint;
import org.neo4j.connectors.kafka.utils.StreamsPointCartesian2D;
import org.neo4j.connectors.kafka.utils.StreamsPointCartesian3D;
import org.neo4j.connectors.kafka.utils.StreamsPointWgs2D;
import org.neo4j.connectors.kafka.utils.StreamsPointWgs3D;
import org.neo4j.driver.internal.value.PointValue;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Point;
import org.neo4j.driver.types.Relationship;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005*\u00020\b\u001a\u0018\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005*\u00020\t\u00a8\u0006\n"}, d2={"toStreamsPoint", "Lorg/neo4j/connectors/kafka/utils/StreamsPoint;", "Lorg/neo4j/driver/internal/value/PointValue;", "Lorg/neo4j/driver/types/Point;", "asStreamsMap", "", "", "", "Lorg/neo4j/driver/types/Node;", "Lorg/neo4j/driver/types/Relationship;", "common"})
public final class JSONUtilsKt {
    @NotNull
    public static final StreamsPoint toStreamsPoint(@NotNull PointValue $this$toStreamsPoint) {
        Intrinsics.checkNotNullParameter((Object)$this$toStreamsPoint, (String)"<this>");
        Point point = $this$toStreamsPoint.asPoint();
        Intrinsics.checkNotNull((Object)point);
        return JSONUtilsKt.toStreamsPoint(point);
    }

    @NotNull
    public static final StreamsPoint toStreamsPoint(@NotNull Point $this$toStreamsPoint) {
        StreamsPoint streamsPoint;
        Intrinsics.checkNotNullParameter((Object)$this$toStreamsPoint, (String)"<this>");
        Point point = $this$toStreamsPoint;
        int crsType = point.srid();
        switch (crsType) {
            case 7203: {
                streamsPoint = new StreamsPointCartesian2D("cartesian", point.x(), point.y());
                break;
            }
            case 9157: {
                streamsPoint = new StreamsPointCartesian3D("cartesian-3d", point.x(), point.y(), point.z());
                break;
            }
            case 4326: {
                streamsPoint = new StreamsPointWgs2D("wgs-84", point.x(), point.y());
                break;
            }
            case 4979: {
                streamsPoint = new StreamsPointWgs3D("wgs-84-3d", point.x(), point.y(), point.z());
                break;
            }
            default: {
                throw new IllegalArgumentException("Point type " + crsType + " not supported");
            }
        }
        return streamsPoint;
    }

    @NotNull
    public static final Map<String, Object> asStreamsMap(@NotNull Node $this$asStreamsMap) {
        Intrinsics.checkNotNullParameter((Object)$this$asStreamsMap, (String)"<this>");
        Map map = $this$asStreamsMap.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"asMap(...)");
        Map nodeMap = MapsKt.toMutableMap((Map)map);
        nodeMap.put("<id>", $this$asStreamsMap.id());
        nodeMap.put("<labels>", $this$asStreamsMap.labels());
        return nodeMap;
    }

    @NotNull
    public static final Map<String, Object> asStreamsMap(@NotNull Relationship $this$asStreamsMap) {
        Intrinsics.checkNotNullParameter((Object)$this$asStreamsMap, (String)"<this>");
        Map map = $this$asStreamsMap.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"asMap(...)");
        Map relMap = MapsKt.toMutableMap((Map)map);
        relMap.put("<id>", $this$asStreamsMap.id());
        relMap.put("<type>", $this$asStreamsMap.type());
        relMap.put("<source.id>", $this$asStreamsMap.startNodeId());
        relMap.put("<target.id>", $this$asStreamsMap.endNodeId());
        return relMap;
    }
}

