/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cdc.client.model;

import java.util.Objects;

public enum EntityOperation {
    CREATE("c"),
    UPDATE("u"),
    DELETE("d");

    public final String shorthand;

    private EntityOperation(String shorthand) {
        this.shorthand = Objects.requireNonNull(shorthand);
    }

    public static EntityOperation fromShorthand(String shorthand) {
        if (EntityOperation.CREATE.shorthand.equalsIgnoreCase(shorthand)) {
            return CREATE;
        }
        if (EntityOperation.UPDATE.shorthand.equalsIgnoreCase(shorthand)) {
            return UPDATE;
        }
        if (EntityOperation.DELETE.shorthand.equalsIgnoreCase(shorthand)) {
            return DELETE;
        }
        throw new IllegalArgumentException(String.format("unknown event type: %s", shorthand));
    }
}

