/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cdc.client.model;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.neo4j.cdc.client.model.CaptureMode;
import org.neo4j.cdc.client.model.ModelUtils;

public class Metadata {
    private static final String EXECUTING_USER = "executingUser";
    private static final String CONNECTION_CLIENT = "connectionClient";
    private static final String AUTHENTICATED_USER = "authenticatedUser";
    private static final String DATABASE_NAME = "databaseName";
    private static final String CAPTURE_MODE = "captureMode";
    private static final String SERVER_ID = "serverId";
    private static final String CONNECTION_TYPE = "connectionType";
    private static final String CONNECTION_SERVER = "connectionServer";
    private static final String TX_START_TIME = "txStartTime";
    private static final String TX_COMMIT_TIME = "txCommitTime";
    private static final String TX_METADATA = "txMetadata";
    private static final List<String> KNOWN_KEYS = List.of("executingUser", "authenticatedUser", "connectionType", "connectionClient", "connectionServer", "databaseName", "captureMode", "serverId", "txCommitTime", "txStartTime", "txMetadata");
    private final String executingUser;
    private final String connectionClient;
    private final String authenticatedUser;
    private final CaptureMode captureMode;
    private final String serverId;
    private final String databaseName;
    private final String connectionType;
    private final String connectionServer;
    private final ZonedDateTime txStartTime;
    private final ZonedDateTime txCommitTime;
    private final Map<String, Object> txMetadata;
    private final Map<String, Object> additionalEntries;

    public Metadata(String authenticatedUser, String executingUser, String serverId, String databaseName, CaptureMode captureMode, String connectionType, String connectionClient, String connectionServer, ZonedDateTime txStartTime, ZonedDateTime txCommitTime, Map<String, Object> txMetadata, Map<String, Object> additionalEntries) {
        this.executingUser = executingUser;
        this.connectionClient = connectionClient;
        this.authenticatedUser = authenticatedUser;
        this.captureMode = Objects.requireNonNull(captureMode);
        this.databaseName = Objects.requireNonNullElse(databaseName, "");
        this.serverId = Objects.requireNonNull(serverId);
        this.connectionType = Objects.requireNonNull(connectionType);
        this.connectionServer = connectionServer;
        this.txStartTime = Objects.requireNonNull(txStartTime);
        this.txCommitTime = Objects.requireNonNull(txCommitTime);
        this.txMetadata = txMetadata;
        this.additionalEntries = additionalEntries;
    }

    public String getExecutingUser() {
        return this.executingUser;
    }

    public String getConnectionClient() {
        return this.connectionClient;
    }

    public String getAuthenticatedUser() {
        return this.authenticatedUser;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public CaptureMode getCaptureMode() {
        return this.captureMode;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public String getConnectionServer() {
        return this.connectionServer;
    }

    public ZonedDateTime getTxStartTime() {
        return this.txStartTime;
    }

    public ZonedDateTime getTxCommitTime() {
        return this.txCommitTime;
    }

    public Map<String, Object> getAdditionalEntries() {
        return this.additionalEntries;
    }

    public Map<String, Object> getTxMetadata() {
        return this.txMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        if (!Objects.equals(this.executingUser, metadata.executingUser)) {
            return false;
        }
        if (!Objects.equals(this.connectionClient, metadata.connectionClient)) {
            return false;
        }
        if (!Objects.equals(this.authenticatedUser, metadata.authenticatedUser)) {
            return false;
        }
        if (this.captureMode != metadata.captureMode) {
            return false;
        }
        if (!this.serverId.equals(metadata.serverId)) {
            return false;
        }
        if (!this.connectionType.equals(metadata.connectionType)) {
            return false;
        }
        if (!Objects.equals(this.connectionServer, metadata.connectionServer)) {
            return false;
        }
        if (!this.txStartTime.equals(metadata.txStartTime)) {
            return false;
        }
        if (!this.txCommitTime.equals(metadata.txCommitTime)) {
            return false;
        }
        return Objects.equals(this.additionalEntries, metadata.additionalEntries);
    }

    public int hashCode() {
        int result = this.executingUser != null ? this.executingUser.hashCode() : 0;
        result = 31 * result + (this.connectionClient != null ? this.connectionClient.hashCode() : 0);
        result = 31 * result + (this.authenticatedUser != null ? this.authenticatedUser.hashCode() : 0);
        result = 31 * result + this.captureMode.hashCode();
        result = 31 * result + this.serverId.hashCode();
        result = 31 * result + this.connectionType.hashCode();
        result = 31 * result + (this.connectionServer != null ? this.connectionServer.hashCode() : 0);
        result = 31 * result + this.txStartTime.hashCode();
        result = 31 * result + this.txCommitTime.hashCode();
        result = 31 * result + (this.additionalEntries != null ? this.additionalEntries.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("Metadata{authenticatedUser=%s, executingUser=%s, serverId=%s, databaseName=%s, captureMode=%s, connectionType=%s, connectionClient=%s, connectionServer=%s, txStartTime=%s, txCommitTime=%s, additionalEntries=%s}", new Object[]{this.authenticatedUser, this.executingUser, this.serverId, this.databaseName, this.captureMode, this.connectionType, this.connectionClient, this.connectionServer, this.txStartTime, this.txCommitTime, this.additionalEntries});
    }

    public static Metadata fromMap(Map<?, ?> map) {
        Map<String, Object> cypherMap = ModelUtils.checkedMap(Objects.requireNonNull(map), String.class, Object.class);
        String authenticatedUser = MapUtils.getString(cypherMap, (Object)AUTHENTICATED_USER);
        String executingUser = MapUtils.getString(cypherMap, (Object)EXECUTING_USER);
        String databaseName = MapUtils.getString(cypherMap, (Object)DATABASE_NAME);
        CaptureMode captureMode = CaptureMode.valueOf(MapUtils.getString(cypherMap, (Object)CAPTURE_MODE));
        String serverId = MapUtils.getString(cypherMap, (Object)SERVER_ID);
        String connectionType = MapUtils.getString(cypherMap, (Object)CONNECTION_TYPE);
        String connectionClient = MapUtils.getString(cypherMap, (Object)CONNECTION_CLIENT);
        String connectionServer = MapUtils.getString(cypherMap, (Object)CONNECTION_SERVER);
        ZonedDateTime txStartTime = ModelUtils.getZonedDateTime(cypherMap, TX_START_TIME);
        ZonedDateTime txCommitTime = ModelUtils.getZonedDateTime(cypherMap, TX_COMMIT_TIME);
        Map txMetadata = MapUtils.getMap(cypherMap, (Object)TX_METADATA);
        Map<String, Object> unknownEntries = cypherMap.entrySet().stream().filter(e -> !KNOWN_KEYS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new Metadata(authenticatedUser, executingUser, serverId, databaseName, captureMode, connectionType, connectionClient, connectionServer, txStartTime, txCommitTime, txMetadata, unknownEntries);
    }
}

