/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cdc.client.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.neo4j.cdc.client.model.ModelUtils;

public class Node {
    private final String elementId;
    private final Map<String, List<Map<String, Object>>> keys;
    private final List<String> labels;

    public Node(String elementId, List<String> labels, Map<String, List<Map<String, Object>>> keys) {
        this.elementId = Objects.requireNonNull(elementId);
        this.labels = labels;
        this.keys = keys;
    }

    public String getElementId() {
        return this.elementId;
    }

    public Map<String, List<Map<String, Object>>> getKeys() {
        return this.keys;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        if (!this.elementId.equals(node.elementId)) {
            return false;
        }
        if (!Objects.equals(this.keys, node.keys)) {
            return false;
        }
        return Objects.equals(this.labels, node.labels);
    }

    public int hashCode() {
        int result = this.elementId.hashCode();
        result = 31 * result + (this.keys != null ? this.keys.hashCode() : 0);
        result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("Node{elementId=%s, labels=%s, keys=%s}", this.elementId, this.labels, this.keys);
    }

    public static Node fromMap(Map<?, ?> map) {
        Map<String, Object> cypherMap = ModelUtils.checkedMap(Objects.requireNonNull(map), String.class, Object.class);
        String elementId = MapUtils.getString(cypherMap, (Object)"elementId");
        List<String> labels = ModelUtils.getList(cypherMap, "labels", String.class);
        Map<String, List<Map<String, Object>>> keys = ModelUtils.getNodesKeys(cypherMap);
        return new Node(elementId, labels, keys);
    }
}

