/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cdc.client.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.neo4j.cdc.client.model.ModelUtils;
import org.neo4j.cdc.client.model.State;

public class NodeState
extends State {
    private final List<String> labels;

    public NodeState(List<String> labels, Map<String, Object> properties) {
        super(properties);
        this.labels = labels;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeState nodeState = (NodeState)o;
        if (!Objects.equals(this.labels, nodeState.labels)) {
            return false;
        }
        return Objects.equals(this.getProperties(), nodeState.getProperties());
    }

    public int hashCode() {
        int result = this.labels != null ? this.labels.hashCode() : 0;
        result = 31 * result + (this.getProperties() != null ? this.getProperties().hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("NodeState{labels=%s, properties=%s}", this.labels, this.getProperties());
    }

    public static NodeState fromMap(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        Map<String, Object> cypherMap = ModelUtils.checkedMap(map, String.class, Object.class);
        List<String> labels = ModelUtils.getList(cypherMap, "labels", String.class);
        Map<String, Object> properties = ModelUtils.checkedMap(MapUtils.getMap(cypherMap, (Object)"properties"), String.class, Object.class);
        return new NodeState(labels, properties);
    }
}

