/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cdc.client.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.neo4j.cdc.client.pattern.NodePattern;
import org.neo4j.cdc.client.pattern.Pattern;
import org.neo4j.cdc.client.pattern.PatternException;
import org.neo4j.cdc.client.pattern.PatternLexer;
import org.neo4j.cdc.client.pattern.PatternParser;
import org.neo4j.cdc.client.pattern.PatternParserBaseVisitor;
import org.neo4j.cdc.client.pattern.RelationshipPattern;

class Visitors {
    Visitors() {
    }

    static List<Pattern> parse(String source) {
        CodePointCharStream input = CharStreams.fromString((String)source);
        PatternLexer lexer = new PatternLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        PatternParser parser = new PatternParser((TokenStream)tokens);
        final ArrayList errors = new ArrayList();
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                errors.add(String.format("line %d:%d, %s", line, charPositionInLine, msg));
            }
        });
        PatternParser.PatternListContext patternList = parser.patternList();
        if (!errors.isEmpty()) {
            throw new PatternException(String.join((CharSequence)", ", errors));
        }
        return patternList.pattern().stream().map(PatternVisitor.INSTANCE::visitPattern).collect(Collectors.toList());
    }

    private static class LiteralVisitor
    extends PatternParserBaseVisitor<Object> {
        private static final LiteralVisitor INSTANCE = new LiteralVisitor();

        private LiteralVisitor() {
        }

        @Override
        public Object visitKeywordLiteral(PatternParser.KeywordLiteralContext ctx) {
            if (ctx.INF() != null || ctx.INFINITY() != null) {
                return Double.POSITIVE_INFINITY;
            }
            if (ctx.NAN() != null) {
                return Double.NaN;
            }
            throw new PatternException(String.format("unsupported keyword literal: '%s'", new Object[]{ctx}));
        }

        @Override
        public Object visitBooleanLiteral(PatternParser.BooleanLiteralContext ctx) {
            return ctx.TRUE() != null;
        }

        @Override
        public Object visitOtherLiteral(PatternParser.OtherLiteralContext ctx) {
            if (ctx.mapLiteral() != null) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                List<PatternParser.PropertyKeyNameContext> mapProps = ctx.mapLiteral().propertyKeyName();
                List<PatternParser.ExpressionContext> mapExps = ctx.mapLiteral().expression();
                for (int i = 0; i < mapProps.size(); ++i) {
                    result.put((String)SymbolicNameStringVisitor.INSTANCE.visit((ParseTree)mapProps.get(i)), ExpressionVisitor.INSTANCE.visitExpression(mapExps.get(i)));
                }
                return result;
            }
            if (ctx.listLiteral() != null) {
                return ctx.listLiteral().expression().stream().map(ExpressionVisitor.INSTANCE::visitExpression).collect(Collectors.toList());
            }
            throw new PatternException(String.format("unsupported literal: '%s'", new Object[]{ctx}));
        }

        @Override
        public Object visitStringsLiteral(PatternParser.StringsLiteralContext ctx) {
            String text = ctx.getText();
            return text.substring(1, text.length() - 1);
        }

        @Override
        public Object visitNumericLiteral(PatternParser.NumericLiteralContext ctx) {
            int multiplier;
            PatternParser.NumberLiteralContext number = ctx.numberLiteral();
            int n = multiplier = number.MINUS() != null ? -1 : 1;
            if (number.DECIMAL_DOUBLE() != null) {
                return Double.parseDouble(number.DECIMAL_DOUBLE().getText()) * (double)multiplier;
            }
            if (number.UNSIGNED_DECIMAL_INTEGER() != null) {
                return Long.parseLong(number.UNSIGNED_DECIMAL_INTEGER().getText(), 10) * (long)multiplier;
            }
            if (number.UNSIGNED_HEX_INTEGER() != null) {
                return Long.parseLong(number.UNSIGNED_HEX_INTEGER().getText().substring(2), 16) * (long)multiplier;
            }
            if (number.UNSIGNED_OCTAL_INTEGER() != null) {
                return Long.parseLong(number.UNSIGNED_OCTAL_INTEGER().getText().substring(2), 8) * (long)multiplier;
            }
            throw new PatternException(String.format("unexpected number literal '%s'", new Object[]{ctx}));
        }
    }

    private static class ExpressionVisitor
    extends PatternParserBaseVisitor<Object> {
        public static final ExpressionVisitor INSTANCE = new ExpressionVisitor();

        private ExpressionVisitor() {
        }

        @Override
        public Object visitExpression(PatternParser.ExpressionContext ctx) {
            if (ctx.literal() != null) {
                return ctx.literal().accept(LiteralVisitor.INSTANCE);
            }
            throw new PatternException(String.format("unsupported expression: '%s'", new Object[]{ctx}));
        }
    }

    private static class SymbolicNameStringVisitor
    extends PatternParserBaseVisitor<String> {
        public static final SymbolicNameStringVisitor INSTANCE = new SymbolicNameStringVisitor();

        private SymbolicNameStringVisitor() {
        }

        @Override
        public String visitSymbolicNameString(PatternParser.SymbolicNameStringContext ctx) {
            return (String)super.visitSymbolicNameString(ctx);
        }

        @Override
        public String visitEscapedSymbolicNameString(PatternParser.EscapedSymbolicNameStringContext ctx) {
            return ctx.getText();
        }

        @Override
        public String visitUnescapedSymbolicNameString(PatternParser.UnescapedSymbolicNameStringContext ctx) {
            return ctx.getText();
        }
    }

    private static class PropertyKeyNameVisitor
    extends PatternParserBaseVisitor<String> {
        public static final PropertyKeyNameVisitor INSTANCE = new PropertyKeyNameVisitor();

        private PropertyKeyNameVisitor() {
        }

        @Override
        public String visitPropertyKeyName(PatternParser.PropertyKeyNameContext ctx) {
            return SymbolicNameStringVisitor.INSTANCE.visitSymbolicNameString(ctx.symbolicNameString());
        }
    }

    private static class LabelOrRelTypeVisitor
    extends PatternParserBaseVisitor<String> {
        public static final LabelOrRelTypeVisitor INSTANCE = new LabelOrRelTypeVisitor();

        private LabelOrRelTypeVisitor() {
        }

        @Override
        public String visitLabelOrRelType(PatternParser.LabelOrRelTypeContext ctx) {
            if (ctx == null) {
                return null;
            }
            return SymbolicNameStringVisitor.INSTANCE.visitSymbolicNameString(ctx.symbolicNameString());
        }
    }

    private static class NodeLabelsVisitor
    extends PatternParserBaseVisitor<Set<String>> {
        public static final NodeLabelsVisitor INSTANCE = new NodeLabelsVisitor();

        private NodeLabelsVisitor() {
        }

        @Override
        public Set<String> visitNodeLabels(PatternParser.NodeLabelsContext ctx) {
            if (ctx == null || ctx.labelOrRelType() == null) {
                return Set.of();
            }
            return ctx.labelOrRelType().stream().map(LabelOrRelTypeVisitor.INSTANCE::visitLabelOrRelType).collect(Collectors.toSet());
        }
    }

    private static class PatternVisitor
    extends PatternParserBaseVisitor<Pattern> {
        public static final PatternVisitor INSTANCE = new PatternVisitor();

        private PatternVisitor() {
        }

        @Override
        public Pattern visitPattern(PatternParser.PatternContext ctx) {
            if (ctx.relationshipPattern() != null) {
                NodePattern startNode;
                PatternParser.RelationshipPatternContext relPattern = ctx.relationshipPattern();
                boolean bidirectional = relPattern.leftArrow() != null && relPattern.rightArrow() != null || relPattern.leftArrow() == null && relPattern.rightArrow() == null;
                HashMap<String, Object> keyFilters = new HashMap<String, Object>();
                HashSet<String> includeProperties = new HashSet<String>();
                HashSet<String> excludeProperties = new HashSet<String>();
                if (relPattern.properties() != null && relPattern.properties().propertySelector() != null) {
                    this.extractPropertySelectors(relPattern.properties().propertySelector().keyFilterOrPropSelector(), keyFilters, includeProperties, excludeProperties);
                }
                if (!(startNode = this.visitNodePattern(ctx.nodePattern(bidirectional || relPattern.rightArrow() != null ? 0 : 1))).getExcludeProperties().isEmpty() || !startNode.getIncludeProperties().isEmpty()) {
                    throw new PatternException("property selectors are not allowed in node part of relationship patterns");
                }
                NodePattern endNode = this.visitNodePattern(ctx.nodePattern(bidirectional || relPattern.rightArrow() != null ? 1 : 0));
                if (!endNode.getExcludeProperties().isEmpty() || !endNode.getIncludeProperties().isEmpty()) {
                    throw new PatternException("property selectors are not allowed in node part of relationship patterns");
                }
                return new RelationshipPattern(LabelOrRelTypeVisitor.INSTANCE.visitLabelOrRelType(relPattern.labelOrRelType()), startNode, endNode, bidirectional, keyFilters, includeProperties, excludeProperties);
            }
            return this.visitNodePattern(ctx.nodePattern(0));
        }

        @Override
        public NodePattern visitNodePattern(PatternParser.NodePatternContext ctx) {
            Object labels = NodeLabelsVisitor.INSTANCE.visitNodeLabels(ctx.nodeLabels());
            HashMap<String, Object> keyFilters = new HashMap<String, Object>();
            HashSet<String> includeProperties = new HashSet<String>();
            HashSet<String> excludeProperties = new HashSet<String>();
            if (ctx.properties() != null && ctx.properties().propertySelector() != null) {
                this.extractPropertySelectors(ctx.properties().propertySelector().keyFilterOrPropSelector(), keyFilters, includeProperties, excludeProperties);
            }
            return new NodePattern((Set<String>)labels, keyFilters, includeProperties, excludeProperties);
        }

        private void extractPropertySelectors(List<PatternParser.KeyFilterOrPropSelectorContext> selectors, Map<String, Object> keyFilters, Set<String> includeProperties, Set<String> excludeProperties) {
            selectors.forEach(child -> {
                if (child.keyFilter() != null) {
                    String propName = PropertyKeyNameVisitor.INSTANCE.visitPropertyKeyName(child.keyFilter().propertyKeyName());
                    Object value = ExpressionVisitor.INSTANCE.visitExpression(child.keyFilter().expression());
                    keyFilters.put(propName, value);
                } else if (child.propSelector() != null) {
                    if (child.propSelector().TIMES() != null) {
                        includeProperties.add("*");
                    } else if (child.propSelector().MINUS() != null) {
                        excludeProperties.add(PropertyKeyNameVisitor.INSTANCE.visitPropertyKeyName(child.propSelector().propertyKeyName()));
                    } else {
                        includeProperties.add(PropertyKeyNameVisitor.INSTANCE.visitPropertyKeyName(child.propSelector().propertyKeyName()));
                    }
                }
            });
        }
    }
}

