/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jspecify.annotations.Nullable;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InternalFluxOperator;
import reactor.core.publisher.Operators;

final class FluxDefaultIfEmpty<T>
extends InternalFluxOperator<T, T> {
    final T value;

    FluxDefaultIfEmpty(Flux<? extends T> source, T value) {
        super(source);
        this.value = Objects.requireNonNull(value, "value");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new DefaultIfEmptySubscriber<T>(actual, this.value);
    }

    @Override
    public @Nullable Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }

    static final class DefaultIfEmptySubscriber<T>
    extends Operators.BaseFluxToMonoOperator<T, T> {
        boolean done;
        boolean hasValue;
        volatile @Nullable T fallbackValue;
        static final AtomicReferenceFieldUpdater<DefaultIfEmptySubscriber, @Nullable Object> FALLBACK_VALUE = AtomicReferenceFieldUpdater.newUpdater(DefaultIfEmptySubscriber.class, Object.class, "fallbackValue");

        DefaultIfEmptySubscriber(CoreSubscriber<? super T> actual, T fallbackValue) {
            super(actual);
            FALLBACK_VALUE.lazySet(this, fallbackValue);
        }

        @Override
        public @Nullable Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            return super.scanUnsafe(key);
        }

        @Override
        public void request(long n) {
            if (!this.hasRequest) {
                this.hasRequest = true;
                int state = this.state;
                if (state != 1 && STATE.compareAndSet(this, state, state | 1) && state > 1) {
                    T fallbackValue = this.fallbackValue;
                    if (fallbackValue != null && FALLBACK_VALUE.compareAndSet(this, fallbackValue, null)) {
                        this.actual.onNext(fallbackValue);
                        this.actual.onComplete();
                    }
                    return;
                }
            }
            this.s.request(n);
        }

        @Override
        public void cancel() {
            super.cancel();
            T fallbackValue = this.fallbackValue;
            if (fallbackValue != null && FALLBACK_VALUE.compareAndSet(this, fallbackValue, null)) {
                Operators.onDiscard(fallbackValue, this.actual.currentContext());
            }
        }

        public void onNext(T t) {
            if (!this.hasValue) {
                this.hasValue = true;
                T fallbackValue = this.fallbackValue;
                if (fallbackValue != null && FALLBACK_VALUE.compareAndSet(this, fallbackValue, null)) {
                    Operators.onDiscard(fallbackValue, this.actual.currentContext());
                }
            }
            this.actual.onNext(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            if (!this.hasValue) {
                this.completePossiblyEmpty();
                return;
            }
            this.actual.onComplete();
        }

        public void onError(Throwable t) {
            T fallbackValue;
            if (this.done) {
                return;
            }
            this.done = true;
            if (!this.hasValue && (fallbackValue = this.fallbackValue) != null && FALLBACK_VALUE.compareAndSet(this, fallbackValue, null)) {
                Operators.onDiscard(t, this.actual.currentContext());
            }
            this.actual.onError(t);
        }

        @Override
        @Nullable T accumulatedValue() {
            T fallbackValue = this.fallbackValue;
            if (fallbackValue != null && FALLBACK_VALUE.compareAndSet(this, fallbackValue, null)) {
                return fallbackValue;
            }
            return null;
        }
    }
}

