/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cdc.client.model.EntityOperation;
import org.neo4j.cdc.client.pattern.Pattern;
import org.neo4j.cdc.client.pattern.PatternException;
import org.neo4j.cdc.client.selector.EntitySelector;
import org.neo4j.cdc.client.selector.NodeSelector;
import org.neo4j.cdc.client.selector.RelationshipSelector;
import org.neo4j.cdc.client.selector.Selector;
import org.neo4j.connectors.kafka.configuration.ConnectorType;
import org.neo4j.connectors.kafka.configuration.Groups;
import org.neo4j.connectors.kafka.configuration.Neo4jConfiguration;
import org.neo4j.connectors.kafka.configuration.PayloadMode;
import org.neo4j.connectors.kafka.configuration.helpers.ConfigKeyBuilder;
import org.neo4j.connectors.kafka.configuration.helpers.Recommenders;
import org.neo4j.connectors.kafka.configuration.helpers.Validators;
import org.neo4j.connectors.kafka.source.Neo4jCdcKeyStrategy;
import org.neo4j.connectors.kafka.source.Neo4jCdcValueStrategy;
import org.neo4j.connectors.kafka.source.SourceType;
import org.neo4j.connectors.kafka.source.StartFrom;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 d2\u00020\u0001:\u0002cdB\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J>\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070I2\u0018\u0010J\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020L0K0IH\u0002J>\u0010M\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070I2\u0018\u0010J\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020L0K0IH\u0002J>\u0010N\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070I2\u0018\u0010J\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020L0K0IH\u0002J^\u0010O\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070I2\u0018\u0010J\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020L0K0I2\u001e\u0010P\u001a\u001a\u0012\u0004\u0012\u00020L\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020/0I0IH\u0002J\u001c\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020=0R2\u0006\u0010F\u001a\u00020GH\u0002J\u001c\u0010S\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020A0R2\u0006\u0010F\u001a\u00020GH\u0002JP\u0010T\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020L0K0R2\u0006\u0010F\u001a\u00020G2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070I2\u0018\u0010J\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020L0K0IH\u0002J4\u0010U\u001a\u0014\u0012\u0004\u0012\u000207\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f080\u00032\u0018\u0010V\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020L080\u0003H\u0002J-\u0010\\\u001a\u00020]2#\u0010^\u001a\u001f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020/0I\u0012\u0004\u0012\u00020E0_\u00a2\u0006\u0002\b`H\u0016J\b\u0010a\u001a\u00020\u000fH\u0016J\u0006\u0010b\u001a\u00020ER\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0011R\u0011\u0010\u001e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0011R\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010#R\u0011\u0010,\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0011R\u001d\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020/0\u00038F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010#R\u0011\u00104\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010#R-\u00106\u001a\u0014\u0012\u0004\u0012\u000207\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f080\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b9\u00101R'\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020=0\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010;\u001a\u0004\b>\u00101R'\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020A0\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u0010;\u001a\u0004\bB\u00101R!\u0010W\u001a\b\u0012\u0004\u0012\u0002070X8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b[\u0010;\u001a\u0004\bY\u0010Z\u00a8\u0006e"}, d2={"Lorg/neo4j/connectors/kafka/source/SourceConfiguration;", "Lorg/neo4j/connectors/kafka/configuration/Neo4jConfiguration;", "originals", "", "<init>", "(Ljava/util/Map;)V", "forceMapsAsStruct", "", "getForceMapsAsStruct", "()Z", "startFrom", "Lorg/neo4j/connectors/kafka/source/StartFrom;", "getStartFrom", "()Lorg/neo4j/connectors/kafka/source/StartFrom;", "startFromCustom", "", "getStartFromCustom", "()Ljava/lang/String;", "ignoreStoredOffset", "getIgnoreStoredOffset", "strategy", "Lorg/neo4j/connectors/kafka/source/SourceType;", "getStrategy", "()Lorg/neo4j/connectors/kafka/source/SourceType;", "payloadMode", "Lorg/neo4j/connectors/kafka/configuration/PayloadMode;", "getPayloadMode", "()Lorg/neo4j/connectors/kafka/configuration/PayloadMode;", "query", "getQuery", "queryStreamingProperty", "getQueryStreamingProperty", "queryPollingInterval", "Lkotlin/time/Duration;", "getQueryPollingInterval-UwyO8pc", "()J", "queryPollingDuration", "getQueryPollingDuration-UwyO8pc", "batchSize", "", "getBatchSize", "()I", "queryTimeout", "getQueryTimeout-UwyO8pc", "topic", "getTopic", "partition", "", "getPartition", "()Ljava/util/Map;", "cdcPollingInterval", "getCdcPollingInterval-UwyO8pc", "cdcPollingDuration", "getCdcPollingDuration-UwyO8pc", "cdcSelectorsToTopics", "Lorg/neo4j/cdc/client/selector/Selector;", "", "getCdcSelectorsToTopics", "cdcSelectorsToTopics$delegate", "Lkotlin/Lazy;", "cdcTopicsToKeyStrategy", "Lorg/neo4j/connectors/kafka/source/Neo4jCdcKeyStrategy;", "getCdcTopicsToKeyStrategy", "cdcTopicsToKeyStrategy$delegate", "cdcTopicsToValueStrategy", "Lorg/neo4j/connectors/kafka/source/Neo4jCdcValueStrategy;", "getCdcTopicsToValueStrategy", "cdcTopicsToValueStrategy$delegate", "mapPositionalPattern", "", "configEntry", "Lorg/neo4j/connectors/kafka/source/SourceConfiguration$CdcPatternConfigItem;", "nonPositionalConfigMode", "", "configMap", "", "Lorg/neo4j/cdc/client/pattern/Pattern;", "mapOperation", "mapChangesTo", "mapMetadata", "patternTxMetadataMap", "mapKeyStrategy", "Lkotlin/Pair;", "mapValueStrategy", "retrieveIndexAndPattern", "pivotMapCdcSelectorMap", "patternMap", "cdcSelectors", "", "getCdcSelectors", "()Ljava/util/Set;", "cdcSelectors$delegate", "txConfig", "Lorg/neo4j/driver/TransactionConfig;", "applyCustomMetadata", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "userAgentComment", "validate", "CdcPatternConfigItem", "Companion", "source"})
@SourceDebugExtension(value={"SMAP\nSourceConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceConfiguration.kt\norg/neo4j/connectors/kafka/source/SourceConfiguration\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,728:1\n383#2,7:729\n1915#3,2:736\n777#3:741\n873#3,2:742\n1391#3:744\n1480#3,5:745\n777#3:750\n873#3,2:751\n1586#3:753\n1661#3,3:754\n1391#3:757\n1480#3,2:758\n1586#3:760\n1661#3,3:761\n1482#3,3:764\n1915#3,2:767\n777#3:769\n873#3,2:770\n1586#3:772\n1661#3,3:773\n1915#3,2:776\n777#3:778\n873#3,2:779\n1586#3:781\n1661#3,3:782\n1915#3,2:785\n777#3:787\n873#3,2:788\n1586#3:790\n1661#3,3:791\n1915#3,2:794\n777#3:796\n873#3,2:797\n1586#3:799\n1661#3,3:800\n1915#3,2:803\n777#3:805\n873#3,2:806\n1586#3:808\n1661#3,3:809\n1205#3,2:812\n1282#3,4:814\n777#3:818\n873#3,2:819\n1586#3:821\n1661#3,3:822\n1205#3,2:825\n1282#3,4:827\n1586#3:831\n1661#3,3:832\n1#4:738\n221#5,2:739\n*S KotlinDebug\n*F\n+ 1 SourceConfiguration.kt\norg/neo4j/connectors/kafka/source/SourceConfiguration\n*L\n280#1:729,7\n342#1:736,2\n427#1:741\n427#1:742,2\n428#1:744\n428#1:745,5\n129#1:750\n129#1:751,2\n130#1:753\n130#1:754,3\n131#1:757\n131#1:758,2\n131#1:760\n131#1:761,3\n131#1:764,3\n132#1:767,2\n145#1:769\n145#1:770,2\n146#1:772\n146#1:773,3\n148#1:776,2\n152#1:778\n152#1:779,2\n153#1:781\n153#1:782,3\n154#1:785,2\n158#1:787\n158#1:788,2\n159#1:790\n159#1:791,3\n160#1:794,2\n164#1:796\n164#1:797,2\n165#1:799\n165#1:800,3\n166#1:803,2\n179#1:805\n179#1:806,2\n180#1:808\n180#1:809,3\n181#1:812,2\n181#1:814,4\n192#1:818\n192#1:819,2\n193#1:821\n193#1:822,3\n194#1:825,2\n194#1:827,4\n361#1:831\n361#1:832,3\n409#1:739,2\n*E\n"})
public final class SourceConfiguration
extends Neo4jConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy cdcSelectorsToTopics$delegate;
    @NotNull
    private final Lazy cdcTopicsToKeyStrategy$delegate;
    @NotNull
    private final Lazy cdcTopicsToValueStrategy$delegate;
    @NotNull
    private final Lazy cdcSelectors$delegate;
    @NotNull
    public static final String START_FROM = "neo4j.start-from";
    @NotNull
    public static final String START_FROM_VALUE = "neo4j.start-from.value";
    @NotNull
    public static final String IGNORE_STORED_OFFSET = "neo4j.ignore-stored-offset";
    @NotNull
    public static final String STRATEGY = "neo4j.source-strategy";
    @NotNull
    public static final String BATCH_SIZE = "neo4j.batch-size";
    @NotNull
    public static final String QUERY = "neo4j.query";
    @NotNull
    public static final String QUERY_STREAMING_PROPERTY = "neo4j.query.streaming-property";
    @NotNull
    public static final String QUERY_POLL_INTERVAL = "neo4j.query.poll-interval";
    @NotNull
    public static final String QUERY_POLL_DURATION = "neo4j.query.poll-duration";
    @NotNull
    public static final String QUERY_TIMEOUT = "neo4j.query.timeout";
    @NotNull
    public static final String QUERY_TOPIC = "neo4j.query.topic";
    @NotNull
    public static final String QUERY_FORCE_MAPS_AS_STRUCT = "neo4j.query.force-maps-as-struct";
    @NotNull
    public static final String CDC_POLL_INTERVAL = "neo4j.cdc.poll-interval";
    @NotNull
    public static final String CDC_POLL_DURATION = "neo4j.cdc.poll-duration";
    @NotNull
    public static final String PAYLOAD_MODE = "neo4j.payload-mode";
    @NotNull
    private static final String GROUP_NAME_TOPIC = "topic";
    @NotNull
    private static final String GROUP_NAME_INDEX = "index";
    @NotNull
    private static final String GROUP_NAME_METADATA = "metadata";
    @NotNull
    private static final Regex CDC_PATTERNS_REGEX = new Regex("^neo4j\\.cdc\\.topic\\.(?<topic>[a-zA-Z0-9._-]+)(\\.patterns)$");
    @NotNull
    private static final Regex CDC_KEY_STRATEGY_REGEX = new Regex("^neo4j\\.cdc\\.topic\\.(?<topic>[a-zA-Z0-9._-]+)(\\.key-strategy)$");
    @NotNull
    private static final Regex CDC_VALUE_STRATEGY_REGEX = new Regex("^neo4j\\.cdc\\.topic\\.(?<topic>[a-zA-Z0-9._-]+)(\\.value-strategy)$");
    @NotNull
    private static final Regex CDC_PATTERN_ARRAY_REGEX = new Regex("^neo4j\\.cdc\\.topic\\.(?<topic>[a-zA-Z0-9._-]+)(\\.patterns)\\.(?<index>[0-9]+)(\\.pattern)$");
    @NotNull
    private static final Regex CDC_PATTERN_ARRAY_OPERATION_REGEX = new Regex("^neo4j\\.cdc\\.topic\\.(?<topic>[a-zA-Z0-9._-]+)(\\.patterns)\\.(?<index>[0-9]+)(\\.operation)$");
    @NotNull
    private static final Regex CDC_PATTERN_ARRAY_CHANGES_TO_REGEX = new Regex("^neo4j\\.cdc\\.topic\\.(?<topic>[a-zA-Z0-9._-]+)(\\.patterns)\\.(?<index>[0-9]+)(\\.changesTo)$");
    @NotNull
    private static final Regex CDC_PATTERN_ARRAY_METADATA_REGEX = new Regex("^neo4j\\.cdc\\.topic\\.(?<topic>[a-zA-Z0-9._-]+)(\\.patterns)\\.(?<index>[0-9]+)(\\.metadata)\\.(?<metadata>[a-zA-Z0-9._-]+)$");
    private static final long DEFAULT_QUERY_POLL_INTERVAL = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
    private static final long DEFAULT_QUERY_POLL_DURATION = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS);
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private static final long DEFAULT_QUERY_TIMEOUT = DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.SECONDS);
    private static final boolean DEFAULT_QUERY_FORCE_MAPS_AS_STRUCT = true;
    private static final long DEFAULT_CDC_POLL_INTERVAL = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
    private static final long DEFAULT_CDC_POLL_DURATION = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS);
    @NotNull
    private static final String DEFAULT_STREAMING_PROPERTY = "timestamp";
    @NotNull
    private static final String METADATA_KEY_AUTHENTICATED_USER = "authenticatedUser";
    @NotNull
    private static final String METADATA_KEY_EXECUTING_USER = "executingUser";
    @NotNull
    private static final String METADATA_KEY_TX_METADATA = "txMetadata";

    public SourceConfiguration(@NotNull Map<?, ?> originals) {
        Intrinsics.checkNotNullParameter(originals, (String)"originals");
        super(Companion.config(), originals, ConnectorType.SOURCE);
        this.cdcSelectorsToTopics$delegate = LazyKt.lazy(() -> SourceConfiguration.cdcSelectorsToTopics_delegate$lambda$0(this));
        this.cdcTopicsToKeyStrategy$delegate = LazyKt.lazy(() -> SourceConfiguration.cdcTopicsToKeyStrategy_delegate$lambda$0(this));
        this.cdcTopicsToValueStrategy$delegate = LazyKt.lazy(() -> SourceConfiguration.cdcTopicsToValueStrategy_delegate$lambda$0(this));
        this.cdcSelectors$delegate = LazyKt.lazy(() -> SourceConfiguration.cdcSelectors_delegate$lambda$0(this));
    }

    public final boolean getForceMapsAsStruct() {
        Boolean bl = this.getBoolean(QUERY_FORCE_MAPS_AS_STRUCT);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getBoolean(...)");
        return bl;
    }

    @NotNull
    public final StartFrom getStartFrom() {
        String string = this.getString(START_FROM);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return StartFrom.valueOf(string);
    }

    @NotNull
    public final String getStartFromCustom() {
        String string = this.getString(START_FROM_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    public final boolean getIgnoreStoredOffset() {
        return Boolean.parseBoolean(this.getString(IGNORE_STORED_OFFSET));
    }

    @NotNull
    public final SourceType getStrategy() {
        String string = this.getString(STRATEGY);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return SourceType.valueOf(string);
    }

    @NotNull
    public final PayloadMode getPayloadMode() {
        String string = this.getString(PAYLOAD_MODE);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return PayloadMode.valueOf((String)string);
    }

    @NotNull
    public final String getQuery() {
        String string = this.getString(QUERY);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    @NotNull
    public final String getQueryStreamingProperty() {
        String string = this.getString(QUERY_STREAMING_PROPERTY);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    public final long getQueryPollingInterval-UwyO8pc() {
        String string = this.getString(QUERY_POLL_INTERVAL);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return org.neo4j.connectors.kafka.configuration.helpers.DurationKt.parseSimpleString((Duration.Companion)Duration.Companion, (String)string);
    }

    public final long getQueryPollingDuration-UwyO8pc() {
        String string = this.getString(QUERY_POLL_DURATION);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return org.neo4j.connectors.kafka.configuration.helpers.DurationKt.parseSimpleString((Duration.Companion)Duration.Companion, (String)string);
    }

    public final int getBatchSize() {
        Integer n = this.getInt(BATCH_SIZE);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getInt(...)");
        return ((Number)n).intValue();
    }

    public final long getQueryTimeout-UwyO8pc() {
        String string = this.getString(QUERY_TIMEOUT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return org.neo4j.connectors.kafka.configuration.helpers.DurationKt.parseSimpleString((Duration.Companion)Duration.Companion, (String)string);
    }

    @NotNull
    public final String getTopic() {
        String string = this.getString(QUERY_TOPIC);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    @NotNull
    public final Map<String, Object> getPartition() {
        Map map2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getStrategy().ordinal()]) {
            case 1: {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"database", (Object)this.getDatabase()), TuplesKt.to((Object)"type", (Object)"query"), TuplesKt.to((Object)"query", (Object)this.getQuery()), TuplesKt.to((Object)"partition", (Object)1)};
                map2 = MapsKt.mapOf((Pair[])pairArray);
                break;
            }
            case 2: {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"database", (Object)this.getDatabase()), TuplesKt.to((Object)"type", (Object)"cdc"), TuplesKt.to((Object)"partition", (Object)1)};
                map2 = MapsKt.mapOf((Pair[])pairArray);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return map2;
    }

    public final long getCdcPollingInterval-UwyO8pc() {
        String string = this.getString(CDC_POLL_INTERVAL);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return org.neo4j.connectors.kafka.configuration.helpers.DurationKt.parseSimpleString((Duration.Companion)Duration.Companion, (String)string);
    }

    public final long getCdcPollingDuration-UwyO8pc() {
        String string = this.getString(CDC_POLL_DURATION);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return org.neo4j.connectors.kafka.configuration.helpers.DurationKt.parseSimpleString((Duration.Companion)Duration.Companion, (String)string);
    }

    @NotNull
    public final Map<Selector, List<String>> getCdcSelectorsToTopics() {
        Lazy lazy = this.cdcSelectorsToTopics$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final Map<String, Neo4jCdcKeyStrategy> getCdcTopicsToKeyStrategy() {
        Lazy lazy = this.cdcTopicsToKeyStrategy$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final Map<String, Neo4jCdcValueStrategy> getCdcTopicsToValueStrategy() {
        Lazy lazy = this.cdcTopicsToValueStrategy$delegate;
        return (Map)lazy.getValue();
    }

    private final void mapPositionalPattern(CdcPatternConfigItem configEntry, Map<String, Boolean> nonPositionalConfigMode, Map<String, List<Pattern>> configMap) {
        List list;
        String topicName = configEntry.getTopic();
        if (nonPositionalConfigMode.getOrDefault(topicName, false).booleanValue()) {
            throw new ConfigException("It's not allowed to mix positional and non-positional configuration for the same topic.");
        }
        List patterns = Pattern.parse((String)((String)configEntry.getValue()));
        if (patterns.size() > 1) {
            throw new ConfigException("Too many patterns. Only one pattern allowed for positional pattern configuration.");
        }
        Integer n = configEntry.getIndex();
        Intrinsics.checkNotNull((Object)n);
        int index = n;
        Pattern pattern = (Pattern)patterns.get(0);
        if (!configMap.containsKey(topicName)) {
            configMap.put(topicName, new ArrayList());
        }
        if (index > (list = (List)MapsKt.getValue(configMap, (Object)topicName)).size()) {
            throw new ConfigException("Index " + index + " out of bounds. Please ensure that you started the definition with a 0-based index.");
        }
        Intrinsics.checkNotNull((Object)pattern);
        list.add(pattern);
    }

    private final void mapOperation(CdcPatternConfigItem configEntry, Map<String, Boolean> nonPositionalConfigMode, Map<String, List<Pattern>> configMap) {
        EntityOperation entityOperation;
        Pair<Integer, List<Pattern>> pair = this.retrieveIndexAndPattern(configEntry, nonPositionalConfigMode, configMap);
        int index = ((Number)pair.component1()).intValue();
        List patterns = (List)pair.component2();
        Object object = configEntry.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String string = ((String)object).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        switch (string) {
            case "create": {
                entityOperation = EntityOperation.CREATE;
                break;
            }
            case "update": {
                entityOperation = EntityOperation.UPDATE;
                break;
            }
            case "delete": {
                entityOperation = EntityOperation.DELETE;
                break;
            }
            default: {
                String value;
                throw new ConfigException("Cannot parse " + value + " as an operation. Allowed operations are create, delete or update.");
            }
        }
        EntityOperation operation = entityOperation;
        Pattern pattern = (Pattern)patterns.get(index);
        pattern.withOperation(operation);
    }

    private final void mapChangesTo(CdcPatternConfigItem configEntry, Map<String, Boolean> nonPositionalConfigMode, Map<String, List<Pattern>> configMap) {
        Pair<Integer, List<Pattern>> pair = this.retrieveIndexAndPattern(configEntry, nonPositionalConfigMode, configMap);
        int index = ((Number)pair.component1()).intValue();
        List patterns = (List)pair.component2();
        Object object = configEntry.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String value = (String)object;
        String[] stringArray = new String[]{","};
        Set changesTo = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null), SourceConfiguration::mapChangesTo$lambda$0));
        Pattern pattern = (Pattern)patterns.get(index);
        pattern.withChangesTo(changesTo);
    }

    /*
     * WARNING - void declaration
     */
    private final void mapMetadata(CdcPatternConfigItem configEntry, Map<String, Boolean> nonPositionalConfigMode, Map<String, List<Pattern>> configMap, Map<Pattern, Map<String, Object>> patternTxMetadataMap) {
        Pair<Integer, List<Pattern>> pair = this.retrieveIndexAndPattern(configEntry, nonPositionalConfigMode, configMap);
        int index = ((Number)pair.component1()).intValue();
        List patterns = (List)pair.component2();
        String string = configEntry.getMetadata();
        Intrinsics.checkNotNull((Object)string);
        String metadataKey = string;
        Object value = configEntry.getValue();
        Pattern pattern = (Pattern)patterns.get(index);
        if (StringsKt.startsWith$default((String)metadataKey, (String)"txMetadata.", (boolean)false, (int)2, null)) {
            Object object;
            void $this$getOrPut$iv;
            String txMetadataKey = StringsKt.removePrefix((String)metadataKey, (CharSequence)"txMetadata.");
            Map<Pattern, Map<String, Object>> map2 = patternTxMetadataMap;
            Pattern key$iv = pattern;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)txMetadataKey, (Object)value)};
                Map answer$iv = MapsKt.mutableMapOf((Pair[])pairArray);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Map txMetadata = (Map)object;
            txMetadata.put(txMetadataKey, value);
            pattern.withTxMetadata(txMetadata);
            patternTxMetadataMap.put(pattern, txMetadata);
        } else if (Intrinsics.areEqual((Object)metadataKey, (Object)METADATA_KEY_EXECUTING_USER)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
            pattern.withExecutingUser((String)value);
        } else if (Intrinsics.areEqual((Object)metadataKey, (Object)METADATA_KEY_AUTHENTICATED_USER)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
            pattern.withAuthenticatedUser((String)value);
        } else {
            throw new ConfigException("Unexpected metadata key: '" + metadataKey + "' found in configuration property '" + configEntry.getKey() + "'. Valid keys are 'authenticatedUser', 'executingUser', or keys starting with 'txMetadata.*'.");
        }
    }

    private final Pair<String, Neo4jCdcKeyStrategy> mapKeyStrategy(CdcPatternConfigItem configEntry) {
        String topicName = configEntry.getTopic();
        Object value = configEntry.getValue();
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
        return TuplesKt.to((Object)topicName, (Object)((Object)Neo4jCdcKeyStrategy.valueOf((String)value)));
    }

    private final Pair<String, Neo4jCdcValueStrategy> mapValueStrategy(CdcPatternConfigItem configEntry) {
        String topicName = configEntry.getTopic();
        Object value = configEntry.getValue();
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
        return TuplesKt.to((Object)topicName, (Object)((Object)Neo4jCdcValueStrategy.valueOf((String)value)));
    }

    private final Pair<Integer, List<Pattern>> retrieveIndexAndPattern(CdcPatternConfigItem configEntry, Map<String, Boolean> nonPositionalConfigMode, Map<String, List<Pattern>> configMap) {
        String topicName = configEntry.getTopic();
        if (nonPositionalConfigMode.getOrDefault(topicName, false).booleanValue()) {
            throw new ConfigException("It's not allowed to mix positional and non-positional configuration for the same topic.");
        }
        Integer n = configEntry.getIndex();
        Intrinsics.checkNotNull((Object)n);
        int index = n;
        if (!configMap.containsKey(topicName)) {
            throw new ConfigException("Cannot assign config value because pattern is not defined for index " + index + ".");
        }
        List patterns = (List)MapsKt.getValue(configMap, (Object)topicName);
        if (index > patterns.size() - 1) {
            throw new ConfigException("Index " + index + " out of bounds. Please ensure that you started the definition with a 0-based index.");
        }
        return new Pair((Object)index, (Object)patterns);
    }

    private final Map<Selector, List<String>> pivotMapCdcSelectorMap(Map<String, ? extends List<? extends Pattern>> patternMap) {
        Map selectorBasedMap = new LinkedHashMap();
        Iterable $this$forEach$iv = patternMap.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            for (Pattern pattern : (List)it.getValue()) {
                for (Selector selector : pattern.toSelector()) {
                    if (!selectorBasedMap.containsKey(selector)) {
                        selectorBasedMap.put(selector, (List)new ArrayList());
                    }
                    List topics = (List)MapsKt.getValue((Map)selectorBasedMap, (Object)selector);
                    topics.add(it.getKey());
                    CollectionsKt.sort((List)topics);
                }
            }
        }
        return selectorBasedMap;
    }

    @NotNull
    public final Set<Selector> getCdcSelectors() {
        Lazy lazy = this.cdcSelectors$delegate;
        return (Set)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public TransactionConfig txConfig(@NotNull Function1<? super Map<String, Object>, Unit> applyCustomMetadata) {
        Map map2;
        Intrinsics.checkNotNullParameter(applyCustomMetadata, (String)"applyCustomMetadata");
        TransactionConfig original = super.txConfig(applyCustomMetadata);
        TransactionConfig.Builder builder = TransactionConfig.builder();
        if (Duration.isPositive-impl((long)this.getQueryTimeout-UwyO8pc())) {
            long l = this.getQueryTimeout-UwyO8pc();
            int n = Duration.getNanosecondsComponent-impl((long)l);
            long l2 = Duration.getInWholeSeconds-impl((long)l);
            java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
            builder.withTimeout(duration);
        }
        Map map3 = map2 = MapsKt.createMapBuilder();
        TransactionConfig.Builder builder2 = builder;
        boolean bl = false;
        Map map4 = original.metadata();
        Intrinsics.checkNotNullExpressionValue((Object)map4, (String)"metadata(...)");
        Map $this$forEach$iv = map4;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$txConfig_u24lambda_u240;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl2 = false;
            String k = (String)entry.getKey();
            Value v = (Value)entry.getValue();
            $this$txConfig_u24lambda_u240.put(k, v.asObject());
        }
        builder2.withMetadata(MapsKt.build((Map)map2));
        TransactionConfig transactionConfig = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)transactionConfig, (String)"build(...)");
        return transactionConfig;
    }

    @NotNull
    public String userAgentComment() {
        return this.getStrategy().getDescription();
    }

    /*
     * WARNING - void declaration
     */
    public final void validate() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        ConfigValue v;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        ConfigDef def = Companion.config();
        Map originals = this.originalsStrings();
        List values = def.validate(originals);
        Config config = new Config(values);
        Intrinsics.checkNotNull((Object)originals);
        Companion.validate(config, originals);
        List list = config.configValues();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"configValues(...)");
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var8_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            v = (ConfigValue)element$iv$iv;
            boolean bl = false;
            List list2 = v.errorMessages();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"errorMessages(...)");
            boolean bl2 = !((Collection)list2).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            v = (ConfigValue)element$iv$iv;
            boolean bl = false;
            List list3 = v.errorMessages();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"errorMessages(...)");
            Iterable list$iv$iv = list3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List errors = (List)destination$iv$iv;
        if (!((Collection)errors).isEmpty()) {
            throw new ConfigException(CollectionsKt.joinToString$default((Iterable)errors, null, null, null, (int)0, null, null, (int)63, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Map cdcSelectorsToTopics_delegate$lambda$0(SourceConfiguration this$0) {
        Map<Selector, List<String>> map2;
        if (WhenMappings.$EnumSwitchMapping$0[this$0.getStrategy().ordinal()] == 2) {
            Iterable $this$forEach$iv;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Collection collection;
            Object item$iv$iv;
            Object $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Map configMap = new LinkedHashMap();
            Map nonPositionalConfigMode = new LinkedHashMap();
            Map patternTxMetadataMap = new LinkedHashMap();
            Iterable iterable = this$0.originals().entrySet();
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                if (!CDC_PATTERNS_REGEX.matches((CharSequence)k)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                item$iv$iv = iterator2.next();
                it = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new CdcPatternConfigItem((Map.Entry<String, ? extends Object>)it, CDC_PATTERNS_REGEX));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            iterator2 = $this$flatMapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void $this$mapTo$iv$iv2;
                Object element$iv$iv;
                element$iv$iv = iterator2.next();
                it = (CdcPatternConfigItem)element$iv$iv;
                boolean bl = false;
                List list = Pattern.parse((String)((String)((CdcPatternConfigItem)it).getValue()));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
                Iterable $this$map$iv2 = list;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void key;
                    Pattern pattern = (Pattern)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(TuplesKt.to((Object)key, (Object)((CdcPatternConfigItem)it).getTopic()));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it2 = (Pair)element$iv;
                boolean bl = false;
                if (!configMap.containsKey(it2.getSecond())) {
                    configMap.put(it2.getSecond(), (List)new ArrayList());
                }
                nonPositionalConfigMode.put(it2.getSecond(), true);
                List list = (List)MapsKt.getValue((Map)configMap, (Object)it2.getSecond());
                Object object = it2.getFirst();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-first>(...)");
                list.add(object);
            }
            $this$forEach$iv = this$0.originals().entrySet();
            $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                if (!CDC_PATTERN_ARRAY_REGEX.matches((CharSequence)k)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            Iterator bl = $this$mapTo$iv$iv.iterator();
            while (bl.hasNext()) {
                item$iv$iv = bl.next();
                it = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(new CdcPatternConfigItem((Map.Entry<String, ? extends Object>)it, CDC_PATTERN_ARRAY_REGEX));
            }
            $this$map$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CdcPatternConfigItem it3 = (CdcPatternConfigItem)element$iv;
                boolean bl4 = false;
                this$0.mapPositionalPattern(it3, nonPositionalConfigMode, configMap);
            }
            $this$forEach$iv = this$0.originals().entrySet();
            $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl5 = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                if (!CDC_PATTERN_ARRAY_OPERATION_REGEX.matches((CharSequence)k)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            Iterator bl4 = $this$mapTo$iv$iv.iterator();
            while (bl4.hasNext()) {
                item$iv$iv = bl4.next();
                it = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add(new CdcPatternConfigItem((Map.Entry<String, ? extends Object>)it, CDC_PATTERN_ARRAY_OPERATION_REGEX));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CdcPatternConfigItem it4 = (CdcPatternConfigItem)element$iv;
                boolean bl7 = false;
                this$0.mapOperation(it4, nonPositionalConfigMode, configMap);
            }
            $this$forEach$iv = this$0.originals().entrySet();
            $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl8 = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                if (!CDC_PATTERN_ARRAY_CHANGES_TO_REGEX.matches((CharSequence)k)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            Iterator bl7 = $this$mapTo$iv$iv.iterator();
            while (bl7.hasNext()) {
                item$iv$iv = bl7.next();
                it = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl9 = false;
                collection.add(new CdcPatternConfigItem((Map.Entry<String, ? extends Object>)it, CDC_PATTERN_ARRAY_CHANGES_TO_REGEX));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CdcPatternConfigItem it5 = (CdcPatternConfigItem)element$iv;
                boolean bl10 = false;
                this$0.mapChangesTo(it5, nonPositionalConfigMode, configMap);
            }
            $this$forEach$iv = this$0.originals().entrySet();
            $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl11 = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                if (!CDC_PATTERN_ARRAY_METADATA_REGEX.matches((CharSequence)k)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            Iterator bl10 = $this$mapTo$iv$iv.iterator();
            while (bl10.hasNext()) {
                item$iv$iv = bl10.next();
                it = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl12 = false;
                collection.add(new CdcPatternConfigItem((Map.Entry<String, ? extends Object>)it, CDC_PATTERN_ARRAY_METADATA_REGEX));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CdcPatternConfigItem it6 = (CdcPatternConfigItem)element$iv;
                boolean bl13 = false;
                this$0.mapMetadata(it6, nonPositionalConfigMode, configMap, patternTxMetadataMap);
            }
            map2 = this$0.pivotMapCdcSelectorMap(configMap);
        } else {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map cdcTopicsToKeyStrategy_delegate$lambda$0(SourceConfiguration this$0) {
        Map map2;
        if (WhenMappings.$EnumSwitchMapping$0[this$0.getStrategy().ordinal()] == 2) {
            void $this$associateTo$iv$iv;
            void $this$mapTo$iv$iv;
            Map.Entry it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this$0.originals().entrySet();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                if (!CDC_KEY_STRATEGY_REGEX.matches((CharSequence)k)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new CdcPatternConfigItem(it, CDC_KEY_STRATEGY_REGEX));
            }
            Iterable $this$associate$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv2;
                CdcPatternConfigItem it2 = (CdcPatternConfigItem)element$iv$iv;
                boolean bl = false;
                Pair<String, Neo4jCdcKeyStrategy> pair = this$0.mapKeyStrategy(it2);
                map3.put(pair.getFirst(), pair.getSecond());
            }
            map2 = destination$iv$iv2;
        } else {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map cdcTopicsToValueStrategy_delegate$lambda$0(SourceConfiguration this$0) {
        Map map2;
        if (WhenMappings.$EnumSwitchMapping$0[this$0.getStrategy().ordinal()] == 2) {
            void $this$associateTo$iv$iv;
            void $this$mapTo$iv$iv;
            Map.Entry it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this$0.originals().entrySet();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                if (!CDC_VALUE_STRATEGY_REGEX.matches((CharSequence)k)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new CdcPatternConfigItem(it, CDC_VALUE_STRATEGY_REGEX));
            }
            Iterable $this$associate$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv2;
                CdcPatternConfigItem it2 = (CdcPatternConfigItem)element$iv$iv;
                boolean bl = false;
                Pair<String, Neo4jCdcValueStrategy> pair = this$0.mapValueStrategy(it2);
                map3.put(pair.getFirst(), pair.getSecond());
            }
            map2 = destination$iv$iv2;
        } else {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    private static final String mapChangesTo$lambda$0(String term) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        return ((Object)StringsKt.trim((CharSequence)term)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final Set cdcSelectors_delegate$lambda$0(SourceConfiguration this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.getCdcSelectorsToTopics().keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            EntitySelector entitySelector;
            void it;
            Selector selector = (Selector)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var10_10 = it;
            if (var10_10 instanceof NodeSelector) {
                entitySelector = (EntitySelector)((NodeSelector.NodeSelectorBuilder)((NodeSelector.NodeSelectorBuilder)((NodeSelector.NodeSelectorBuilder)((NodeSelector.NodeSelectorBuilder)((NodeSelector.NodeSelectorBuilder)NodeSelector.builder().withOperation(((NodeSelector)it).getOperation())).withChangesTo(((NodeSelector)it).getChangesTo())).withLabels(((NodeSelector)it).getLabels()).withKey(((NodeSelector)it).getKey()).withTxMetadata(((NodeSelector)it).getTxMetadata())).withExecutingUser(((NodeSelector)it).getExecutingUser())).withAuthenticatedUser(((NodeSelector)it).getAuthenticatedUser())).build();
            } else if (var10_10 instanceof RelationshipSelector) {
                entitySelector = (EntitySelector)((RelationshipSelector.RelationshipSelectorBuilder)((RelationshipSelector.RelationshipSelectorBuilder)((RelationshipSelector.RelationshipSelectorBuilder)((RelationshipSelector.RelationshipSelectorBuilder)((RelationshipSelector.RelationshipSelectorBuilder)RelationshipSelector.builder().withOperation(((RelationshipSelector)it).getOperation())).withChangesTo(((RelationshipSelector)it).getChangesTo())).withType(((RelationshipSelector)it).getType()).withStart(((RelationshipSelector)it).getStart()).withEnd(((RelationshipSelector)it).getEnd()).withKey(((RelationshipSelector)it).getKey()).withTxMetadata(((RelationshipSelector)it).getTxMetadata())).withExecutingUser(((RelationshipSelector)it).getExecutingUser())).withAuthenticatedUser(((RelationshipSelector)it).getAuthenticatedUser())).build();
            } else if (var10_10 instanceof EntitySelector) {
                entitySelector = EntitySelector.builder().withOperation(((EntitySelector)it).getOperation()).withChangesTo(((EntitySelector)it).getChangesTo()).withTxMetadata(((EntitySelector)it).getTxMetadata()).withExecutingUser(((EntitySelector)it).getExecutingUser()).withAuthenticatedUser(((EntitySelector)it).getAuthenticatedUser()).build();
            } else {
                throw new IllegalStateException("unexpected pattern type " + it.getClass().getName());
            }
            collection.add(entitySelector);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010&\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0000H\u0096\u0082\u0004J\u0015\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c2\u0003J)\u0010 \u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010!\u001a\u00020\"2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u00d6\u0083\u0004J\n\u0010#\u001a\u00020\u0017H\u00d6\u0081\u0004J\n\u0010$\u001a\u00020\u0004H\u00d6\u0081\u0004R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0010\u00a8\u0006%"}, d2={"Lorg/neo4j/connectors/kafka/source/SourceConfiguration$CdcPatternConfigItem;", "", "entry", "", "", "", "pattern", "Lkotlin/text/Regex;", "<init>", "(Ljava/util/Map$Entry;Lkotlin/text/Regex;)V", "getEntry", "()Ljava/util/Map$Entry;", "match", "Lkotlin/text/MatchResult;", "key", "getKey", "()Ljava/lang/String;", "value", "getValue", "()Ljava/lang/Object;", "topic", "getTopic", "index", "", "getIndex", "()Ljava/lang/Integer;", "metadata", "getMetadata", "compareTo", "other", "component1", "component2", "copy", "equals", "", "hashCode", "toString", "source"})
    public static final class CdcPatternConfigItem
    implements Comparable<CdcPatternConfigItem> {
        @NotNull
        private final Map.Entry<String, Object> entry;
        @NotNull
        private final Regex pattern;
        @NotNull
        private final MatchResult match;
        @NotNull
        private final String key;
        @NotNull
        private final Object value;
        @NotNull
        private final String topic;

        public CdcPatternConfigItem(@NotNull Map.Entry<String, ? extends Object> entry, @NotNull Regex pattern) {
            Intrinsics.checkNotNullParameter(entry, (String)"entry");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.entry = entry;
            this.pattern = pattern;
            MatchResult matchResult = this.pattern.matchEntire((CharSequence)this.entry.getKey());
            Intrinsics.checkNotNull((Object)matchResult);
            this.match = matchResult;
            this.key = this.entry.getKey();
            this.value = this.entry.getValue();
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)this.match.getGroups(), (String)SourceConfiguration.GROUP_NAME_TOPIC);
            Intrinsics.checkNotNull((Object)matchGroup);
            this.topic = matchGroup.getValue();
        }

        @NotNull
        public final Map.Entry<String, Object> getEntry() {
            return this.entry;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final Object getValue() {
            return this.value;
        }

        @NotNull
        public final String getTopic() {
            return this.topic;
        }

        @Nullable
        public final Integer getIndex() {
            Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)this.match.getGroups(), (String)SourceConfiguration.GROUP_NAME_INDEX);
            return object != null && (object = object.getValue()) != null ? Integer.valueOf(Integer.parseInt((String)object)) : null;
        }

        @Nullable
        public final String getMetadata() {
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)this.match.getGroups(), (String)SourceConfiguration.GROUP_NAME_METADATA);
            return matchGroup != null ? matchGroup.getValue() : null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(@NotNull CdcPatternConfigItem other) {
            int n;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int result = this.topic.compareTo(other.topic);
            if (result == 0) {
                Integer n2 = this.getIndex();
                Integer n3 = other.getIndex();
                n = Intrinsics.compare((int)(n2 != null ? n2 : -1), (int)(n3 != null ? n3 : -1));
            } else {
                void var2_2;
                n = var2_2;
            }
            return n;
        }

        @NotNull
        public final Map.Entry<String, Object> component1() {
            return this.entry;
        }

        private final Regex component2() {
            return this.pattern;
        }

        @NotNull
        public final CdcPatternConfigItem copy(@NotNull Map.Entry<String, ? extends Object> entry, @NotNull Regex pattern) {
            Intrinsics.checkNotNullParameter(entry, (String)"entry");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            return new CdcPatternConfigItem(entry, pattern);
        }

        public static /* synthetic */ CdcPatternConfigItem copy$default(CdcPatternConfigItem cdcPatternConfigItem, Map.Entry entry, Regex regex, int n, Object object) {
            if ((n & 1) != 0) {
                entry = cdcPatternConfigItem.entry;
            }
            if ((n & 2) != 0) {
                regex = cdcPatternConfigItem.pattern;
            }
            return cdcPatternConfigItem.copy(entry, regex);
        }

        @NotNull
        public String toString() {
            return "CdcPatternConfigItem(entry=" + this.entry + ", pattern=" + this.pattern + ")";
        }

        public int hashCode() {
            int result = ((Object)this.entry).hashCode();
            result = result * 31 + this.pattern.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CdcPatternConfigItem)) {
                return false;
            }
            CdcPatternConfigItem cdcPatternConfigItem = (CdcPatternConfigItem)other;
            if (!Intrinsics.areEqual(this.entry, cdcPatternConfigItem.entry)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.pattern, (Object)cdcPatternConfigItem.pattern);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000503J\u0006\u00100\u001a\u000204R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!R\u0010\u0010\"\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!R\u000e\u0010#\u001a\u00020$X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!R\u000e\u0010&\u001a\u00020'X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!R\u0010\u0010)\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!R\u000e\u0010*\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/neo4j/connectors/kafka/source/SourceConfiguration$Companion;", "", "<init>", "()V", "START_FROM", "", "START_FROM_VALUE", "IGNORE_STORED_OFFSET", "STRATEGY", "BATCH_SIZE", "QUERY", "QUERY_STREAMING_PROPERTY", "QUERY_POLL_INTERVAL", "QUERY_POLL_DURATION", "QUERY_TIMEOUT", "QUERY_TOPIC", "QUERY_FORCE_MAPS_AS_STRUCT", "CDC_POLL_INTERVAL", "CDC_POLL_DURATION", "PAYLOAD_MODE", "GROUP_NAME_TOPIC", "GROUP_NAME_INDEX", "GROUP_NAME_METADATA", "CDC_PATTERNS_REGEX", "Lkotlin/text/Regex;", "CDC_KEY_STRATEGY_REGEX", "CDC_VALUE_STRATEGY_REGEX", "CDC_PATTERN_ARRAY_REGEX", "CDC_PATTERN_ARRAY_OPERATION_REGEX", "CDC_PATTERN_ARRAY_CHANGES_TO_REGEX", "CDC_PATTERN_ARRAY_METADATA_REGEX", "DEFAULT_QUERY_POLL_INTERVAL", "Lkotlin/time/Duration;", "J", "DEFAULT_QUERY_POLL_DURATION", "DEFAULT_BATCH_SIZE", "", "DEFAULT_QUERY_TIMEOUT", "DEFAULT_QUERY_FORCE_MAPS_AS_STRUCT", "", "DEFAULT_CDC_POLL_INTERVAL", "DEFAULT_CDC_POLL_DURATION", "DEFAULT_STREAMING_PROPERTY", "METADATA_KEY_AUTHENTICATED_USER", "METADATA_KEY_EXECUTING_USER", "METADATA_KEY_TX_METADATA", "validate", "", "config", "Lorg/apache/kafka/common/config/Config;", "originals", "", "Lorg/apache/kafka/common/config/ConfigDef;", "source"})
    @SourceDebugExtension(value={"SMAP\nSourceConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceConfiguration.kt\norg/neo4j/connectors/kafka/source/SourceConfiguration$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,728:1\n1#2:729\n777#3:730\n873#3,2:731\n777#3:733\n873#3,2:734\n777#3:736\n873#3,2:737\n777#3:739\n873#3,2:740\n777#3:742\n873#3,2:743\n777#3:745\n873#3,2:746\n777#3:748\n873#3,2:749\n1915#3,2:751\n*S KotlinDebug\n*F\n+ 1 SourceConfiguration.kt\norg/neo4j/connectors/kafka/source/SourceConfiguration$Companion\n*L\n541#1:730\n541#1:731,2\n542#1:733\n542#1:734,2\n543#1:736\n543#1:737,2\n544#1:739\n544#1:740,2\n545#1:742\n545#1:743,2\n546#1:745\n546#1:746,2\n547#1:748\n547#1:749,2\n553#1:751,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void validate(@NotNull Config config, @NotNull Map<String, String> originals) {
            ConfigValue strategy;
            Object v1;
            Object it;
            List configList;
            block20: {
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                Intrinsics.checkNotNullParameter(originals, (String)"originals");
                Neo4jConfiguration.Companion.validate(config);
                Validators.INSTANCE.validateNonEmptyIfVisible(config, SourceConfiguration.START_FROM_VALUE);
                Validators.INSTANCE.validateNonEmptyIfVisible(config, SourceConfiguration.BATCH_SIZE);
                Validators.INSTANCE.validateNonEmptyIfVisible(config, SourceConfiguration.QUERY_TOPIC);
                Validators.INSTANCE.validateNonEmptyIfVisible(config, SourceConfiguration.QUERY);
                Validators.INSTANCE.validateNonEmptyIfVisible(config, SourceConfiguration.QUERY_TIMEOUT);
                Validators.INSTANCE.validateNonEmptyIfVisible(config, SourceConfiguration.QUERY_POLL_INTERVAL);
                Validators.INSTANCE.validateNonEmptyIfVisible(config, SourceConfiguration.CDC_POLL_INTERVAL);
                List list = config.configValues();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"configValues(...)");
                configList = CollectionsKt.toList((Iterable)list);
                Iterable iterable = configList;
                for (Object object2 : iterable) {
                    it = (ConfigValue)object2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)SourceConfiguration.STRATEGY)) continue;
                    v1 = object2;
                    break block20;
                }
                v1 = null;
            }
            ConfigValue configValue = strategy = (ConfigValue)v1;
            if (Intrinsics.areEqual((Object)(configValue != null ? configValue.value() : null), (Object)"CDC")) {
                Map.Entry it2;
                Iterable $this$filterTo$iv$iv;
                ConfigValue payloadMode;
                Object object;
                block21: {
                    Object object2;
                    Iterable iterable = configList;
                    object2 = iterable.iterator();
                    while (object2.hasNext()) {
                        Object it3 = it = object2.next();
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it3.name(), (Object)SourceConfiguration.PAYLOAD_MODE)) continue;
                        object = it;
                        break block21;
                    }
                    object = null;
                }
                ConfigValue configValue2 = payloadMode = (ConfigValue)object;
                if (Intrinsics.areEqual((Object)(configValue2 != null ? configValue2.value() : null), (Object)"RAW_JSON_STRING")) {
                    strategy.addErrorMessage("CDC strategy does not support 'RAW_JSON_STRING' payload mode. Please use either 'EXTENDED' or 'COMPACT' modes.");
                }
                Iterable $this$filter$iv = originals.entrySet();
                boolean $i$f$filter = false;
                it = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it2 = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    if (!CDC_PATTERNS_REGEX.matches((CharSequence)it2.getKey())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = originals.entrySet();
                Collection collection = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it2 = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    if (!CDC_PATTERN_ARRAY_REGEX.matches((CharSequence)it2.getKey())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = originals.entrySet();
                collection = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it2 = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    if (!CDC_PATTERN_ARRAY_OPERATION_REGEX.matches((CharSequence)it2.getKey())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = originals.entrySet();
                collection = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it2 = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    if (!CDC_PATTERN_ARRAY_CHANGES_TO_REGEX.matches((CharSequence)it2.getKey())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = originals.entrySet();
                collection = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it2 = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    if (!CDC_PATTERN_ARRAY_METADATA_REGEX.matches((CharSequence)it2.getKey())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = originals.entrySet();
                collection = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it2 = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    if (!CDC_KEY_STRATEGY_REGEX.matches((CharSequence)it2.getKey())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = originals.entrySet();
                collection = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it2 = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    if (!CDC_VALUE_STRATEGY_REGEX.matches((CharSequence)it2.getKey())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List cdcTopics = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
                if (cdcTopics.isEmpty()) {
                    strategy.addErrorMessage("At least one topic needs to be configured with pattern(s) describing the entities to query changes for. Please refer to documentation for more information.");
                } else {
                    Iterable $this$forEach$iv = cdcTopics;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Map.Entry it4 = (Map.Entry)element$iv;
                        boolean bl = false;
                        try {
                            Validators.INSTANCE.notBlankOrEmpty().ensureValid((String)it4.getKey(), it4.getValue());
                            if (CDC_PATTERNS_REGEX.matches((CharSequence)it4.getKey()) || CDC_PATTERN_ARRAY_REGEX.matches((CharSequence)it4.getKey())) {
                                try {
                                    Pattern.parse((String)((String)it4.getValue()));
                                }
                                catch (PatternException e) {
                                    throw new ConfigException((String)it4.getKey(), it4.getValue(), e.getMessage());
                                }
                            }
                            if (CDC_KEY_STRATEGY_REGEX.matches((CharSequence)it4.getKey())) {
                                Validators.INSTANCE.enum(Neo4jCdcKeyStrategy.class, (Enum[])new Neo4jCdcKeyStrategy[0]).ensureValid((String)it4.getKey(), it4.getValue());
                            }
                            if (!CDC_VALUE_STRATEGY_REGEX.matches((CharSequence)it4.getKey())) continue;
                            Validators.INSTANCE.enum(Neo4jCdcValueStrategy.class, (Enum[])new Neo4jCdcValueStrategy[0]).ensureValid((String)it4.getKey(), it4.getValue());
                        }
                        catch (ConfigException e) {
                            strategy.addErrorMessage(e.getMessage());
                        }
                    }
                }
            }
        }

        @NotNull
        public final ConfigDef config() {
            ConfigDef configDef = Neo4jConfiguration.Companion.config().define(ConfigKeyBuilder.Companion.of(SourceConfiguration.STRATEGY, ConfigDef.Type.STRING, Companion::config$lambda$0)).define(ConfigKeyBuilder.Companion.of(SourceConfiguration.START_FROM, ConfigDef.Type.STRING, Companion::config$lambda$1)).define(ConfigKeyBuilder.Companion.of(SourceConfiguration.START_FROM_VALUE, ConfigDef.Type.STRING, Companion::config$lambda$2)).define(ConfigKeyBuilder.Companion.of(SourceConfiguration.IGNORE_STORED_OFFSET, ConfigDef.Type.STRING, Companion::config$lambda$3)).define(ConfigKeyBuilder.Companion.of(SourceConfiguration.QUERY, ConfigDef.Type.STRING, Companion::config$lambda$4)).define(ConfigKeyBuilder.Companion.of(SourceConfiguration.QUERY_STREAMING_PROPERTY, ConfigDef.Type.STRING, Companion::config$lambda$5)).define(ConfigKeyBuilder.Companion.of(SourceConfiguration.QUERY_TOPIC, ConfigDef.Type.STRING, Companion::config$lambda$6)).define(ConfigKeyBuilder.Companion.of(SourceConfiguration.QUERY_TIMEOUT, ConfigDef.Type.STRING, Companion::config$lambda$7)).define(ConfigKeyBuilder.Companion.of(SourceConfiguration.QUERY_POLL_INTERVAL, ConfigDef.Type.STRING, Companion::config$lambda$8)).define(ConfigKeyBuilder.Companion.of(SourceConfiguration.QUERY_POLL_DURATION, ConfigDef.Type.STRING, Companion::config$lambda$9)).define(ConfigKeyBuilder.Companion.of(SourceConfiguration.QUERY_FORCE_MAPS_AS_STRUCT, ConfigDef.Type.BOOLEAN, Companion::config$lambda$10)).define(ConfigKeyBuilder.Companion.of(SourceConfiguration.BATCH_SIZE, ConfigDef.Type.INT, Companion::config$lambda$11)).define(ConfigKeyBuilder.Companion.of(SourceConfiguration.CDC_POLL_INTERVAL, ConfigDef.Type.STRING, Companion::config$lambda$12)).define(ConfigKeyBuilder.Companion.of(SourceConfiguration.CDC_POLL_DURATION, ConfigDef.Type.STRING, Companion::config$lambda$13)).define(ConfigKeyBuilder.Companion.of(SourceConfiguration.PAYLOAD_MODE, ConfigDef.Type.STRING, Companion::config$lambda$14));
            Intrinsics.checkNotNullExpressionValue((Object)configDef, (String)"define(...)");
            return configDef;
        }

        private static final Unit config$lambda$0(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.HIGH);
            $this$of.setDefaultValue((Object)"QUERY");
            $this$of.setGroup(Groups.CONNECTOR.getTitle());
            $this$of.setValidator(Validators.INSTANCE.enum(SourceType.class, (Enum[])new SourceType[0]));
            $this$of.setRecommender(Recommenders.INSTANCE.enum(SourceType.class, (Enum[])new SourceType[0]));
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$1(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.HIGH);
            $this$of.setDefaultValue((Object)StartFrom.NOW.toString());
            $this$of.setGroup(Groups.CONNECTOR.getTitle());
            $this$of.setValidator(Validators.INSTANCE.enum(StartFrom.class, (Enum[])new StartFrom[0]));
            $this$of.setRecommender(Recommenders.INSTANCE.enum(StartFrom.class, (Enum[])new StartFrom[0]));
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$2(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.HIGH);
            $this$of.setDefaultValue((Object)"");
            $this$of.setGroup(Groups.CONNECTOR.getTitle());
            Predicate predicate = Predicate.isEqual("USER_PROVIDED");
            Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
            $this$of.setRecommender(Recommenders.INSTANCE.visibleIf(SourceConfiguration.START_FROM, predicate));
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$3(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.MEDIUM);
            $this$of.setDefaultValue((Object)"false");
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            $this$of.setValidator(Validators.INSTANCE.bool());
            $this$of.setRecommender(Recommenders.INSTANCE.bool());
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$4(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.HIGH);
            $this$of.setDefaultValue((Object)"");
            $this$of.setGroup(Groups.CONNECTOR.getTitle());
            Predicate predicate = Predicate.isEqual("QUERY");
            Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
            $this$of.setRecommender(Recommenders.INSTANCE.visibleIf(SourceConfiguration.STRATEGY, predicate));
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$5(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.LOW);
            $this$of.setDefaultValue((Object)SourceConfiguration.DEFAULT_STREAMING_PROPERTY);
            $this$of.setGroup(Groups.CONNECTOR.getTitle());
            Predicate predicate = Predicate.isEqual("QUERY");
            Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
            $this$of.setRecommender(Recommenders.INSTANCE.visibleIf(SourceConfiguration.STRATEGY, predicate));
            $this$of.setValidator(Validators.INSTANCE.notBlankOrEmpty());
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$6(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.HIGH);
            $this$of.setDefaultValue((Object)"");
            $this$of.setGroup(Groups.CONNECTOR.getTitle());
            Predicate predicate = Predicate.isEqual("QUERY");
            Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
            $this$of.setRecommender(Recommenders.INSTANCE.visibleIf(SourceConfiguration.STRATEGY, predicate));
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$7(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.LOW);
            $this$of.setDefaultValue((Object)org.neo4j.connectors.kafka.configuration.helpers.DurationKt.toSimpleString-LRDsOJo((long)DEFAULT_QUERY_TIMEOUT));
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            Predicate predicate = Predicate.isEqual("QUERY");
            Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
            $this$of.setRecommender(Recommenders.INSTANCE.visibleIf(SourceConfiguration.STRATEGY, predicate));
            $this$of.setValidator(Validators.INSTANCE.pattern(org.neo4j.connectors.kafka.configuration.helpers.DurationKt.getSIMPLE_DURATION_PATTERN()));
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$8(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.MEDIUM);
            $this$of.setDefaultValue((Object)org.neo4j.connectors.kafka.configuration.helpers.DurationKt.toSimpleString-LRDsOJo((long)DEFAULT_QUERY_POLL_INTERVAL));
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            Predicate predicate = Predicate.isEqual("QUERY");
            Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
            $this$of.setRecommender(Recommenders.INSTANCE.visibleIf(SourceConfiguration.STRATEGY, predicate));
            $this$of.setValidator(Validators.INSTANCE.pattern(org.neo4j.connectors.kafka.configuration.helpers.DurationKt.getSIMPLE_DURATION_PATTERN()));
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$9(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.MEDIUM);
            $this$of.setDefaultValue((Object)org.neo4j.connectors.kafka.configuration.helpers.DurationKt.toSimpleString-LRDsOJo((long)DEFAULT_QUERY_POLL_DURATION));
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            Predicate predicate = Predicate.isEqual("QUERY");
            Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
            $this$of.setRecommender(Recommenders.INSTANCE.visibleIf(SourceConfiguration.STRATEGY, predicate));
            $this$of.setValidator(Validators.INSTANCE.pattern(org.neo4j.connectors.kafka.configuration.helpers.DurationKt.getSIMPLE_DURATION_PATTERN()));
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$10(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.LOW);
            $this$of.setDefaultValue((Object)true);
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            Predicate predicate = Predicate.isEqual("QUERY");
            Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
            $this$of.setRecommender(Recommenders.INSTANCE.visibleIf(SourceConfiguration.STRATEGY, predicate));
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$11(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.MEDIUM);
            $this$of.setDefaultValue((Object)1000);
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            Predicate predicate = Predicate.isEqual("QUERY");
            Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
            $this$of.setRecommender(Recommenders.INSTANCE.visibleIf(SourceConfiguration.STRATEGY, predicate));
            $this$of.setValidator((ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1));
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$12(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.MEDIUM);
            $this$of.setDefaultValue((Object)org.neo4j.connectors.kafka.configuration.helpers.DurationKt.toSimpleString-LRDsOJo((long)DEFAULT_CDC_POLL_INTERVAL));
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            Predicate predicate = Predicate.isEqual("CDC");
            Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
            $this$of.setRecommender(Recommenders.INSTANCE.visibleIf(SourceConfiguration.STRATEGY, predicate));
            $this$of.setValidator(Validators.INSTANCE.pattern(org.neo4j.connectors.kafka.configuration.helpers.DurationKt.getSIMPLE_DURATION_PATTERN()));
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$13(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.MEDIUM);
            $this$of.setDefaultValue((Object)org.neo4j.connectors.kafka.configuration.helpers.DurationKt.toSimpleString-LRDsOJo((long)DEFAULT_CDC_POLL_DURATION));
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            Predicate predicate = Predicate.isEqual("CDC");
            Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
            $this$of.setRecommender(Recommenders.INSTANCE.visibleIf(SourceConfiguration.STRATEGY, predicate));
            $this$of.setValidator(Validators.INSTANCE.pattern(org.neo4j.connectors.kafka.configuration.helpers.DurationKt.getSIMPLE_DURATION_PATTERN()));
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$14(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.MEDIUM);
            $this$of.setDefaultValue((Object)"EXTENDED");
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            $this$of.setValidator(Validators.INSTANCE.enum(PayloadMode.class, (Enum[])new PayloadMode[0]));
            $this$of.setRecommender(Recommenders.INSTANCE.enum(PayloadMode.class, (Enum[])new PayloadMode[0]));
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SourceType.values().length];
            try {
                nArray[SourceType.QUERY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceType.CDC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

