/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.source;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.source.ExactlyOnceSupport;
import org.apache.kafka.connect.source.SourceConnector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.connectors.kafka.configuration.helpers.VersionUtil;
import org.neo4j.connectors.kafka.source.Neo4jCdcTask;
import org.neo4j.connectors.kafka.source.Neo4jQueryTask;
import org.neo4j.connectors.kafka.source.SourceConfiguration;
import org.neo4j.connectors.kafka.source.SourceType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\u0006H\u0016J\u001e\u0010\n\u001a\u00020\u000b2\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eH\u0016J\"\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016J\b\u0010\u0007\u001a\u00020\u0015H\u0016J\u001e\u0010\u0016\u001a\u00020\u00172\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\fH\u0016J$\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/neo4j/connectors/kafka/source/Neo4jConnector;", "Lorg/apache/kafka/connect/source/SourceConnector;", "<init>", "()V", "props", "", "", "config", "Lorg/neo4j/connectors/kafka/source/SourceConfiguration;", "version", "start", "", "", "taskClass", "Ljava/lang/Class;", "Lorg/apache/kafka/connect/connector/Task;", "taskConfigs", "", "maxTasks", "", "stop", "Lorg/apache/kafka/common/config/ConfigDef;", "validate", "Lorg/apache/kafka/common/config/Config;", "connectorConfigs", "exactlyOnceSupport", "Lorg/apache/kafka/connect/source/ExactlyOnceSupport;", "connectorConfig", "source-connector"})
@SourceDebugExtension(value={"SMAP\nNeo4jConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Neo4jConnector.kt\norg/neo4j/connectors/kafka/source/Neo4jConnector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class Neo4jConnector
extends SourceConnector {
    private Map<String, String> props;
    private SourceConfiguration config;

    @NotNull
    public String version() {
        return VersionUtil.INSTANCE.version(Neo4jConnector.class);
    }

    public void start(@Nullable Map<String, String> props) {
        Map<String, String> map = props;
        Intrinsics.checkNotNull(map);
        Map originalProps = MapsKt.toMap(map);
        SourceConfiguration config = new SourceConfiguration(originalProps);
        config.validate();
        this.props = originalProps;
        this.config = config;
    }

    @NotNull
    public Class<? extends Task> taskClass() {
        Class<Neo4jCdcTask> clazz;
        SourceConfiguration sourceConfiguration = this.config;
        if (sourceConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            sourceConfiguration = null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[sourceConfiguration.getStrategy().ordinal()]) {
            case 1: {
                clazz = Neo4jCdcTask.class;
                break;
            }
            case 2: {
                clazz = Neo4jQueryTask.class;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return clazz;
    }

    @NotNull
    public List<Map<String, String>> taskConfigs(int maxTasks) {
        Map<String, String> map = this.props;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"props");
            map = null;
        }
        return CollectionsKt.listOf(map);
    }

    public void stop() {
    }

    @NotNull
    public ConfigDef config() {
        return SourceConfiguration.Companion.config();
    }

    @NotNull
    public Config validate(@Nullable Map<String, String> connectorConfigs) {
        Map map = connectorConfigs;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map originals = map;
        Config result = super.validate(originals);
        Intrinsics.checkNotNull((Object)result);
        SourceConfiguration.Companion.validate(result, originals);
        return result;
    }

    @Nullable
    public ExactlyOnceSupport exactlyOnceSupport(@Nullable Map<String, String> connectorConfig) {
        ExactlyOnceSupport exactlyOnceSupport;
        SourceType strategy;
        SourceType sourceType;
        Map<String, String> map = connectorConfig;
        if (map != null && (map = map.get("neo4j.source-strategy")) != null) {
            Map<String, String> it = map;
            boolean bl = false;
            sourceType = SourceType.valueOf((String)((Object)it));
        } else {
            sourceType = null;
        }
        SourceType sourceType2 = strategy = sourceType;
        switch (sourceType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[sourceType2.ordinal()]) {
            case 1: {
                exactlyOnceSupport = ExactlyOnceSupport.SUPPORTED;
                break;
            }
            case 2: {
                exactlyOnceSupport = ExactlyOnceSupport.UNSUPPORTED;
                break;
            }
            default: {
                exactlyOnceSupport = super.exactlyOnceSupport(connectorConfig);
            }
        }
        return exactlyOnceSupport;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SourceType.values().length];
            try {
                nArray[SourceType.CDC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceType.QUERY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

