/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.kotlin;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.module.kotlin.InternalCommonsKt;
import com.fasterxml.jackson.module.kotlin.ReflectionCache;
import com.fasterxml.jackson.module.kotlin.UByteSerializer;
import com.fasterxml.jackson.module.kotlin.UIntSerializer;
import com.fasterxml.jackson.module.kotlin.ULongSerializer;
import com.fasterxml.jackson.module.kotlin.UShortSerializer;
import com.fasterxml.jackson.module.kotlin.ValueClassStaticJsonValueSerializer;
import com.fasterxml.jackson.module.kotlin.ValueClassUnboxConverter;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/fasterxml/jackson/module/kotlin/KotlinSerializers;", "Lcom/fasterxml/jackson/databind/ser/Serializers$Base;", "cache", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache;", "<init>", "(Lcom/fasterxml/jackson/module/kotlin/ReflectionCache;)V", "findSerializer", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "config", "Lcom/fasterxml/jackson/databind/SerializationConfig;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "beanDesc", "Lcom/fasterxml/jackson/databind/BeanDescription;", "jackson-module-kotlin"})
public final class KotlinSerializers
extends Serializers.Base {
    @NotNull
    private final ReflectionCache cache;

    public KotlinSerializers(@NotNull ReflectionCache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.cache = cache;
    }

    @Nullable
    public JsonSerializer<?> findSerializer(@Nullable SerializationConfig config, @NotNull JavaType type, @Nullable BeanDescription beanDesc) {
        JsonSerializer jsonSerializer;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Class rawClass = type.getRawClass();
        if (Intrinsics.areEqual(UByte.class, (Object)rawClass)) {
            jsonSerializer = (JsonSerializer)UByteSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(UShort.class, (Object)rawClass)) {
            jsonSerializer = (JsonSerializer)UShortSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(UInt.class, (Object)rawClass)) {
            jsonSerializer = (JsonSerializer)UIntSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(ULong.class, (Object)rawClass)) {
            jsonSerializer = (JsonSerializer)ULongSerializer.INSTANCE;
        } else {
            Intrinsics.checkNotNull((Object)rawClass);
            if (InternalCommonsKt.isUnboxableValueClass(rawClass)) {
                ValueClassUnboxConverter<?, ?> unboxConverter = this.cache.getValueClassUnboxConverter(rawClass);
                ValueClassStaticJsonValueSerializer<?> valueClassStaticJsonValueSerializer = ValueClassStaticJsonValueSerializer.Companion.createOrNull(unboxConverter);
                jsonSerializer = (JsonSerializer)(valueClassStaticJsonValueSerializer != null ? (StdSerializer)valueClassStaticJsonValueSerializer : (StdSerializer)unboxConverter.getDelegatingSerializer());
            } else {
                jsonSerializer = null;
            }
        }
        return jsonSerializer;
    }
}

