/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.caniuse;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.neo4j.caniuse.Neo4jVersion;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/neo4j/caniuse/Neo4jVersionParser;", "", "<init>", "()V", "MIXED_CALVER_FORMAT", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "parse", "Lorg/neo4j/caniuse/Neo4jVersion;", "version", "", "parseRegex", "parseMinor", "", "buffer", "parsePatch", "caniuse-neo4j-detection"})
public final class Neo4jVersionParser {
    @NotNull
    public static final Neo4jVersionParser INSTANCE = new Neo4jVersionParser();
    private static final Pattern MIXED_CALVER_FORMAT = Pattern.compile("[^-]+-(\\d{4})(\\d{2})(\\d{1,})$");

    private Neo4jVersionParser() {
    }

    @NotNull
    public final Neo4jVersion parse(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Neo4jVersion mixCalVersion = this.parseRegex(version);
        if (mixCalVersion != null) {
            return mixCalVersion;
        }
        int major = -1;
        int minor = -1;
        int patch = -1;
        String buffer = "";
        char[] cArray = version.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        for (char c : cArray) {
            if (c != '.') {
                buffer = buffer + c;
                continue;
            }
            if (major == -1) {
                try {
                    major = Integer.parseInt(buffer, CharsKt.checkRadix((int)10));
                }
                catch (NumberFormatException numberFormatException) {
                    return Neo4jVersion.Companion.getLATEST();
                }
            } else if (minor == -1) {
                try {
                    minor = this.parseMinor(buffer);
                }
                catch (NumberFormatException numberFormatException) {
                    return Neo4jVersion.Companion.getLATEST();
                }
            } else {
                return Neo4jVersion.Companion.getLATEST();
            }
            buffer = "";
        }
        if (((CharSequence)buffer).length() == 0) {
            return Neo4jVersion.Companion.getLATEST();
        }
        if (minor == -1) {
            try {
                minor = this.parseMinor(buffer);
            }
            catch (NumberFormatException numberFormatException) {
                return Neo4jVersion.Companion.getLATEST();
            }
        }
        try {
            patch = this.parsePatch(buffer);
        }
        catch (NumberFormatException numberFormatException) {
            return Neo4jVersion.Companion.getLATEST();
        }
        if (major == -1 || minor == -1) {
            return Neo4jVersion.Companion.getLATEST();
        }
        if (patch == -1) {
            return new Neo4jVersion(major, minor, 0, 4, null);
        }
        return new Neo4jVersion(major, minor, patch);
    }

    private final Neo4jVersion parseRegex(String version) {
        Matcher matcher = MIXED_CALVER_FORMAT.matcher(version);
        if (matcher.find()) {
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            int major = Integer.parseInt(string);
            String string2 = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            int minor = Integer.parseInt(string2);
            String string3 = matcher.group(3);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
            int patch = Integer.parseInt(string3);
            return new Neo4jVersion(major, minor, patch);
        }
        return null;
    }

    private final int parseMinor(String buffer) {
        return Integer.parseInt(StringsKt.replace$default((String)buffer, (String)"-aura", (String)"", (boolean)false, (int)4, null), CharsKt.checkRadix((int)10));
    }

    private final int parsePatch(String buffer) {
        int patch = 0;
        int end = StringsKt.indexOf$default((CharSequence)buffer, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (end == -1) {
            end = buffer.length();
        }
        String string = buffer.substring(0, end);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        patch = Integer.parseInt(string, CharsKt.checkRadix((int)10));
        return patch;
    }
}

