/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.internal;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.Clause;

@API(status=API.Status.INTERNAL, since="2021.2.1")
public final class LoadCSV
implements Clause {
    private final URI uri;
    private final boolean withHeaders;
    private final String alias;
    private final String fieldTerminator;

    public LoadCSV(URI uri, boolean withHeaders, String alias) {
        this(uri, withHeaders, alias, null);
    }

    private LoadCSV(URI uri, boolean withHeaders, String alias, @Nullable String fieldTerminator) {
        this.uri = uri;
        this.withHeaders = withHeaders;
        this.alias = alias;
        this.fieldTerminator = fieldTerminator;
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean isWithHeaders() {
        return this.withHeaders;
    }

    @Nullable
    public String getFieldTerminator() {
        return this.fieldTerminator;
    }

    public String getAlias() {
        return this.alias;
    }

    @NotNull
    @Contract(pure=true)
    public LoadCSV withFieldTerminator(@Nullable String newFieldTerminator) {
        String value = Optional.ofNullable(newFieldTerminator).map(String::trim).filter(v -> !v.isEmpty()).orElse(null);
        if (Objects.equals(this.fieldTerminator, value)) {
            return this;
        }
        return new LoadCSV(this.uri, this.withHeaders, this.alias, value);
    }
}

