/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.caniuse.CanIUse;
import org.neo4j.caniuse.Cypher;
import org.neo4j.caniuse.Neo4j;
import org.neo4j.caniuse.Neo4jVersion;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.neo4j.cypherdsl.core.renderer.Dialect;
import org.neo4j.cypherdsl.core.renderer.Renderer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/neo4j/connectors/kafka/sink/Cypher25Renderer;", "Lorg/neo4j/cypherdsl/core/renderer/Renderer;", "neo4j", "Lorg/neo4j/caniuse/Neo4j;", "<init>", "(Lorg/neo4j/caniuse/Neo4j;)V", "isCypher25PrefixSupported", "", "delegateRenderer", "kotlin.jvm.PlatformType", "render", "", "statement", "Lorg/neo4j/cypherdsl/core/Statement;", "Companion", "sink"})
public final class Cypher25Renderer
implements Renderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isCypher25PrefixSupported;
    private final Renderer delegateRenderer;
    @NotNull
    private static final Neo4jVersion Neo4jVersion5 = new Neo4jVersion(5, 0, 0);

    public Cypher25Renderer(@NotNull Neo4j neo4j) {
        Intrinsics.checkNotNullParameter((Object)neo4j, (String)"neo4j");
        this.isCypher25PrefixSupported = CanIUse.INSTANCE.canIUse(Cypher.INSTANCE.explicitCypher25Selection()).withNeo4j(neo4j);
        this.delegateRenderer = Renderer.getRenderer((Configuration)Configuration.newConfig().withDialect(neo4j.getVersion().compareTo(Neo4jVersion5) < 0 ? Dialect.DEFAULT : Dialect.NEO4J_5).build());
    }

    @Nullable
    public String render(@Nullable Statement statement) {
        String rendered = this.delegateRenderer.render(statement);
        if (this.isCypher25PrefixSupported) {
            return "CYPHER 25 " + rendered;
        }
        return rendered;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/neo4j/connectors/kafka/sink/Cypher25Renderer$Companion;", "", "<init>", "()V", "Neo4jVersion5", "Lorg/neo4j/caniuse/Neo4jVersion;", "sink"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

