/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.apache.kafka.connect.sink.ErrantRecordReporter;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.neo4j.connectors.kafka.configuration.helpers.VersionUtil;
import org.neo4j.connectors.kafka.sink.ChangeQuery;
import org.neo4j.connectors.kafka.sink.SinkConfiguration;
import org.neo4j.connectors.kafka.sink.SinkMessage;
import org.neo4j.connectors.kafka.sink.SinkStrategyHandler;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\bH\u0016J\u001e\u0010\u0010\u001a\u00020\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016H\u0016J\u001e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lorg/neo4j/connectors/kafka/sink/Neo4jSinkTask;", "Lorg/apache/kafka/connect/sink/SinkTask;", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "settings", "", "", "config", "Lorg/neo4j/connectors/kafka/sink/SinkConfiguration;", "getConfig", "()Lorg/neo4j/connectors/kafka/sink/SinkConfiguration;", "setConfig", "(Lorg/neo4j/connectors/kafka/sink/SinkConfiguration;)V", "version", "start", "", "props", "stop", "put", "records", "", "Lorg/apache/kafka/connect/sink/SinkRecord;", "processMessages", "handler", "Lorg/neo4j/connectors/kafka/sink/SinkStrategyHandler;", "messages", "", "Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "sink"})
@SourceDebugExtension(value={"SMAP\nNeo4jSinkTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Neo4jSinkTask.kt\norg/neo4j/connectors/kafka/sink/Neo4jSinkTask\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,115:1\n24#2:116\n63#2,2:117\n65#2:145\n95#2:146\n135#2,3:147\n24#2:150\n63#2,2:151\n65#2:162\n1586#3:119\n1661#3,3:120\n1512#3:123\n1538#3,3:124\n1541#3,3:134\n1266#3,4:139\n1924#3,2:153\n1391#3:155\n1480#3,5:156\n1926#3:161\n1915#3,2:163\n1915#3,2:165\n1915#3,2:167\n1391#3:169\n1480#3,5:170\n383#4,7:127\n481#4:137\n427#4:138\n221#5,2:143\n*S KotlinDebug\n*F\n+ 1 Neo4jSinkTask.kt\norg/neo4j/connectors/kafka/sink/Neo4jSinkTask\n*L\n52#1:116\n52#1:117,2\n52#1:145\n66#1:146\n66#1:147,3\n75#1:150\n75#1:151,2\n75#1:162\n54#1:119\n54#1:120,3\n55#1:123\n55#1:124,3\n55#1:134,3\n56#1:139,4\n76#1:153,2\n87#1:155\n87#1:156,5\n76#1:161\n101#1:163,2\n103#1:165,2\n81#1:167,2\n82#1:169\n82#1:170,5\n55#1:127,7\n56#1:137\n56#1:138\n57#1:143,2\n*E\n"})
public final class Neo4jSinkTask
extends SinkTask {
    @NotNull
    private final Logger log;
    private Map<String, String> settings;
    @VisibleForTesting
    public SinkConfiguration config;

    public Neo4jSinkTask() {
        Logger logger = LoggerFactory.getLogger(Neo4jSinkTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.log = logger;
    }

    @NotNull
    public final SinkConfiguration getConfig() {
        SinkConfiguration sinkConfiguration = this.config;
        if (sinkConfiguration != null) {
            return sinkConfiguration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return null;
    }

    public final void setConfig(@NotNull SinkConfiguration sinkConfiguration) {
        Intrinsics.checkNotNullParameter((Object)((Object)sinkConfiguration), (String)"<set-?>");
        this.config = sinkConfiguration;
    }

    @NotNull
    public String version() {
        return VersionUtil.INSTANCE.version(Neo4jSinkTask.class);
    }

    public void start(@Nullable Map<String, String> props) {
        this.log.info("starting");
        Map<String, String> map = props;
        Intrinsics.checkNotNull(map);
        this.settings = map;
        Map<String, String> map2 = this.settings;
        if (map2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            map2 = null;
        }
        this.setConfig(new SinkConfiguration(map2));
    }

    public void stop() {
        if (this.config != null) {
            this.getConfig().close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void put(@Nullable Collection<? extends SinkRecord> records) {
        Collection<? extends SinkRecord> collection = records;
        this.log.info("received {} records", (Object)(collection != null ? collection.size() : 0));
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        if (records != null) {
            void $this$forEach$iv;
            void $this$associateByTo$iv$iv$iv;
            void $this$mapKeysTo$iv$iv;
            Map $this$mapKeys$iv;
            Object value$iv$iv$iv;
            Object key$iv$iv$iv;
            Object element$iv$iv2;
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            Object object;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = records;
            boolean $i$f$map22 = false;
            void var12_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SinkRecord sinkRecord = (SinkRecord)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                object.add(new SinkMessage((SinkRecord)it));
            }
            Iterable $i$f$map22 = (List)destination$iv$iv;
            boolean $i$f$groupBy22 = false;
            destination$iv$iv = $this$groupBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
                Object object2;
                void $this$getOrPut$iv$iv$iv;
                SinkMessage it = (SinkMessage)element$iv$iv2;
                boolean bl3 = false;
                String key$iv$iv = it.getTopic();
                Map map = destination$iv$iv2;
                key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv2);
            }
            Map $i$f$groupBy22 = destination$iv$iv2;
            boolean $i$f$mapKeys = false;
            destination$iv$iv2 = $this$mapKeys$iv;
            Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            element$iv$iv2 = $this$mapKeysTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                key$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                object = destination$iv$iv$iv;
                boolean bl5 = false;
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                SinkStrategyHandler sinkStrategyHandler = (SinkStrategyHandler)MapsKt.getValue(this.getConfig().getTopicHandlers(), it.getKey());
                Object object3 = object;
                boolean bl6 = false;
                Object v = it$iv$iv.getValue();
                object3.put(sinkStrategyHandler, v);
            }
            $this$mapKeys$iv = destination$iv$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl7 = false;
                SinkStrategyHandler handler = (SinkStrategyHandler)entry.getKey();
                List messages = (List)entry.getValue();
                this.processMessages(handler, messages);
            }
        }
        long duration = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        Collection<? extends SinkRecord> collection2 = records;
        this.log.info("processed {} records in {} ms", (Object)(collection2 != null ? collection2.size() : 0), (Object)Duration.getInWholeMilliseconds-impl((long)duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void processMessages(SinkStrategyHandler handler, List<SinkMessage> messages) {
        Set handled = new LinkedHashSet();
        try {
            this.log.debug("handing {} messages to handler {}", (Object)messages.size(), (Object)handler.strategy());
            boolean $i$f$measureTimedValue = false;
            TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            long mark$iv$iv22 = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            Iterable<Iterable<ChangeQuery>> result$iv$iv = handler.handle((Iterable<SinkMessage>)messages);
            TimedValue timedValue = new TimedValue(result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv22), null);
            Iterable txGroups = (Iterable)timedValue.component1();
            long handlerDuration = timedValue.component2-UwyO8pc();
            Object[] mark$iv$iv22 = new Object[]{handler.strategy(), CollectionsKt.count((Iterable)txGroups), Duration.getInWholeMilliseconds-impl((long)handlerDuration)};
            this.log.debug("handler {} produced {} transaction groups in {} ms", mark$iv$iv22);
            this.log.debug("writing to neo4j");
            boolean $i$f$measureTime = false;
            TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
            boolean bl2 = false;
            Iterable $this$forEachIndexed$iv = txGroups;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                void group;
                Session session;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Iterable iterable = (Iterable)item$iv;
                int index = n;
                boolean bl3 = false;
                this.log.trace("processing queries for group {}", (Object)index);
                AutoCloseable autoCloseable = (AutoCloseable)this.getConfig().getDriver().session(this.getConfig().sessionConfig(new Bookmark[0]));
                Throwable throwable = null;
                try {
                    session = (Session)autoCloseable;
                    boolean bl4 = false;
                    this.log.trace("before write transaction for group {}", (Object)index);
                    session.writeTransaction(arg_0 -> Neo4jSinkTask.processMessages$lambda$1$0$0$0((Iterable)group, arg_0), this.getConfig().txConfig(arg_0 -> Neo4jSinkTask.processMessages$lambda$1$0$0$1((Iterable)group, arg_0)));
                    this.log.trace("after write transaction for group {}", (Object)index);
                    session = Unit.INSTANCE;
                }
                catch (Throwable bl4) {
                    throwable = bl4;
                    throw bl4;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                autoCloseable = group;
                Set set = handled;
                boolean $i$f$flatMap = false;
                session = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    ChangeQuery it = (ChangeQuery)element$iv$iv;
                    boolean bl5 = false;
                    Iterable<SinkMessage> list$iv$iv = it.getMessages();
                    CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
                }
                set.addAll((List)destination$iv$iv);
            }
            long writeDuration = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
            this.log.debug("wrote {} transaction groups to neo4j in {} ms", (Object)CollectionsKt.count((Iterable)txGroups), (Object)Duration.getInWholeMilliseconds-impl((long)writeDuration));
        }
        catch (Throwable e) {
            this.log.warn("failed to process messages, trying to identify offending message", e);
            List unhandled = CollectionsKt.minus((Iterable)messages, (Iterable)handled);
            if (unhandled.size() > 1) {
                Iterable $this$forEach$iv = unhandled;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SinkMessage m = (SinkMessage)element$iv;
                    boolean bl = false;
                    this.processMessages(handler, CollectionsKt.listOf((Object)m));
                }
            } else {
                Iterable $this$forEach$iv = unhandled;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SinkMessage m = (SinkMessage)element$iv;
                    boolean bl = false;
                    ErrantRecordReporter reporter = this.context.errantRecordReporter();
                    if (reporter != null) {
                        Void cfr_ignored_0 = (Void)reporter.report(m.getRecord(), e).get();
                        continue;
                    }
                    throw e;
                }
            }
        }
    }

    private static final Unit processMessages$lambda$1$0$0$0(Iterable $group, Transaction tx) {
        Iterable $this$forEach$iv = $group;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChangeQuery it = (ChangeQuery)element$iv;
            boolean bl = false;
            tx.run(it.getQuery()).consume();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit processMessages$lambda$1$0$0$1(Iterable $group, Map $this$txConfig) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$txConfig, (String)"$this$txConfig");
        Map map = $this$txConfig;
        String string = "batch-size";
        Iterable $this$flatMap$iv = $group;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ChangeQuery it = (ChangeQuery)element$iv$iv;
            boolean bl = false;
            Iterable<SinkMessage> list$iv$iv = it.getMessages();
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        Integer n = ((List)destination$iv$iv).size();
        map.put(string, n);
        return Unit.INSTANCE;
    }
}

