/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.sink.SinkRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.connectors.kafka.data.DynamicTypes;
import org.neo4j.connectors.kafka.data.HeadersKt;
import org.neo4j.connectors.kafka.utils.JSONUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010%\u001a\u0004\u0018\u00010\u0001J\b\u0010&\u001a\u0004\u0018\u00010\u0001J\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010(J\u001e\u0010)\u001a\u0004\u0018\u00010\u00012\b\u0010*\u001a\u0004\u0018\u00010\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0002J\n\u0010+\u001a\u00020\tH\u0096\u0080\u0004J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010.\u001a\u00020\u001d2\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u00100\u001a\u00020\"H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000fR\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u001d\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u00061"}, d2={"Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "", "record", "Lorg/apache/kafka/connect/sink/SinkRecord;", "<init>", "(Lorg/apache/kafka/connect/sink/SinkRecord;)V", "getRecord", "()Lorg/apache/kafka/connect/sink/SinkRecord;", "topic", "", "getTopic", "()Ljava/lang/String;", "keySchema", "Lorg/apache/kafka/connect/data/Schema;", "getKeySchema", "()Lorg/apache/kafka/connect/data/Schema;", "key", "getKey", "()Ljava/lang/Object;", "valueSchema", "getValueSchema", "value", "getValue", "headers", "", "Lorg/apache/kafka/connect/header/Header;", "getHeaders", "()Ljava/lang/Iterable;", "isCdcMessage", "", "()Z", "cdcTxInfo", "Lkotlin/Pair;", "", "", "getCdcTxInfo", "()Lkotlin/Pair;", "valueFromConnectValue", "keyFromConnectValue", "headerFromConnectValue", "", "fromConnectValue", "schema", "toString", "component1", "copy", "equals", "other", "hashCode", "sink"})
@SourceDebugExtension(value={"SMAP\nSinkStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SinkStrategy.kt\norg/neo4j/connectors/kafka/sink/SinkMessage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 JSONUtils.kt\norg/neo4j/connectors/kafka/utils/JSONUtils\n+ 4 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,309:1\n1205#2,2:310\n1282#2,4:312\n341#3,8:316\n349#3:337\n350#3:352\n352#3,9:367\n117#4:324\n55#4:325\n118#4:326\n62#4,8:327\n72#4:336\n140#4:338\n55#4:339\n141#4:340\n62#4,11:341\n157#4:353\n55#4:354\n158#4:355\n62#4,11:356\n1#5:335\n*S KotlinDebug\n*F\n+ 1 SinkStrategy.kt\norg/neo4j/connectors/kafka/sink/SinkMessage\n*L\n81#1:310,2\n81#1:312,4\n94#1:316,8\n94#1:337\n94#1:352\n94#1:367,9\n94#1:324\n94#1:325\n94#1:326\n94#1:327,8\n94#1:336\n94#1:338\n94#1:339\n94#1:340\n94#1:341,11\n94#1:353\n94#1:354\n94#1:355\n94#1:356,11\n94#1:335\n*E\n"})
public final class SinkMessage {
    @NotNull
    private final SinkRecord record;

    public SinkMessage(@NotNull SinkRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        this.record = record;
    }

    @NotNull
    public final SinkRecord getRecord() {
        return this.record;
    }

    @NotNull
    public final String getTopic() {
        String string = this.record.topic();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"topic(...)");
        return string;
    }

    @Nullable
    public final Schema getKeySchema() {
        return this.record.keySchema();
    }

    @Nullable
    public final Object getKey() {
        return this.record.key();
    }

    @Nullable
    public final Schema getValueSchema() {
        return this.record.valueSchema();
    }

    @Nullable
    public final Object getValue() {
        return this.record.value();
    }

    @NotNull
    public final Iterable<Header> getHeaders() {
        Headers headers = this.record.headers();
        Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"headers(...)");
        return (Iterable)headers;
    }

    public final boolean isCdcMessage() {
        return HeadersKt.isCdcMessage((SinkRecord)this.record);
    }

    @NotNull
    public final Pair<Long, Integer> getCdcTxInfo() {
        if (!this.isCdcMessage()) {
            throw new IllegalArgumentException("not a message generated by cdc");
        }
        Long l = HeadersKt.cdcTxId((SinkRecord)this.record);
        Intrinsics.checkNotNull((Object)l);
        Integer n = HeadersKt.cdcTxSeq((SinkRecord)this.record);
        Intrinsics.checkNotNull((Object)n);
        return new Pair((Object)l, (Object)n);
    }

    @Nullable
    public final Object valueFromConnectValue() {
        return this.fromConnectValue(this.getValueSchema(), this.getValue());
    }

    @Nullable
    public final Object keyFromConnectValue() {
        return this.fromConnectValue(this.getKeySchema(), this.getKey());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> headerFromConnectValue() {
        void $this$associateTo$iv$iv;
        Iterable<Header> $this$associate$iv = this.getHeaders();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
        Iterable<Header> iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Header it = (Header)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.key(), (Object)this.fromConnectValue(it.schema(), it.value()));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Object fromConnectValue(Schema schema, Object value) {
        Object object;
        block26: {
            block25: {
                Object object2;
                object = schema;
                if (object == null) break block25;
                Schema it = object;
                boolean bl = false;
                Object object3 = DynamicTypes.fromConnectValue$default((DynamicTypes)DynamicTypes.INSTANCE, (Schema)it, (Object)value, (boolean)false, (int)4, null);
                if (object3 != null) {
                    Object it2 = object3;
                    boolean bl2 = false;
                    Object object4 = schema.name();
                    if ((object4 == null || object4.length() == 0) && (schema.type() == Schema.Type.STRING || schema.type() == Schema.Type.BYTES)) {
                        try {
                            void v6;
                            void $this$checkTypeMismatch$iv$iv$iv;
                            boolean $i$f$checkTypeMismatch;
                            Object $i$f$jacksonTypeRef22;
                            ObjectMapper $this$readValue$iv$iv;
                            boolean $i$f$readValue;
                            void $this$iv;
                            object4 = JSONUtils.INSTANCE;
                            Object value$iv = it2;
                            boolean stringWhenFailure$iv = false;
                            ObjectMapper objectMapper$iv = $this$iv.getObjectMapper();
                            boolean $i$f$readValue2 = false;
                            Object object5 = value$iv;
                            if (object5 instanceof String) {
                                ObjectMapper objectMapper = objectMapper$iv;
                                String content$iv$iv = (String)value$iv;
                                $i$f$readValue = false;
                                boolean $i$f$jacksonTypeRef22 = false;
                                $i$f$jacksonTypeRef22 = $this$readValue$iv$iv.readValue(content$iv$iv, (TypeReference)new TypeReference<Object>(){});
                                $i$f$checkTypeMismatch = false;
                                void v2 = $this$checkTypeMismatch$iv$iv$iv;
                                if (!(v2 != null ? v2 instanceof Object : true)) {
                                    String string;
                                    String nullability$iv$iv$iv = "?";
                                    StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(Object.class).getQualifiedName()).append(nullability$iv$iv$iv).append(" but was ");
                                    void v4 = $this$checkTypeMismatch$iv$iv$iv;
                                    if (v4 != null) {
                                        void it$iv$iv$iv;
                                        void var19_26 = v4;
                                        StringBuilder stringBuilder2 = stringBuilder;
                                        boolean bl3 = false;
                                        string = Reflection.getOrCreateKotlinClass(it$iv$iv$iv.getClass()).getQualifiedName();
                                        stringBuilder = stringBuilder2;
                                    } else {
                                        string = null;
                                    }
                                    String string2 = stringBuilder.append(string).toString();
                                    throw new RuntimeJsonMappingException(string2);
                                }
                                v6 = $this$checkTypeMismatch$iv$iv$iv;
                            } else if (object5 instanceof byte[]) {
                                $this$readValue$iv$iv = objectMapper$iv;
                                byte[] src$iv$iv = (byte[])value$iv;
                                $i$f$readValue = false;
                                boolean $i$f$jacksonTypeRef = false;
                                $i$f$jacksonTypeRef22 = $this$readValue$iv$iv.readValue(src$iv$iv, (TypeReference)new TypeReference<Object>(){});
                                $i$f$checkTypeMismatch = false;
                                void v7 = $this$checkTypeMismatch$iv$iv$iv;
                                if (!(v7 != null ? v7 instanceof Object : true)) {
                                    String string;
                                    String nullability$iv$iv$iv = "?";
                                    StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(Object.class).getQualifiedName()).append(nullability$iv$iv$iv).append(" but was ");
                                    void v9 = $this$checkTypeMismatch$iv$iv$iv;
                                    if (v9 != null) {
                                        void it$iv$iv$iv = v9;
                                        StringBuilder stringBuilder3 = stringBuilder;
                                        boolean bl4 = false;
                                        string = Reflection.getOrCreateKotlinClass(it$iv$iv$iv.getClass()).getQualifiedName();
                                        stringBuilder = stringBuilder3;
                                    } else {
                                        string = null;
                                    }
                                    String string3 = stringBuilder.append(string).toString();
                                    throw new RuntimeJsonMappingException(string3);
                                }
                                v6 = $this$checkTypeMismatch$iv$iv$iv;
                            } else {
                                void $this$convertValue$iv$iv;
                                $this$readValue$iv$iv = objectMapper$iv;
                                Object from$iv$iv = value$iv;
                                boolean $i$f$convertValue = false;
                                boolean $i$f$jacksonTypeRef = false;
                                $i$f$jacksonTypeRef22 = $this$convertValue$iv$iv.convertValue(from$iv$iv, (TypeReference)new TypeReference<Object>(){});
                                $i$f$checkTypeMismatch = false;
                                void v11 = $this$checkTypeMismatch$iv$iv$iv;
                                if (!(v11 != null ? v11 instanceof Object : true)) {
                                    String string;
                                    String nullability$iv$iv$iv = "?";
                                    StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(Object.class).getQualifiedName()).append(nullability$iv$iv$iv).append(" but was ");
                                    void v13 = $this$checkTypeMismatch$iv$iv$iv;
                                    if (v13 != null) {
                                        void it$iv$iv$iv = v13;
                                        StringBuilder stringBuilder4 = stringBuilder;
                                        boolean bl5 = false;
                                        string = Reflection.getOrCreateKotlinClass(it$iv$iv$iv.getClass()).getQualifiedName();
                                        stringBuilder = stringBuilder4;
                                    } else {
                                        string = null;
                                    }
                                    String string4 = stringBuilder.append(string).toString();
                                    throw new RuntimeJsonMappingException(string4);
                                }
                                v6 = $this$checkTypeMismatch$iv$iv$iv;
                            }
                            object5 = v6;
                            object4 = object5;
                        }
                        catch (JsonParseException ex) {
                            object4 = it2;
                        }
                        object2 = object4;
                    } else {
                        object2 = it2;
                    }
                } else {
                    object2 = null;
                }
                object = object2;
                if (object2 != null) break block26;
            }
            object = value;
        }
        return object;
    }

    @NotNull
    public String toString() {
        return "SinkMessage{topic=" + this.record.topic() + ",partition=" + this.record.kafkaPartition() + ",offset=" + this.record.kafkaOffset() + ",timestamp=" + this.record.timestamp() + ",timestampType=" + this.record.timestampType() + "}";
    }

    @NotNull
    public final SinkRecord component1() {
        return this.record;
    }

    @NotNull
    public final SinkMessage copy(@NotNull SinkRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        return new SinkMessage(record);
    }

    public static /* synthetic */ SinkMessage copy$default(SinkMessage sinkMessage, SinkRecord sinkRecord, int n, Object object) {
        if ((n & 1) != 0) {
            sinkRecord = sinkMessage.record;
        }
        return sinkMessage.copy(sinkRecord);
    }

    public int hashCode() {
        return this.record.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SinkMessage)) {
            return false;
        }
        SinkMessage sinkMessage = (SinkMessage)other;
        return Intrinsics.areEqual((Object)this.record, (Object)sinkMessage.record);
    }
}

