/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cdc.client.model.EntityEvent;
import org.neo4j.cdc.client.model.NodeEvent;
import org.neo4j.cdc.client.model.NodeState;
import org.neo4j.cdc.client.model.RelationshipEvent;
import org.neo4j.cdc.client.model.RelationshipState;
import org.neo4j.connectors.kafka.exceptions.InvalidDataException;
import org.neo4j.connectors.kafka.sink.SinkStrategy;
import org.neo4j.connectors.kafka.sink.strategy.CdcHandler;
import org.neo4j.connectors.kafka.sink.strategy.EventExtensionsKt;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.Query;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0016H\u0014J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0016H\u0014J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J*\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/CdcSourceIdHandler;", "Lorg/neo4j/connectors/kafka/sink/strategy/CdcHandler;", "topic", "", "renderer", "Lorg/neo4j/cypherdsl/core/renderer/Renderer;", "labelName", "propertyName", "<init>", "(Ljava/lang/String;Lorg/neo4j/cypherdsl/core/renderer/Renderer;Ljava/lang/String;Ljava/lang/String;)V", "getTopic", "()Ljava/lang/String;", "getLabelName", "getPropertyName", "strategy", "Lorg/neo4j/connectors/kafka/sink/SinkStrategy;", "transformCreate", "Lorg/neo4j/driver/Query;", "event", "Lorg/neo4j/cdc/client/model/NodeEvent;", "transformUpdate", "transformDelete", "Lorg/neo4j/cdc/client/model/RelationshipEvent;", "buildNode", "Lorg/neo4j/cypherdsl/core/Node;", "elementId", "named", "buildRelationship", "Lkotlin/Triple;", "Lorg/neo4j/cypherdsl/core/Relationship;", "sink"})
public final class CdcSourceIdHandler
extends CdcHandler {
    @NotNull
    private final String topic;
    @NotNull
    private final Renderer renderer;
    @NotNull
    private final String labelName;
    @NotNull
    private final String propertyName;

    public CdcSourceIdHandler(@NotNull String topic, @NotNull Renderer renderer, @NotNull String labelName, @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)labelName, (String)"labelName");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        this.topic = topic;
        this.renderer = renderer;
        this.labelName = labelName;
        this.propertyName = propertyName;
    }

    public /* synthetic */ CdcSourceIdHandler(String string, Renderer renderer, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "SourceEvent";
        }
        if ((n & 8) != 0) {
            string3 = "sourceId";
        }
        this(string, renderer, string2, string3);
    }

    @NotNull
    public final String getTopic() {
        return this.topic;
    }

    @NotNull
    public final String getLabelName() {
        return this.labelName;
    }

    @NotNull
    public final String getPropertyName() {
        return this.propertyName;
    }

    @Override
    @NotNull
    public SinkStrategy strategy() {
        return SinkStrategy.CDC_SOURCE_ID;
    }

    @Override
    @NotNull
    protected Query transformCreate(@NotNull NodeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAfter() == null) {
            throw new InvalidDataException("create operation requires 'after' field in the event object");
        }
        String string = event.getElementId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementId(...)");
        Node node = this.buildNode(string, "n");
        PatternElement[] patternElementArray = new PatternElement[]{node};
        StatementBuilder.BuildableMatchAndUpdate it = Cypher.merge((PatternElement[])patternElementArray).mutate((Named)node, (Expression)Cypher.parameter((String)"nProps", (Object)((NodeState)event.getAfter()).getProperties()));
        boolean bl = false;
        List list = ((NodeState)event.getAfter()).getLabels();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLabels(...)");
        Statement statement = (!((Collection)list).isEmpty() ? it.set(node, (Collection)((NodeState)event.getAfter()).getLabels()) : it).build();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"build(...)");
        Statement stmt = statement;
        return new Query(this.renderer.render(stmt), stmt.getParameters());
    }

    @Override
    @NotNull
    protected Query transformUpdate(@NotNull NodeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getBefore() == null) {
            throw new InvalidDataException("update operation requires 'before' field in the event object");
        }
        if (event.getAfter() == null) {
            throw new InvalidDataException("update operation requires 'after' field in the event object");
        }
        String string = event.getElementId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementId(...)");
        Node node = this.buildNode(string, "n");
        PatternElement[] patternElementArray = new PatternElement[]{node};
        StatementBuilder.BuildableMatchAndUpdate it = Cypher.merge((PatternElement[])patternElementArray).mutate((Named)node, (Expression)Cypher.parameter((String)"nProps", EventExtensionsKt.mutatedProperties((EntityEvent)event)));
        boolean bl = false;
        Collection<String> addedLabels = EventExtensionsKt.addedLabels(event);
        it = !addedLabels.isEmpty() ? it.set(node, addedLabels) : it;
        boolean bl2 = false;
        Collection<String> removedLabels = EventExtensionsKt.removedLabels(event);
        Statement statement = (!removedLabels.isEmpty() ? it.remove(node, removedLabels) : it).build();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"build(...)");
        Statement stmt = statement;
        return new Query(this.renderer.render(stmt), stmt.getParameters());
    }

    @Override
    @NotNull
    protected Query transformDelete(@NotNull NodeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getElementId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementId(...)");
        Node node = this.buildNode(string, "n");
        PatternElement[] patternElementArray = new PatternElement[]{node};
        StatementBuilder.OngoingReadingWithoutWhere ongoingReadingWithoutWhere = Cypher.match((PatternElement[])patternElementArray);
        patternElementArray = new Named[]{node};
        Statement statement = ongoingReadingWithoutWhere.detachDelete((Named[])patternElementArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"build(...)");
        Statement stmt = statement;
        return new Query(this.renderer.render(stmt), stmt.getParameters());
    }

    @Override
    @NotNull
    protected Query transformCreate(@NotNull RelationshipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAfter() == null) {
            throw new InvalidDataException("create operation requires 'after' field in the event object");
        }
        Triple<Node, Node, Relationship> triple = this.buildRelationship(event, "r");
        Node start = (Node)triple.component1();
        Node end = (Node)triple.component2();
        Relationship rel = (Relationship)triple.component3();
        PatternElement[] patternElementArray = new PatternElement[]{start};
        StatementBuilder.OngoingMerge ongoingMerge = Cypher.merge((PatternElement[])patternElementArray);
        patternElementArray = new PatternElement[]{end};
        StatementBuilder.OngoingMerge ongoingMerge2 = ongoingMerge.merge(patternElementArray);
        patternElementArray = new PatternElement[]{rel};
        Statement statement = ongoingMerge2.merge(patternElementArray).mutate((Named)rel, (Expression)Cypher.parameter((String)"rProps", (Object)((RelationshipState)event.getAfter()).getProperties())).build();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"build(...)");
        Statement stmt = statement;
        return new Query(this.renderer.render(stmt), stmt.getParameters());
    }

    @Override
    @NotNull
    protected Query transformUpdate(@NotNull RelationshipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getBefore() == null) {
            throw new InvalidDataException("update operation requires 'before' field in the event object");
        }
        if (event.getAfter() == null) {
            throw new InvalidDataException("update operation requires 'after' field in the event object");
        }
        Triple<Node, Node, Relationship> triple = this.buildRelationship(event, "r");
        Node start = (Node)triple.component1();
        Node end = (Node)triple.component2();
        Relationship rel = (Relationship)triple.component3();
        PatternElement[] patternElementArray = new PatternElement[]{start};
        StatementBuilder.OngoingMerge ongoingMerge = Cypher.merge((PatternElement[])patternElementArray);
        patternElementArray = new PatternElement[]{end};
        StatementBuilder.OngoingMerge ongoingMerge2 = ongoingMerge.merge(patternElementArray);
        patternElementArray = new PatternElement[]{rel};
        Statement statement = ongoingMerge2.merge(patternElementArray).mutate((Named)rel, (Expression)Cypher.parameter((String)"rProps", EventExtensionsKt.mutatedProperties((EntityEvent)event))).build();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"build(...)");
        Statement stmt = statement;
        return new Query(this.renderer.render(stmt), stmt.getParameters());
    }

    @Override
    @NotNull
    protected Query transformDelete(@NotNull RelationshipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object[] objectArray = new String[]{event.getType()};
        Relationship relationship = (Relationship)Cypher.anyNode().relationshipTo(Cypher.anyNode(), (String[])objectArray);
        objectArray = new Object[]{this.propertyName, Cypher.parameter((String)"rElementId", (Object)event.getElementId())};
        Relationship relationship2 = ((Relationship)relationship.withProperties(objectArray)).named("r");
        Intrinsics.checkNotNullExpressionValue((Object)relationship2, (String)"named(...)");
        Relationship rel = relationship2;
        PatternElement[] patternElementArray = new PatternElement[]{rel};
        StatementBuilder.OngoingReadingWithoutWhere ongoingReadingWithoutWhere = Cypher.match((PatternElement[])patternElementArray);
        patternElementArray = new Named[]{rel};
        Statement statement = ongoingReadingWithoutWhere.delete((Named[])patternElementArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"build(...)");
        Statement stmt = statement;
        return new Query(this.renderer.render(stmt), stmt.getParameters());
    }

    private final Node buildNode(String elementId, String named) {
        Object[] objectArray = new Object[]{this.propertyName, Cypher.parameter((String)(named + "ElementId"), (Object)elementId)};
        Node node = ((Node)Cypher.node((String)this.labelName, (String[])new String[0]).withProperties(objectArray)).named(named);
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"named(...)");
        Node node2 = node;
        return node2;
    }

    private final Triple<Node, Node, Relationship> buildRelationship(RelationshipEvent event, String named) {
        String string = event.getStart().getElementId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementId(...)");
        Node start = this.buildNode(string, "start");
        String string2 = event.getEnd().getElementId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getElementId(...)");
        Node end = this.buildNode(string2, "end");
        Object[] objectArray = new String[]{event.getType()};
        Relationship relationship = (Relationship)start.relationshipTo(end, (String[])objectArray);
        objectArray = new Object[]{this.propertyName, Cypher.parameter((String)(named + "ElementId"), (Object)event.getElementId())};
        Relationship relationship2 = ((Relationship)relationship.withProperties(objectArray)).named(named);
        Intrinsics.checkNotNullExpressionValue((Object)relationship2, (String)"named(...)");
        Relationship rel = relationship2;
        return new Triple((Object)start, (Object)end, (Object)rel);
    }
}

