/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.kafka.connect.errors.ConnectException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.connectors.kafka.sink.ChangeQuery;
import org.neo4j.connectors.kafka.sink.SinkMessage;
import org.neo4j.connectors.kafka.sink.SinkStrategy;
import org.neo4j.connectors.kafka.sink.SinkStrategyHandler;
import org.neo4j.connectors.kafka.sink.strategy.cud.Operation;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/CudHandler;", "Lorg/neo4j/connectors/kafka/sink/SinkStrategyHandler;", "topic", "", "renderer", "Lorg/neo4j/cypherdsl/core/renderer/Renderer;", "batchSize", "", "<init>", "(Ljava/lang/String;Lorg/neo4j/cypherdsl/core/renderer/Renderer;I)V", "getTopic", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "strategy", "Lorg/neo4j/connectors/kafka/sink/SinkStrategy;", "handle", "", "Lorg/neo4j/connectors/kafka/sink/ChangeQuery;", "messages", "Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "MessageToQuery", "sink"})
@SourceDebugExtension(value={"SMAP\nCudHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CudHandler.kt\norg/neo4j/connectors/kafka/sink/strategy/CudHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1586#2:60\n1661#2,3:61\n*S KotlinDebug\n*F\n+ 1 CudHandler.kt\norg/neo4j/connectors/kafka/sink/strategy/CudHandler\n*L\n54#1:60\n54#1:61,3\n*E\n"})
public final class CudHandler
implements SinkStrategyHandler {
    @NotNull
    private final String topic;
    @NotNull
    private final Renderer renderer;
    private final int batchSize;
    @NotNull
    private final Logger logger;

    public CudHandler(@NotNull String topic, @NotNull Renderer renderer, int batchSize) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        this.topic = topic;
        this.renderer = renderer;
        this.batchSize = batchSize;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public final String getTopic() {
        return this.topic;
    }

    @Override
    @NotNull
    public SinkStrategy strategy() {
        return SinkStrategy.CUD;
    }

    @Override
    @NotNull
    public Iterable<Iterable<ChangeQuery>> handle(@NotNull Iterable<SinkMessage> messages) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        return SequencesKt.toList((Sequence)SequencesKt.onEach((Sequence)SequencesKt.map((Sequence)SequencesKt.chunked((Sequence)SequencesKt.map((Sequence)SequencesKt.onEach((Sequence)CollectionsKt.asSequence(messages), arg_0 -> CudHandler.handle$lambda$0(this, arg_0)), arg_0 -> CudHandler.handle$lambda$1(this, arg_0)), (int)this.batchSize), CudHandler::handle$lambda$2), arg_0 -> CudHandler.handle$lambda$3(this, arg_0)));
    }

    private static final Unit handle$lambda$0(CudHandler this$0, SinkMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.logger.trace("received message: '{}'", (Object)it);
        return Unit.INSTANCE;
    }

    private static final MessageToQuery handle$lambda$1(CudHandler this$0, SinkMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object value = it.valueFromConnectValue();
        if (!(value instanceof Map)) {
            throw new ConnectException("Message value must be convertible to a Map.");
        }
        Map value2 = (Map)value;
        Operation cud = Operation.Companion.from(value2);
        return new MessageToQuery(it, cud.toQuery(this$0.renderer));
    }

    /*
     * WARNING - void declaration
     */
    private static final List handle$lambda$2(List it) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$map$iv = it;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void data;
            MessageToQuery messageToQuery = (MessageToQuery)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ChangeQuery(null, null, CollectionsKt.listOf((Object)data.getMessage()), data.getQuery()));
        }
        return (List)destination$iv$iv;
    }

    private static final Unit handle$lambda$3(CudHandler this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.logger.trace("mapped messages: '{}'", (Object)it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/CudHandler$MessageToQuery;", "", "message", "Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "query", "Lorg/neo4j/driver/Query;", "<init>", "(Lorg/neo4j/connectors/kafka/sink/SinkMessage;Lorg/neo4j/driver/Query;)V", "getMessage", "()Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "getQuery", "()Lorg/neo4j/driver/Query;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "sink"})
    public static final class MessageToQuery {
        @NotNull
        private final SinkMessage message;
        @NotNull
        private final Query query;

        public MessageToQuery(@NotNull SinkMessage message, @NotNull Query query) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            this.message = message;
            this.query = query;
        }

        @NotNull
        public final SinkMessage getMessage() {
            return this.message;
        }

        @NotNull
        public final Query getQuery() {
            return this.query;
        }

        @NotNull
        public final SinkMessage component1() {
            return this.message;
        }

        @NotNull
        public final Query component2() {
            return this.query;
        }

        @NotNull
        public final MessageToQuery copy(@NotNull SinkMessage message, @NotNull Query query) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            return new MessageToQuery(message, query);
        }

        public static /* synthetic */ MessageToQuery copy$default(MessageToQuery messageToQuery, SinkMessage sinkMessage, Query query, int n, Object object) {
            if ((n & 1) != 0) {
                sinkMessage = messageToQuery.message;
            }
            if ((n & 2) != 0) {
                query = messageToQuery.query;
            }
            return messageToQuery.copy(sinkMessage, query);
        }

        @NotNull
        public String toString() {
            return "MessageToQuery(message=" + this.message + ", query=" + this.query + ")";
        }

        public int hashCode() {
            int result = this.message.hashCode();
            result = result * 31 + this.query.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MessageToQuery)) {
                return false;
            }
            MessageToQuery messageToQuery = (MessageToQuery)other;
            if (!Intrinsics.areEqual((Object)this.message, (Object)messageToQuery.message)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.query, (Object)messageToQuery.query);
        }
    }
}

