/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy;

import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.connectors.kafka.sink.ChangeQuery;
import org.neo4j.connectors.kafka.sink.SinkMessage;
import org.neo4j.connectors.kafka.sink.SinkStrategy;
import org.neo4j.connectors.kafka.sink.SinkStrategyHandler;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.ExposesSubqueryCall;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001 BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\"\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/CypherHandler;", "Lorg/neo4j/connectors/kafka/sink/SinkStrategyHandler;", "topic", "", "query", "renderer", "Lorg/neo4j/cypherdsl/core/renderer/Renderer;", "batchSize", "", "bindTimestampAs", "bindHeaderAs", "bindKeyAs", "bindValueAs", "bindValueAsEvent", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/neo4j/cypherdsl/core/renderer/Renderer;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getTopic", "()Ljava/lang/String;", "getQuery", "getBatchSize", "()I", "logger", "Lorg/slf4j/Logger;", "rewrittenQuery", "strategy", "Lorg/neo4j/connectors/kafka/sink/SinkStrategy;", "handle", "", "Lorg/neo4j/connectors/kafka/sink/ChangeQuery;", "messages", "Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "MessageToEventMap", "sink"})
@SourceDebugExtension(value={"SMAP\nCypherHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CypherHandler.kt\norg/neo4j/connectors/kafka/sink/strategy/CypherHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1586#2:124\n1661#2,3:125\n1586#2:128\n1661#2,3:129\n*S KotlinDebug\n*F\n+ 1 CypherHandler.kt\norg/neo4j/connectors/kafka/sink/strategy/CypherHandler\n*L\n114#1:124\n114#1:125,3\n115#1:128\n115#1:129,3\n*E\n"})
public final class CypherHandler
implements SinkStrategyHandler {
    @NotNull
    private final String topic;
    @NotNull
    private final String query;
    private final int batchSize;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String rewrittenQuery;

    /*
     * WARNING - void declaration
     */
    public CypherHandler(@NotNull String topic, @NotNull String query, @NotNull Renderer renderer, int batchSize, @NotNull String bindTimestampAs, @NotNull String bindHeaderAs, @NotNull String bindKeyAs, @NotNull String bindValueAs, boolean bindValueAsEvent) {
        void $this$_init__u24lambda_u240;
        String[] stringArray;
        Expression[] expressionArray;
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)bindTimestampAs, (String)"bindTimestampAs");
        Intrinsics.checkNotNullParameter((Object)bindHeaderAs, (String)"bindHeaderAs");
        Intrinsics.checkNotNullParameter((Object)bindKeyAs, (String)"bindKeyAs");
        Intrinsics.checkNotNullParameter((Object)bindValueAs, (String)"bindValueAs");
        this.topic = topic;
        this.query = query;
        this.batchSize = batchSize;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        SymbolicName symbolicName = Cypher.name((String)"message");
        Intrinsics.checkNotNullExpressionValue((Object)symbolicName, (String)"name(...)");
        SymbolicName message = symbolicName;
        Expression[] expressionArray2 = expressionArray = CollectionsKt.createListBuilder();
        StatementBuilder.OngoingReading ongoingReading = Cypher.unwind((Expression)((Expression)Cypher.parameter((String)"events"))).as(message);
        Renderer renderer2 = renderer;
        CypherHandler cypherHandler = this;
        boolean bl = false;
        if (bindValueAsEvent) {
            stringArray = new String[]{"value"};
            $this$_init__u24lambda_u240.add(message.property(stringArray).as("event"));
        }
        if (((CharSequence)bindTimestampAs).length() > 0) {
            stringArray = new String[]{"timestamp"};
            $this$_init__u24lambda_u240.add(message.property(stringArray).as(bindTimestampAs));
        }
        if (((CharSequence)bindHeaderAs).length() > 0) {
            stringArray = new String[]{"header"};
            $this$_init__u24lambda_u240.add(message.property(stringArray).as(bindHeaderAs));
        }
        if (((CharSequence)bindKeyAs).length() > 0) {
            stringArray = new String[]{"key"};
            $this$_init__u24lambda_u240.add(message.property(stringArray).as(bindKeyAs));
        }
        if (((CharSequence)bindValueAs).length() > 0) {
            stringArray = new String[]{"value"};
            $this$_init__u24lambda_u240.add(message.property(stringArray).as(bindValueAs));
        }
        if ($this$_init__u24lambda_u240.isEmpty()) {
            throw new IllegalArgumentException("no effective accessors specified for binding the message into cypher template for topic '" + this.topic + "'");
        }
        Unit unit = Unit.INSTANCE;
        ExposesSubqueryCall.BuildableSubquery buildableSubquery = ongoingReading.with((Collection)CollectionsKt.build((List)expressionArray)).callRawCypher("WITH * " + this.query, new Object[0]);
        expressionArray = new Expression[]{Cypher.literalNull()};
        String string = renderer2.render(buildableSubquery.returning(expressionArray).build());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"render(...)");
        cypherHandler.rewrittenQuery = string;
        this.logger.debug("using cypher query '{}' for topic '{}'", (Object)this.rewrittenQuery, (Object)this.topic);
    }

    public /* synthetic */ CypherHandler(String string, String string2, Renderer renderer, int n, String string3, String string4, String string5, String string6, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            string3 = "__timestamp";
        }
        if ((n2 & 0x20) != 0) {
            string4 = "__header";
        }
        if ((n2 & 0x40) != 0) {
            string5 = "__key";
        }
        if ((n2 & 0x80) != 0) {
            string6 = "__value";
        }
        if ((n2 & 0x100) != 0) {
            bl = true;
        }
        this(string, string2, renderer, n, string3, string4, string5, string6, bl);
    }

    @NotNull
    public final String getTopic() {
        return this.topic;
    }

    @NotNull
    public final String getQuery() {
        return this.query;
    }

    public final int getBatchSize() {
        return this.batchSize;
    }

    @Override
    @NotNull
    public SinkStrategy strategy() {
        return SinkStrategy.CYPHER;
    }

    @Override
    @NotNull
    public Iterable<Iterable<ChangeQuery>> handle(@NotNull Iterable<SinkMessage> messages) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        return SequencesKt.toList((Sequence)SequencesKt.onEach((Sequence)SequencesKt.map((Sequence)SequencesKt.chunked((Sequence)SequencesKt.map((Sequence)SequencesKt.onEach((Sequence)CollectionsKt.asSequence(messages), arg_0 -> CypherHandler.handle$lambda$0(this, arg_0)), arg_0 -> CypherHandler.handle$lambda$1(this, arg_0)), (int)this.batchSize), arg_0 -> CypherHandler.handle$lambda$2(this, arg_0)), arg_0 -> CypherHandler.handle$lambda$3(this, arg_0)));
    }

    private static final Unit handle$lambda$0(CypherHandler this$0, SinkMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.logger.trace("received message: '{}'", (Object)it);
        return Unit.INSTANCE;
    }

    private static final MessageToEventMap handle$lambda$1(CypherHandler this$0, SinkMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Pair[] pairArray = new Pair[4];
        Long l = it.getRecord().timestamp();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"timestamp(...)");
        pairArray[0] = TuplesKt.to((Object)"timestamp", (Object)Instant.ofEpochMilli(((Number)l).longValue()).atOffset(ZoneOffset.UTC));
        pairArray[1] = TuplesKt.to((Object)"header", it.headerFromConnectValue());
        pairArray[2] = TuplesKt.to((Object)"key", (Object)it.keyFromConnectValue());
        pairArray[3] = TuplesKt.to((Object)"value", (Object)it.valueFromConnectValue());
        Map mapped = MapsKt.mapOf((Pair[])pairArray);
        this$0.logger.trace("message '{}' mapped to: '{}'", (Object)it, (Object)mapped);
        return new MessageToEventMap(it, mapped);
    }

    private static final List handle$lambda$2(CypherHandler this$0, List it) {
        Collection<Map<String, Object>> collection;
        MessageToEventMap data;
        Iterable iterable;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable iterable2 = it;
        Integer n = null;
        Long l = null;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MessageToEventMap messageToEventMap = (MessageToEventMap)item$iv$iv;
            iterable = destination$iv$iv;
            boolean bl = false;
            iterable.add(data.getMessage());
        }
        iterable = (List)destination$iv$iv;
        $this$map$iv = it;
        String string = "events";
        String string2 = this$0.rewrittenQuery;
        iterable = iterable;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            data = (MessageToEventMap)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(data.getEventMap());
        }
        collection = (List)destination$iv$iv;
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)collection));
        String string3 = string2;
        Query query = new Query(string3, map);
        Iterable iterable3 = iterable;
        Integer n2 = n;
        Long l2 = l;
        return CollectionsKt.listOf((Object)new ChangeQuery(l2, n2, iterable3, query));
    }

    private static final Unit handle$lambda$3(CypherHandler this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.logger.trace("mapped messages: '{}'", (Object)it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0017\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005H\u00c6\u0003J+\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0006H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/CypherHandler$MessageToEventMap;", "", "message", "Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "eventMap", "", "", "<init>", "(Lorg/neo4j/connectors/kafka/sink/SinkMessage;Ljava/util/Map;)V", "getMessage", "()Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "getEventMap", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "sink"})
    public static final class MessageToEventMap {
        @NotNull
        private final SinkMessage message;
        @NotNull
        private final Map<String, Object> eventMap;

        public MessageToEventMap(@NotNull SinkMessage message, @NotNull Map<String, ? extends Object> eventMap) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter(eventMap, (String)"eventMap");
            this.message = message;
            this.eventMap = eventMap;
        }

        @NotNull
        public final SinkMessage getMessage() {
            return this.message;
        }

        @NotNull
        public final Map<String, Object> getEventMap() {
            return this.eventMap;
        }

        @NotNull
        public final SinkMessage component1() {
            return this.message;
        }

        @NotNull
        public final Map<String, Object> component2() {
            return this.eventMap;
        }

        @NotNull
        public final MessageToEventMap copy(@NotNull SinkMessage message, @NotNull Map<String, ? extends Object> eventMap) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter(eventMap, (String)"eventMap");
            return new MessageToEventMap(message, eventMap);
        }

        public static /* synthetic */ MessageToEventMap copy$default(MessageToEventMap messageToEventMap, SinkMessage sinkMessage, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                sinkMessage = messageToEventMap.message;
            }
            if ((n & 2) != 0) {
                map = messageToEventMap.eventMap;
            }
            return messageToEventMap.copy(sinkMessage, map);
        }

        @NotNull
        public String toString() {
            return "MessageToEventMap(message=" + this.message + ", eventMap=" + this.eventMap + ")";
        }

        public int hashCode() {
            int result = this.message.hashCode();
            result = result * 31 + ((Object)this.eventMap).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MessageToEventMap)) {
                return false;
            }
            MessageToEventMap messageToEventMap = (MessageToEventMap)other;
            if (!Intrinsics.areEqual((Object)this.message, (Object)messageToEventMap.message)) {
                return false;
            }
            return Intrinsics.areEqual(this.eventMap, messageToEventMap.eventMap);
        }
    }
}

