/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy;

import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.kafka.connect.errors.ConnectException;
import org.jetbrains.annotations.NotNull;
import org.neo4j.connectors.kafka.data.ConstraintData;
import org.neo4j.connectors.kafka.exceptions.InvalidDataException;
import org.neo4j.connectors.kafka.sink.SinkMessage;
import org.neo4j.connectors.kafka.sink.SinkStrategyHandler;
import org.neo4j.connectors.kafka.sink.strategy.pattern.Pattern;
import org.neo4j.connectors.kafka.sink.strategy.pattern.PropertyMapping;
import org.neo4j.connectors.kafka.utils.MapUtils;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.SymbolicName;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\b&\u0018\u0000 -*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001-B7\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH&J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006H\u0002Jc\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00152\u0006\u0010\u0004\u001a\u00020\u00022\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00152\u0006\u0010#\u001a\u00020\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060%2\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060'\"\u00020\u0006H\u0004\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0006H\u0002JB\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00152\u0006\u0010\u0004\u001a\u00020\u00022\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00152\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00060%H\u0004R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\b\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\t\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006."}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/PatternHandler;", "T", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/Pattern;", "Lorg/neo4j/connectors/kafka/sink/SinkStrategyHandler;", "pattern", "bindTimestampAs", "", "bindHeaderAs", "bindKeyAs", "bindValueAs", "<init>", "(Lorg/neo4j/connectors/kafka/sink/strategy/pattern/Pattern;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getPattern", "()Lorg/neo4j/connectors/kafka/sink/strategy/pattern/Pattern;", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/Pattern;", "getBindTimestampAs", "()Ljava/lang/String;", "getBindHeaderAs", "getBindKeyAs", "getBindValueAs", "flattenMessage", "", "", "message", "Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "validate", "", "constraints", "", "Lorg/neo4j/connectors/kafka/data/ConstraintData;", "isExplicit", "", "from", "extractKeys", "flattened", "isTombstone", "usedTracker", "", "prefixes", "", "(Lorg/neo4j/connectors/kafka/sink/strategy/pattern/Pattern;Ljava/util/Map;ZLjava/util/Set;[Ljava/lang/String;)Ljava/util/Map;", "replaceValueWithKey", "mapping", "computeProperties", "used", "Companion", "sink"})
@SourceDebugExtension(value={"SMAP\nPatternHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatternHandler.kt\norg/neo4j/connectors/kafka/sink/strategy/PatternHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,188:1\n1220#2,2:189\n1249#2,4:191\n1266#2,4:197\n1266#2,4:217\n1915#2:221\n1266#2,4:231\n1916#2:235\n1915#2:236\n777#2:237\n873#2,2:238\n1915#2,2:240\n1916#2:242\n466#3:195\n415#3:196\n491#3,7:201\n491#3,7:208\n481#3:215\n427#3:216\n491#3,7:222\n481#3:229\n427#3:230\n*S KotlinDebug\n*F\n+ 1 PatternHandler.kt\norg/neo4j/connectors/kafka/sink/strategy/PatternHandler\n*L\n100#1:189,2\n100#1:191,4\n101#1:197,4\n157#1:217,4\n161#1:221\n170#1:231,4\n161#1:235\n178#1:236\n182#1:237\n182#1:238,2\n182#1:240,2\n178#1:242\n101#1:195\n101#1:196\n155#1:201,7\n156#1:208,7\n157#1:215\n157#1:216\n169#1:222,7\n170#1:229\n170#1:230\n*E\n"})
public abstract class PatternHandler<T extends Pattern>
implements SinkStrategyHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final T pattern;
    @NotNull
    private final String bindTimestampAs;
    @NotNull
    private final String bindHeaderAs;
    @NotNull
    private final String bindKeyAs;
    @NotNull
    private final String bindValueAs;
    @NotNull
    public static final String CREATE = "C";
    @NotNull
    public static final String DELETE = "D";
    @NotNull
    public static final String EVENTS = "events";
    @NotNull
    public static final String KEYS = "keys";
    @NotNull
    public static final String PROPERTIES = "properties";
    @NotNull
    public static final String START = "start";
    @NotNull
    public static final String END = "end";
    @NotNull
    private static final SymbolicName NAME_EVENT;
    @NotNull
    private static final SymbolicName NAME_CREATED;
    @NotNull
    private static final SymbolicName NAME_DELETED;

    public PatternHandler(@NotNull T pattern, @NotNull String bindTimestampAs, @NotNull String bindHeaderAs, @NotNull String bindKeyAs, @NotNull String bindValueAs) {
        Intrinsics.checkNotNullParameter(pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)bindTimestampAs, (String)"bindTimestampAs");
        Intrinsics.checkNotNullParameter((Object)bindHeaderAs, (String)"bindHeaderAs");
        Intrinsics.checkNotNullParameter((Object)bindKeyAs, (String)"bindKeyAs");
        Intrinsics.checkNotNullParameter((Object)bindValueAs, (String)"bindValueAs");
        this.pattern = pattern;
        this.bindTimestampAs = bindTimestampAs;
        this.bindHeaderAs = bindHeaderAs;
        this.bindKeyAs = bindKeyAs;
        this.bindValueAs = bindValueAs;
    }

    public /* synthetic */ PatternHandler(Pattern pattern, String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "__timestamp";
        }
        if ((n & 4) != 0) {
            string2 = "__header";
        }
        if ((n & 8) != 0) {
            string3 = "__key";
        }
        if ((n & 0x10) != 0) {
            string4 = "__value";
        }
        this(pattern, string, string2, string3, string4);
    }

    @NotNull
    public final T getPattern() {
        return this.pattern;
    }

    @NotNull
    protected final String getBindTimestampAs() {
        return this.bindTimestampAs;
    }

    @NotNull
    protected final String getBindHeaderAs() {
        return this.bindHeaderAs;
    }

    @NotNull
    protected final String getBindKeyAs() {
        return this.bindKeyAs;
    }

    @NotNull
    protected final String getBindValueAs() {
        return this.bindValueAs;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Map<String, Object> flattenMessage(@NotNull SinkMessage message) {
        void $this$flattenMessage_u24lambda_u240;
        Map map;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Map map2 = map = MapsKt.createMapBuilder();
        MapUtils mapUtils = MapUtils.INSTANCE;
        boolean bl = false;
        Pair[] pairArray = new Pair[3];
        Long l = message.getRecord().timestamp();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"timestamp(...)");
        pairArray[0] = TuplesKt.to((Object)this.bindTimestampAs, (Object)Instant.ofEpochMilli(((Number)l).longValue()).atOffset(ZoneOffset.UTC));
        pairArray[1] = TuplesKt.to((Object)this.bindHeaderAs, message.headerFromConnectValue());
        pairArray[2] = TuplesKt.to((Object)this.bindKeyAs, (Object)message.keyFromConnectValue());
        $this$flattenMessage_u24lambda_u240.putAll(MapsKt.mapOf((Pair[])pairArray));
        if (message.getValue() != null) {
            pairArray = $this$flattenMessage_u24lambda_u240;
            String string = this.bindValueAs;
            Object value = message.valueFromConnectValue();
            if (!(value instanceof Map)) {
                throw new ConnectException("Message value must be convertible to a Map.");
            }
            Map map3 = (Map)value;
            pairArray.put(string, map3);
        }
        return MapUtils.flatten$default((MapUtils)mapUtils, (Map)MapsKt.build((Map)map), null, null, (int)3, null);
    }

    public abstract void validate(@NotNull List<ConstraintData> var1);

    private final boolean isExplicit(String from) {
        return StringsKt.startsWith$default((String)from, (String)(this.bindValueAs + "."), (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)from, (String)(this.bindKeyAs + "."), (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)from, (String)(this.bindHeaderAs + "."), (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)from, (Object)this.bindTimestampAs);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    protected final Map<String, Object> extractKeys(@NotNull Pattern pattern, @NotNull Map<String, ? extends Object> flattened, boolean isTombstone, @NotNull Set<String> usedTracker, String ... prefixes) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map map;
        Object object;
        void $this$associateByTo$iv$iv;
        Map $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(flattened, (String)"flattened");
        Intrinsics.checkNotNullParameter(usedTracker, (String)"usedTracker");
        Intrinsics.checkNotNullParameter((Object)prefixes, (String)"prefixes");
        Iterable iterable = pattern.getKeyProperties();
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateBy$iv), (int)10)), (int)16);
        void var9_10 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo22 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            object = (PropertyMapping)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getTo(), element$iv$iv);
        }
        $this$associateBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        void capacity$iv22 = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $i$f$associateByTo22 = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv2;
        boolean $i$f$associateByTo = false;
        object = $this$associateByTo$iv$iv$iv.iterator();
        while (true) {
            Object object2;
            Object k;
            block10: {
                void it$iv$iv;
                if (!object.hasNext()) {
                    return destination$iv$iv$iv;
                }
                Object element$iv$iv$iv = object.next();
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map = map2;
                boolean bl2 = false;
                PropertyMapping mapping = (PropertyMapping)entry2.getValue();
                if (this.isExplicit(mapping.getFrom())) {
                    String newKey;
                    String string = newKey = isTombstone ? this.replaceValueWithKey(mapping.getFrom()) : mapping.getFrom();
                    if (flattened.containsKey(newKey)) {
                        ((Collection)usedTracker).add(newKey);
                        object2 = flattened.get(newKey);
                        break block10;
                    } else {
                        if (StringsKt.startsWith$default((String)mapping.getFrom(), (String)(this.bindKeyAs + "."), (boolean)false, (int)2, null)) {
                            throw new InvalidDataException("Key '" + StringsKt.replace$default((String)mapping.getFrom(), (String)(this.bindKeyAs + "."), (String)"", (boolean)false, (int)4, null) + "' could not be located in the keys.");
                        }
                        throw new InvalidDataException("Key '" + StringsKt.replace$default((String)mapping.getFrom(), (String)(this.bindValueAs + "."), (String)"", (boolean)false, (int)4, null) + "' could not be located in the values.");
                    }
                }
                int n = 0;
                int n2 = prefixes.length;
                while (true) {
                    if (n >= n2) {
                        throw new InvalidDataException("Key '" + mapping.getFrom() + "' could not be located in the message.");
                    }
                    String prefix = prefixes[n];
                    String key = prefix + "." + mapping.getFrom();
                    if (flattened.containsKey(key)) {
                        ((Collection)usedTracker).add(key);
                        object2 = flattened.get(key);
                        break;
                    }
                    ++n;
                }
            }
            Object object3 = object2;
            map.put(k, object3);
        }
    }

    private final String replaceValueWithKey(String mapping) {
        if (!StringsKt.startsWith$default((String)mapping, (String)(this.bindValueAs + "."), (boolean)false, (int)2, null)) {
            return mapping;
        }
        return StringsKt.replace$default((String)mapping, (String)(this.bindValueAs + "."), (String)(this.bindKeyAs + "."), (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Map<String, Object> computeProperties(@NotNull Pattern pattern, @NotNull Map<String, ? extends Object> flattened, @NotNull Set<String> used) {
        Object it;
        Iterator iterator;
        Map map;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(flattened, (String)"flattened");
        Intrinsics.checkNotNullParameter(used, (String)"used");
        Map $this$computeProperties_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        if (pattern.getIncludeAllValueProperties()) {
            void $this$associateByTo$iv$iv$iv;
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            Object it2;
            Map $this$filterKeys$iv;
            Map<String, ? extends Object> map2 = flattened;
            Map map3 = $this$computeProperties_u24lambda_u240;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                it2 = (String)entry$iv.getKey();
                boolean bl2 = false;
                if (!(!used.contains(it2))) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterKeys$iv = result$iv;
            $i$f$filterKeys = false;
            result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                it2 = (String)entry$iv.getKey();
                boolean bl3 = false;
                if (!StringsKt.startsWith$default((String)it2, (String)this.bindValueAs, (boolean)false, (int)2, null)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterKeys$iv = result$iv;
            boolean $i$f$mapKeys = false;
            result$iv = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            it2 = $this$mapKeysTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                String string;
                void it$iv$iv;
                void it3;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map4 = destination$iv$iv$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)((String)it3.getKey()).substring(this.bindValueAs.length() + 1), (String)"substring(...)");
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map5 = map4;
                boolean bl5 = false;
                Iterator<Object> iterator2 = it$iv$iv.getValue();
                map5.put(string, iterator2);
            }
            map3.putAll(destination$iv$iv$iv);
        }
        Iterable $this$forEach$iv = pattern.getIncludeProperties();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$associateByTo$iv$iv$iv;
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            Map $this$filterKeys$iv;
            String key;
            PropertyMapping mapping = (PropertyMapping)element$iv;
            boolean bl6 = false;
            String string = key = this.isExplicit(mapping.getFrom()) ? mapping.getFrom() : this.bindValueAs + "." + mapping.getFrom();
            if (flattened.containsKey(key)) {
                ((Collection)used).add(key);
                $this$computeProperties_u24lambda_u240.put(mapping.getTo(), flattened.get(key));
                continue;
            }
            Map<String, ? extends Object> $i$f$associateByTo = flattened;
            iterator = $this$computeProperties_u24lambda_u240;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                it = (String)entry$iv.getKey();
                boolean bl7 = false;
                if (!StringsKt.startsWith$default((String)it, (String)key, (boolean)false, (int)2, null)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterKeys$iv = result$iv;
            boolean $i$f$mapKeys = false;
            result$iv = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            it = $this$mapKeysTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv;
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it4;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map6 = destination$iv$iv$iv;
                boolean bl8 = false;
                ((Collection)used).add(it4.getKey());
                String string2 = mapping.getTo();
                String string3 = ((String)it4.getKey()).substring(key.length());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                String string4 = string2 + string3;
                Map map7 = map6;
                boolean bl9 = false;
                Object v = it$iv$iv.getValue();
                map7.put(string4, v);
            }
            iterator.putAll(destination$iv$iv$iv);
        }
        $this$forEach$iv = pattern.getExcludeProperties();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv;
            String exclude = (String)element$iv;
            boolean bl10 = false;
            if ($this$computeProperties_u24lambda_u240.containsKey(exclude)) {
                $this$computeProperties_u24lambda_u240.remove(exclude);
                continue;
            }
            Iterable $this$filter$iv = $this$computeProperties_u24lambda_u240.keySet();
            boolean $i$f$filter = false;
            iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl11 = false;
                if (!StringsKt.startsWith$default((String)it, (String)(exclude + "."), (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it5 = (String)element$iv2;
                boolean bl12 = false;
                $this$computeProperties_u24lambda_u240.remove(it5);
            }
        }
        return MapsKt.build((Map)map);
    }

    static {
        SymbolicName symbolicName = Cypher.name((String)"event");
        Intrinsics.checkNotNullExpressionValue((Object)symbolicName, (String)"name(...)");
        NAME_EVENT = symbolicName;
        SymbolicName symbolicName2 = Cypher.name((String)"created");
        Intrinsics.checkNotNullExpressionValue((Object)symbolicName2, (String)"name(...)");
        NAME_CREATED = symbolicName2;
        SymbolicName symbolicName3 = Cypher.name((String)"deleted");
        Intrinsics.checkNotNullExpressionValue((Object)symbolicName3, (String)"name(...)");
        NAME_DELETED = symbolicName3;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0019\u0010\u0013\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/PatternHandler$Companion;", "", "<init>", "()V", "CREATE", "", "DELETE", "EVENTS", "KEYS", "PROPERTIES", "START", "END", "NAME_EVENT", "Lorg/neo4j/cypherdsl/core/SymbolicName;", "Lorg/jetbrains/annotations/NotNull;", "getNAME_EVENT$sink", "()Lorg/neo4j/cypherdsl/core/SymbolicName;", "NAME_CREATED", "getNAME_CREATED$sink", "NAME_DELETED", "getNAME_DELETED$sink", "sink"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SymbolicName getNAME_EVENT$sink() {
            return NAME_EVENT;
        }

        @NotNull
        public final SymbolicName getNAME_CREATED$sink() {
            return NAME_CREATED;
        }

        @NotNull
        public final SymbolicName getNAME_DELETED$sink() {
            return NAME_DELETED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

