/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy.cdc.apoc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.neo4j.caniuse.Neo4j;
import org.neo4j.cdc.client.model.EntityEvent;
import org.neo4j.cdc.client.model.EntityOperation;
import org.neo4j.cdc.client.model.NodeEvent;
import org.neo4j.cdc.client.model.NodeState;
import org.neo4j.cdc.client.model.RelationshipEvent;
import org.neo4j.cdc.client.model.RelationshipState;
import org.neo4j.connectors.kafka.exceptions.InvalidDataException;
import org.neo4j.connectors.kafka.sink.SinkStrategy;
import org.neo4j.connectors.kafka.sink.strategy.EventExtensionsKt;
import org.neo4j.connectors.kafka.sink.strategy.cdc.apoc.ApocCdcHandler;
import org.neo4j.connectors.kafka.sink.strategy.cdc.apoc.CdcNodeData;
import org.neo4j.connectors.kafka.sink.strategy.cdc.apoc.CdcRelationshipData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0017H\u0014J\u0010\u0010\u0014\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0017H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0017H\u0014JV\u0010\u0018\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001c0\u001b0\u00192$\u0010\u001d\u001a \u0012\u0004\u0012\u00020\u0003\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001c0\u001b0\u001e0\u001b2\b\b\u0002\u0010\u001f\u001a\u00020 H\u0002JX\u0010\u0018\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001c0\u001b0\u00192\u0006\u0010!\u001a\u00020\u00032\u0018\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001c0\u001b0\u001e2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/cdc/apoc/ApocCdcSchemaHandler;", "Lorg/neo4j/connectors/kafka/sink/strategy/cdc/apoc/ApocCdcHandler;", "topic", "", "neo4j", "Lorg/neo4j/caniuse/Neo4j;", "batchSize", "", "<init>", "(Ljava/lang/String;Lorg/neo4j/caniuse/Neo4j;I)V", "getTopic", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "strategy", "Lorg/neo4j/connectors/kafka/sink/SinkStrategy;", "transformCreate", "Lorg/neo4j/connectors/kafka/sink/strategy/cdc/apoc/CdcNodeData;", "event", "Lorg/neo4j/cdc/client/model/NodeEvent;", "transformUpdate", "transformDelete", "Lorg/neo4j/connectors/kafka/sink/strategy/cdc/apoc/CdcRelationshipData;", "Lorg/neo4j/cdc/client/model/RelationshipEvent;", "buildMatchLabelsAndProperties", "Lkotlin/Pair;", "", "", "", "keys", "", "forceKeys", "", "type", "properties", "sink"})
@SourceDebugExtension(value={"SMAP\nApocCdcSchemaHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApocCdcSchemaHandler.kt\norg/neo4j/connectors/kafka/sink/strategy/cdc/apoc/ApocCdcSchemaHandler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,229:1\n466#2:230\n415#2:231\n507#2,7:238\n1266#3,2:232\n777#3:234\n873#3,2:235\n1269#3:237\n78#4:245\n99#4,5:246\n672#5:251\n756#5,4:252\n672#5:256\n756#5,4:257\n*S KotlinDebug\n*F\n+ 1 ApocCdcSchemaHandler.kt\norg/neo4j/connectors/kafka/sink/strategy/cdc/apoc/ApocCdcSchemaHandler\n*L\n195#1:230\n195#1:231\n196#1:238,7\n195#1:232,2\n195#1:234\n195#1:235,2\n195#1:237\n207#1:245\n207#1:246,5\n210#1:251\n210#1:252,4\n224#1:256\n224#1:257,4\n*E\n"})
public final class ApocCdcSchemaHandler
extends ApocCdcHandler {
    @NotNull
    private final String topic;
    @NotNull
    private final Logger logger;

    public ApocCdcSchemaHandler(@NotNull String topic, @NotNull Neo4j neo4j, int batchSize) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)neo4j, (String)"neo4j");
        super(neo4j, batchSize);
        this.topic = topic;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.logger.info("using APOC compatible CDC SCHEMA strategy for topic '{}'", (Object)this.topic);
    }

    @NotNull
    public final String getTopic() {
        return this.topic;
    }

    @Override
    @NotNull
    public SinkStrategy strategy() {
        return SinkStrategy.CDC_SCHEMA;
    }

    @Override
    @NotNull
    protected CdcNodeData transformCreate(@NotNull NodeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getBefore() != null) {
            throw new InvalidDataException("create operation requires 'before' field to be unset in the event object");
        }
        if (event.getAfter() == null) {
            throw new InvalidDataException("create operation requires 'after' field in the event object");
        }
        Map map = event.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getKeys(...)");
        Pair pair = ApocCdcSchemaHandler.buildMatchLabelsAndProperties$default(this, map, false, 2, null);
        Set matchLabels = (Set)pair.component1();
        Map matchProperties = (Map)pair.component2();
        Map map2 = ((NodeState)event.getAfter()).getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getProperties(...)");
        List list = ((NodeState)event.getAfter()).getLabels();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLabels(...)");
        return new CdcNodeData(EntityOperation.CREATE, matchLabels, matchProperties, map2, CollectionsKt.toSet((Iterable)CollectionsKt.minus((Iterable)list, (Iterable)matchLabels)), SetsKt.emptySet());
    }

    @Override
    @NotNull
    protected CdcNodeData transformUpdate(@NotNull NodeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getBefore() == null) {
            throw new InvalidDataException("update operation requires 'before' field in the event object");
        }
        if (event.getAfter() == null) {
            throw new InvalidDataException("update operation requires 'after' field in the event object");
        }
        Map map = event.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getKeys(...)");
        Pair pair = ApocCdcSchemaHandler.buildMatchLabelsAndProperties$default(this, map, false, 2, null);
        Set matchLabels = (Set)pair.component1();
        Map matchProperties = (Map)pair.component2();
        return new CdcNodeData(EntityOperation.UPDATE, matchLabels, matchProperties, EventExtensionsKt.mutatedProperties((EntityEvent)event), CollectionsKt.toSet((Iterable)EventExtensionsKt.addedLabels(event)), CollectionsKt.toSet((Iterable)EventExtensionsKt.removedLabels(event)));
    }

    @Override
    @NotNull
    protected CdcNodeData transformDelete(@NotNull NodeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAfter() != null) {
            throw new InvalidDataException("delete operation requires 'after' field to be unset in the event object");
        }
        Map map = event.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getKeys(...)");
        Pair pair = ApocCdcSchemaHandler.buildMatchLabelsAndProperties$default(this, map, false, 2, null);
        Set matchLabels = (Set)pair.component1();
        Map matchProperties = (Map)pair.component2();
        return new CdcNodeData(EntityOperation.DELETE, matchLabels, matchProperties, MapsKt.emptyMap(), SetsKt.emptySet(), SetsKt.emptySet());
    }

    @Override
    @NotNull
    protected CdcRelationshipData transformCreate(@NotNull RelationshipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getBefore() != null) {
            throw new InvalidDataException("create operation requires 'before' field to be unset in the event object");
        }
        if (event.getAfter() == null) {
            throw new InvalidDataException("create operation requires 'after' field in the event object");
        }
        Map map = event.getStart().getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getKeys(...)");
        Pair pair = ApocCdcSchemaHandler.buildMatchLabelsAndProperties$default(this, map, false, 2, null);
        Set startMatchLabels = (Set)pair.component1();
        Map startMatchProperties = (Map)pair.component2();
        Map map2 = event.getEnd().getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getKeys(...)");
        Pair pair2 = ApocCdcSchemaHandler.buildMatchLabelsAndProperties$default(this, map2, false, 2, null);
        Set endMatchLabels = (Set)pair2.component1();
        Map endMatchProperties = (Map)pair2.component2();
        String string = event.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
        List list = event.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getKeys(...)");
        Pair<String, Map<String, Object>> pair3 = this.buildMatchLabelsAndProperties(string, list, ((RelationshipState)event.getAfter()).getProperties());
        String relMatchType = (String)pair3.component1();
        Map relMatchProperties = (Map)pair3.component2();
        List list2 = event.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getKeys(...)");
        boolean bl = !((Collection)list2).isEmpty();
        Map map3 = ((RelationshipState)event.getAfter()).getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getProperties(...)");
        return new CdcRelationshipData(EntityOperation.CREATE, startMatchLabels, startMatchProperties, endMatchLabels, endMatchProperties, relMatchType, relMatchProperties, bl, map3);
    }

    @Override
    @NotNull
    protected CdcRelationshipData transformUpdate(@NotNull RelationshipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getBefore() == null) {
            throw new InvalidDataException("update operation requires 'before' field in the event object");
        }
        if (event.getAfter() == null) {
            throw new InvalidDataException("update operation requires 'after' field in the event object");
        }
        List relationshipKeys = event.getKeys();
        Map map = event.getStart().getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getKeys(...)");
        Pair<Set<String>, Map<String, Object>> pair = this.buildMatchLabelsAndProperties(map, relationshipKeys.isEmpty());
        Set startMatchLabels = (Set)pair.component1();
        Map startMatchProperties = (Map)pair.component2();
        Map map2 = event.getEnd().getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getKeys(...)");
        Pair<Set<String>, Map<String, Object>> pair2 = this.buildMatchLabelsAndProperties(map2, relationshipKeys.isEmpty());
        Set endMatchLabels = (Set)pair2.component1();
        Map endMatchProperties = (Map)pair2.component2();
        String string = event.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
        Intrinsics.checkNotNull((Object)relationshipKeys);
        Pair<String, Map<String, Object>> pair3 = this.buildMatchLabelsAndProperties(string, relationshipKeys, ((RelationshipState)event.getBefore()).getProperties());
        String relMatchType = (String)pair3.component1();
        Map relMatchProperties = (Map)pair3.component2();
        return new CdcRelationshipData(EntityOperation.UPDATE, startMatchLabels, startMatchProperties, endMatchLabels, endMatchProperties, relMatchType, relMatchProperties, !((Collection)relationshipKeys).isEmpty(), EventExtensionsKt.mutatedProperties((EntityEvent)event));
    }

    @Override
    @NotNull
    protected CdcRelationshipData transformDelete(@NotNull RelationshipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAfter() != null) {
            throw new InvalidDataException("delete operation requires 'after' field to be unset in the event object");
        }
        List relationshipKeys = event.getKeys();
        Map map = event.getStart().getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getKeys(...)");
        Pair<Set<String>, Map<String, Object>> pair = this.buildMatchLabelsAndProperties(map, relationshipKeys.isEmpty());
        Set startMatchLabels = (Set)pair.component1();
        Map startMatchProperties = (Map)pair.component2();
        Map map2 = event.getEnd().getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getKeys(...)");
        Pair<Set<String>, Map<String, Object>> pair2 = this.buildMatchLabelsAndProperties(map2, relationshipKeys.isEmpty());
        Set endMatchLabels = (Set)pair2.component1();
        Map endMatchProperties = (Map)pair2.component2();
        String string = event.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
        Intrinsics.checkNotNull((Object)relationshipKeys);
        Pair<String, Map<String, Object>> pair3 = this.buildMatchLabelsAndProperties(string, relationshipKeys, ((RelationshipState)event.getBefore()).getProperties());
        String relMatchType = (String)pair3.component1();
        Map relMatchProperties = (Map)pair3.component2();
        return new CdcRelationshipData(EntityOperation.DELETE, startMatchLabels, startMatchProperties, endMatchLabels, endMatchProperties, relMatchType, relMatchProperties, !((Collection)relationshipKeys).isEmpty(), MapsKt.emptyMap());
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Set<String>, Map<String, Object>> buildMatchLabelsAndProperties(Map<String, ? extends List<? extends Map<String, ? extends Object>>> keys, boolean forceKeys) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$flatMapTo$iv$iv;
        Sequence $this$flatMap$iv;
        Map $this$filterValues$iv;
        Collection collection;
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv;
        Map<String, ? extends List<? extends Map<String, ? extends Object>>> map = keys;
        boolean $i$f$mapValues = false;
        void var6_5 = $this$mapValues$iv;
        Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean bl = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$filterTo$iv$iv;
            void kvp;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv$iv;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl22 = false;
            Iterable $this$filter$iv = (Iterable)kvp.getValue();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map it = (Map)element$iv$iv;
                boolean bl3 = false;
                boolean bl4 = !it.isEmpty();
                if (!bl4) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv2;
            map3.put(k, collection);
        }
        $this$mapValues$iv = destination$iv$iv$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            List it = (List)entry.getValue();
            boolean bl5 = false;
            boolean bl6 = !((Collection)it).isEmpty();
            if (!bl6) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Map validKeys = result$iv;
        if (forceKeys && validKeys.isEmpty()) {
            throw new InvalidDataException("schema strategy requires at least one node key with valid properties on nodes.");
        }
        $this$filterValues$iv = validKeys;
        collection = CollectionsKt.toSet((Iterable)validKeys.keySet());
        boolean $i$f$flatMap = false;
        result$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean bl7 = false;
        for (Map.Entry element$iv$iv : $this$flatMapTo$iv$iv.entrySet()) {
            Map.Entry it = element$iv$iv;
            boolean bl8 = false;
            Iterable list$iv$iv = (Iterable)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)((List)destination$iv$iv)), ApocCdcSchemaHandler::buildMatchLabelsAndProperties$lambda$3);
        boolean $i$f$associate = false;
        $this$flatMapTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean bl9 = false;
        for (Map.Entry element$iv$iv : $this$associateTo$iv$iv) {
            Object object = destination$iv$iv;
            Map.Entry it = element$iv$iv;
            boolean bl10 = false;
            Pair pair = TuplesKt.to(it.getKey(), it.getValue());
            object.put(pair.getFirst(), pair.getSecond());
        }
        Object object = destination$iv$iv;
        Collection collection2 = collection;
        return new Pair((Object)collection2, object);
    }

    static /* synthetic */ Pair buildMatchLabelsAndProperties$default(ApocCdcSchemaHandler apocCdcSchemaHandler, Map map, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return apocCdcSchemaHandler.buildMatchLabelsAndProperties(map, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<String, Map<String, Object>> buildMatchLabelsAndProperties(String type, List<? extends Map<String, ? extends Object>> keys, Map<String, ? extends Object> properties) {
        Map map;
        String string = type;
        if (keys.isEmpty()) {
            map = properties;
            if (map == null) {
                map = MapsKt.emptyMap();
            }
        } else {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            Sequence sequence = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)keys), ApocCdcSchemaHandler::buildMatchLabelsAndProperties$lambda$5);
            String string2 = string;
            boolean $i$f$associate = false;
            void var6_7 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to(it.getKey(), it.getValue());
                map2.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv$iv;
            string = string2;
        }
        Map map3 = map;
        String string3 = string;
        return new Pair((Object)string3, (Object)map3);
    }

    private static final Sequence buildMatchLabelsAndProperties$lambda$3(Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return MapsKt.asSequence((Map)it);
    }

    private static final Sequence buildMatchLabelsAndProperties$lambda$5(Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return MapsKt.asSequence((Map)it);
    }
}

