/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy.cdc.apoc;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.neo4j.caniuse.Neo4j;
import org.neo4j.cdc.client.model.EntityEvent;
import org.neo4j.cdc.client.model.EntityOperation;
import org.neo4j.cdc.client.model.NodeEvent;
import org.neo4j.cdc.client.model.NodeState;
import org.neo4j.cdc.client.model.RelationshipEvent;
import org.neo4j.cdc.client.model.RelationshipState;
import org.neo4j.connectors.kafka.exceptions.InvalidDataException;
import org.neo4j.connectors.kafka.sink.SinkStrategy;
import org.neo4j.connectors.kafka.sink.strategy.EventExtensionsKt;
import org.neo4j.connectors.kafka.sink.strategy.cdc.apoc.ApocCdcHandler;
import org.neo4j.connectors.kafka.sink.strategy.cdc.apoc.CdcNodeData;
import org.neo4j.connectors.kafka.sink.strategy.cdc.apoc.CdcRelationshipData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0014\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u001bH\u0014J\u0010\u0010\u0018\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u001bH\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u001bH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/cdc/apoc/ApocCdcSourceIdHandler;", "Lorg/neo4j/connectors/kafka/sink/strategy/cdc/apoc/ApocCdcHandler;", "topic", "", "neo4j", "Lorg/neo4j/caniuse/Neo4j;", "batchSize", "", "labelName", "propertyName", "<init>", "(Ljava/lang/String;Lorg/neo4j/caniuse/Neo4j;ILjava/lang/String;Ljava/lang/String;)V", "getTopic", "()Ljava/lang/String;", "getLabelName", "getPropertyName", "logger", "Lorg/slf4j/Logger;", "strategy", "Lorg/neo4j/connectors/kafka/sink/SinkStrategy;", "transformCreate", "Lorg/neo4j/connectors/kafka/sink/strategy/cdc/apoc/CdcNodeData;", "event", "Lorg/neo4j/cdc/client/model/NodeEvent;", "transformUpdate", "transformDelete", "Lorg/neo4j/connectors/kafka/sink/strategy/cdc/apoc/CdcRelationshipData;", "Lorg/neo4j/cdc/client/model/RelationshipEvent;", "sink"})
public final class ApocCdcSourceIdHandler
extends ApocCdcHandler {
    @NotNull
    private final String topic;
    @NotNull
    private final String labelName;
    @NotNull
    private final String propertyName;
    @NotNull
    private final Logger logger;

    public ApocCdcSourceIdHandler(@NotNull String topic, @NotNull Neo4j neo4j, int batchSize, @NotNull String labelName, @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)neo4j, (String)"neo4j");
        Intrinsics.checkNotNullParameter((Object)labelName, (String)"labelName");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        super(neo4j, batchSize);
        this.topic = topic;
        this.labelName = labelName;
        this.propertyName = propertyName;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.logger.info("using APOC compatible CDC SOURCE_ID strategy for topic '{}'", (Object)this.topic);
    }

    public /* synthetic */ ApocCdcSourceIdHandler(String string, Neo4j neo4j, int n, String string2, String string3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            string2 = "SourceEvent";
        }
        if ((n2 & 0x10) != 0) {
            string3 = "sourceId";
        }
        this(string, neo4j, n, string2, string3);
    }

    @NotNull
    public final String getTopic() {
        return this.topic;
    }

    @NotNull
    public final String getLabelName() {
        return this.labelName;
    }

    @NotNull
    public final String getPropertyName() {
        return this.propertyName;
    }

    @Override
    @NotNull
    public SinkStrategy strategy() {
        return SinkStrategy.CDC_SOURCE_ID;
    }

    @Override
    @NotNull
    protected CdcNodeData transformCreate(@NotNull NodeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getBefore() != null) {
            throw new InvalidDataException("create operation requires 'before' field to be unset in the event object");
        }
        if (event.getAfter() == null) {
            throw new InvalidDataException("create operation requires 'after' field in the event object");
        }
        Set set = SetsKt.setOf((Object)this.labelName);
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)this.propertyName, (Object)event.getElementId()));
        Map map2 = ((NodeState)event.getAfter()).getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getProperties(...)");
        List list = ((NodeState)event.getAfter()).getLabels();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLabels(...)");
        return new CdcNodeData(EntityOperation.CREATE, set, map, map2, CollectionsKt.toSet((Iterable)CollectionsKt.minus((Iterable)list, (Object)this.labelName)), SetsKt.emptySet());
    }

    @Override
    @NotNull
    protected CdcNodeData transformUpdate(@NotNull NodeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getBefore() == null) {
            throw new InvalidDataException("update operation requires 'before' field in the event object");
        }
        if (event.getAfter() == null) {
            throw new InvalidDataException("update operation requires 'after' field in the event object");
        }
        return new CdcNodeData(EntityOperation.UPDATE, SetsKt.setOf((Object)this.labelName), MapsKt.mapOf((Pair)TuplesKt.to((Object)this.propertyName, (Object)event.getElementId())), EventExtensionsKt.mutatedProperties((EntityEvent)event), CollectionsKt.toSet((Iterable)EventExtensionsKt.addedLabels(event)), CollectionsKt.toSet((Iterable)EventExtensionsKt.removedLabels(event)));
    }

    @Override
    @NotNull
    protected CdcNodeData transformDelete(@NotNull NodeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAfter() != null) {
            throw new InvalidDataException("delete operation requires 'after' field to be unset in the event object");
        }
        return new CdcNodeData(EntityOperation.DELETE, SetsKt.setOf((Object)this.labelName), MapsKt.mapOf((Pair)TuplesKt.to((Object)this.propertyName, (Object)event.getElementId())), MapsKt.emptyMap(), SetsKt.emptySet(), SetsKt.emptySet());
    }

    @Override
    @NotNull
    protected CdcRelationshipData transformCreate(@NotNull RelationshipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getBefore() != null) {
            throw new InvalidDataException("create operation requires 'before' field to be unset in the event object");
        }
        if (event.getAfter() == null) {
            throw new InvalidDataException("create operation requires 'after' field in the event object");
        }
        Set set = SetsKt.setOf((Object)this.labelName);
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)this.propertyName, (Object)event.getStart().getElementId()));
        Set set2 = SetsKt.setOf((Object)this.labelName);
        Map map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)this.propertyName, (Object)event.getEnd().getElementId()));
        String string = event.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
        Map map3 = MapsKt.mapOf((Pair)TuplesKt.to((Object)this.propertyName, (Object)event.getElementId()));
        Map map4 = ((RelationshipState)event.getAfter()).getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map4, (String)"getProperties(...)");
        return new CdcRelationshipData(EntityOperation.CREATE, set, map, set2, map2, string, map3, true, map4);
    }

    @Override
    @NotNull
    protected CdcRelationshipData transformUpdate(@NotNull RelationshipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getBefore() == null) {
            throw new InvalidDataException("update operation requires 'before' field in the event object");
        }
        if (event.getAfter() == null) {
            throw new InvalidDataException("update operation requires 'after' field in the event object");
        }
        Set set = SetsKt.setOf((Object)this.labelName);
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)this.propertyName, (Object)event.getStart().getElementId()));
        Set set2 = SetsKt.setOf((Object)this.labelName);
        Map map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)this.propertyName, (Object)event.getEnd().getElementId()));
        String string = event.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
        return new CdcRelationshipData(EntityOperation.UPDATE, set, map, set2, map2, string, MapsKt.mapOf((Pair)TuplesKt.to((Object)this.propertyName, (Object)event.getElementId())), true, EventExtensionsKt.mutatedProperties((EntityEvent)event));
    }

    @Override
    @NotNull
    protected CdcRelationshipData transformDelete(@NotNull RelationshipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAfter() != null) {
            throw new InvalidDataException("delete operation requires 'after' field to be unset in the event object");
        }
        Set set = SetsKt.emptySet();
        Map map = MapsKt.emptyMap();
        Set set2 = SetsKt.emptySet();
        Map map2 = MapsKt.emptyMap();
        String string = event.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
        return new CdcRelationshipData(EntityOperation.DELETE, set, map, set2, map2, string, MapsKt.mapOf((Pair)TuplesKt.to((Object)this.propertyName, (Object)event.getElementId())), true, MapsKt.emptyMap());
    }
}

