/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy.cdc.batch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cdc.client.model.ChangeEvent;
import org.neo4j.cdc.client.model.EntityOperation;
import org.neo4j.cdc.client.model.Event;
import org.neo4j.cdc.client.model.NodeEvent;
import org.neo4j.cdc.client.model.RelationshipEvent;
import org.neo4j.connectors.kafka.sink.ChangeQuery;
import org.neo4j.connectors.kafka.sink.SinkMessage;
import org.neo4j.connectors.kafka.sink.SinkStrategyHandler;
import org.neo4j.connectors.kafka.sink.strategy.CdcHandlerKt;
import org.neo4j.connectors.kafka.sink.strategy.cdc.batch.CdcData;
import org.neo4j.connectors.kafka.sink.strategy.cdc.batch.GroupingKey;
import org.neo4j.driver.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\"\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0016J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002JB\u0010\u0012\u001a\u00020\u00132\u001e\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00180\u00170\u00152\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00150\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH$J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH$J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH$J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020 H$J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020 H$J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020 H$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/cdc/batch/BatchedCdcHandler;", "Lorg/neo4j/connectors/kafka/sink/SinkStrategyHandler;", "maxBatchedStatements", "", "batchSize", "<init>", "(II)V", "logger", "Lorg/slf4j/Logger;", "handle", "", "Lorg/neo4j/connectors/kafka/sink/ChangeQuery;", "messages", "Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "splitEventsIntoBatches", "", "events", "Lorg/neo4j/connectors/kafka/sink/strategy/cdc/batch/BatchedCdcHandler$MessageToEvent;", "batchedStatement", "Lorg/neo4j/driver/Query;", "queries", "", "Lorg/neo4j/connectors/kafka/sink/strategy/cdc/batch/GroupingKey;", "Lkotlin/Pair;", "", "", "transformCreate", "Lorg/neo4j/connectors/kafka/sink/strategy/cdc/batch/CdcData;", "event", "Lorg/neo4j/cdc/client/model/NodeEvent;", "transformUpdate", "transformDelete", "Lorg/neo4j/cdc/client/model/RelationshipEvent;", "MessageToEvent", "sink"})
@SourceDebugExtension(value={"SMAP\nBatchedCdcHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BatchedCdcHandler.kt\norg/neo4j/connectors/kafka/sink/strategy/cdc/batch/BatchedCdcHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,164:1\n2802#2:165\n1586#2:167\n1661#2,3:168\n2802#2:171\n1915#2:173\n1916#2:181\n1915#2,2:182\n1915#2,2:184\n1#3:166\n1#3:172\n383#4,7:174\n*S KotlinDebug\n*F\n+ 1 BatchedCdcHandler.kt\norg/neo4j/connectors/kafka/sink/strategy/cdc/batch/BatchedCdcHandler\n*L\n46#1:165\n47#1:167\n47#1:168,3\n75#1:171\n105#1:173\n105#1:181\n135#1:182,2\n146#1:184,2\n46#1:166\n75#1:172\n112#1:174,7\n*E\n"})
public abstract class BatchedCdcHandler
implements SinkStrategyHandler {
    private final int maxBatchedStatements;
    private final int batchSize;
    @NotNull
    private final Logger logger;

    public BatchedCdcHandler(int maxBatchedStatements, int batchSize) {
        this.maxBatchedStatements = maxBatchedStatements;
        this.batchSize = batchSize;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<Iterable<ChangeQuery>> handle(@NotNull Iterable<SinkMessage> messages) {
        void $this$mapTo$iv$iv;
        Object it;
        Iterable iterable;
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Iterable $this$onEach$iv = messages;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u240$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (SinkMessage element$iv : $this$onEach_u24lambda_u240$iv) {
            it = element$iv;
            boolean bl2 = false;
            this.logger.trace("received message: {}", it);
        }
        Iterable $this$map$iv = iterable;
        boolean $i$f$map = false;
        iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (SinkMessage item$iv$iv : $this$mapTo$iv$iv) {
            CdcData cdcData;
            ChangeEvent changeEvent;
            Collection collection;
            block14: {
                Event event;
                block15: {
                    block13: {
                        it = item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl3 = false;
                        changeEvent = CdcHandlerKt.toChangeEvent((SinkMessage)it);
                        event = CdcHandlerKt.toChangeEvent((SinkMessage)it).getEvent();
                        if (!(event instanceof NodeEvent)) break block13;
                        EntityOperation entityOperation = ((NodeEvent)event).getOperation();
                        switch (entityOperation == null ? -1 : WhenMappings.$EnumSwitchMapping$0[entityOperation.ordinal()]) {
                            case 1: {
                                cdcData = this.transformCreate((NodeEvent)event);
                                break block14;
                            }
                            case 2: {
                                cdcData = this.transformUpdate((NodeEvent)event);
                                break block14;
                            }
                            case 3: {
                                cdcData = this.transformDelete((NodeEvent)event);
                                break block14;
                            }
                            default: {
                                throw new IllegalArgumentException("unknown operation " + ((NodeEvent)event).getOperation());
                            }
                        }
                    }
                    if (!(event instanceof RelationshipEvent)) break block15;
                    EntityOperation entityOperation = ((RelationshipEvent)event).getOperation();
                    switch (entityOperation == null ? -1 : WhenMappings.$EnumSwitchMapping$0[entityOperation.ordinal()]) {
                        case 1: {
                            cdcData = this.transformCreate((RelationshipEvent)event);
                            break block14;
                        }
                        case 2: {
                            cdcData = this.transformUpdate((RelationshipEvent)event);
                            break block14;
                        }
                        case 3: {
                            cdcData = this.transformDelete((RelationshipEvent)event);
                            break block14;
                        }
                        default: {
                            throw new IllegalArgumentException("unknown operation " + ((RelationshipEvent)event).getOperation());
                        }
                    }
                }
                throw new IllegalArgumentException("unsupported event type " + event.getEventType());
            }
            collection.add(new MessageToEvent((SinkMessage)it, changeEvent, cdcData));
        }
        List changeEvents = (List)destination$iv$iv;
        $this$onEach$iv = CollectionsKt.listOf(this.splitEventsIntoBatches(changeEvents, this.maxBatchedStatements));
        $i$f$onEach = false;
        $this$onEach_u24lambda_u240$iv = iterable = $this$onEach$iv;
        bl = false;
        for (SinkMessage element$iv : $this$onEach_u24lambda_u240$iv) {
            it = (List)((Object)element$iv);
            boolean bl4 = false;
            this.logger.trace("messages: {} ", it);
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ChangeQuery> splitEventsIntoBatches(List<MessageToEvent> events, int maxBatchedStatements) {
        List result = new ArrayList();
        int currentGroupId = 0;
        Map queries = new LinkedHashMap();
        List currentEvents = new ArrayList();
        List currentMessages = new ArrayList();
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void $this$getOrPut$iv;
            MessageToEvent event = (MessageToEvent)element$iv;
            boolean bl = false;
            GroupingKey key = event.getCdcData().groupingBasedOn();
            if (!queries.containsKey(key) && queries.size() >= maxBatchedStatements) {
                BatchedCdcHandler.splitEventsIntoBatches$flush(result, currentMessages, this, queries, currentEvents);
            }
            Map map = queries;
            GroupingKey key$iv = key;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                int n = currentGroupId;
                currentGroupId = n + 1;
                Pair answer$iv = TuplesKt.to((Object)n, (Object)event.getCdcData().buildStatement());
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            int groupId = ((Number)((Pair)object).component1()).intValue();
            currentEvents.add(event.getCdcData().toParams(groupId));
            currentMessages.add(event.getMessage());
            if (currentEvents.size() < this.batchSize) continue;
            BatchedCdcHandler.splitEventsIntoBatches$flush(result, currentMessages, this, queries, currentEvents);
        }
        if (!queries.isEmpty() && !((Collection)currentEvents).isEmpty()) {
            BatchedCdcHandler.splitEventsIntoBatches$flush(result, currentMessages, this, queries, currentEvents);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Query batchedStatement(Map<GroupingKey, Pair<Integer, String>> queries, List<? extends Map<String, ? extends Object>> events) {
        void $this$batchedStatement_u24lambda_u241;
        Object object;
        Object $this$batchedStatement_u24lambda_u240 = object = new StringBuilder();
        boolean bl = false;
        ((StringBuilder)$this$batchedStatement_u24lambda_u240).append("CYPHER 25 ");
        ((StringBuilder)$this$batchedStatement_u24lambda_u240).append("UNWIND $events AS e CALL (e) { ");
        Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)queries.keySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair<Integer, String> pair;
            GroupingKey key = (GroupingKey)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull(queries.get(key));
            int index = ((Number)pair.component1()).intValue();
            String stmt = (String)pair.component2();
            ((StringBuilder)$this$batchedStatement_u24lambda_u240).append("WHEN e.q = $q" + index + " THEN " + stmt + " ");
        }
        ((StringBuilder)$this$batchedStatement_u24lambda_u240).append("} FINISH");
        String query = ((StringBuilder)object).toString();
        $this$batchedStatement_u24lambda_u240 = object = MapsKt.createMapBuilder();
        String string = query;
        boolean bl3 = false;
        $this$forEach$iv = queries.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl4 = false;
            int index = ((Number)pair.component1()).intValue();
            $this$batchedStatement_u24lambda_u241.put("q" + index, index);
        }
        $this$batchedStatement_u24lambda_u241.put("events", events);
        Map map = MapsKt.build((Map)object);
        String string2 = string;
        return new Query(string2, map);
    }

    @NotNull
    protected abstract CdcData transformCreate(@NotNull NodeEvent var1);

    @NotNull
    protected abstract CdcData transformUpdate(@NotNull NodeEvent var1);

    @NotNull
    protected abstract CdcData transformDelete(@NotNull NodeEvent var1);

    @NotNull
    protected abstract CdcData transformCreate(@NotNull RelationshipEvent var1);

    @NotNull
    protected abstract CdcData transformUpdate(@NotNull RelationshipEvent var1);

    @NotNull
    protected abstract CdcData transformDelete(@NotNull RelationshipEvent var1);

    private static final void splitEventsIntoBatches$flush(List<ChangeQuery> result, List<SinkMessage> currentMessages, BatchedCdcHandler this$0, Map<GroupingKey, Pair<Integer, String>> queries, List<Map<String, Object>> currentEvents) {
        result.add(new ChangeQuery(null, null, CollectionsKt.toList((Iterable)currentMessages), this$0.batchedStatement(queries, currentEvents)));
        queries.clear();
        currentEvents.clear();
        currentMessages.clear();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/cdc/batch/BatchedCdcHandler$MessageToEvent;", "", "message", "Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "changeEvent", "Lorg/neo4j/cdc/client/model/ChangeEvent;", "cdcData", "Lorg/neo4j/connectors/kafka/sink/strategy/cdc/batch/CdcData;", "<init>", "(Lorg/neo4j/connectors/kafka/sink/SinkMessage;Lorg/neo4j/cdc/client/model/ChangeEvent;Lorg/neo4j/connectors/kafka/sink/strategy/cdc/batch/CdcData;)V", "getMessage", "()Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "getChangeEvent", "()Lorg/neo4j/cdc/client/model/ChangeEvent;", "getCdcData", "()Lorg/neo4j/connectors/kafka/sink/strategy/cdc/batch/CdcData;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "sink"})
    public static final class MessageToEvent {
        @NotNull
        private final SinkMessage message;
        @NotNull
        private final ChangeEvent changeEvent;
        @NotNull
        private final CdcData cdcData;

        public MessageToEvent(@NotNull SinkMessage message, @NotNull ChangeEvent changeEvent, @NotNull CdcData cdcData) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)changeEvent, (String)"changeEvent");
            Intrinsics.checkNotNullParameter((Object)cdcData, (String)"cdcData");
            this.message = message;
            this.changeEvent = changeEvent;
            this.cdcData = cdcData;
        }

        @NotNull
        public final SinkMessage getMessage() {
            return this.message;
        }

        @NotNull
        public final ChangeEvent getChangeEvent() {
            return this.changeEvent;
        }

        @NotNull
        public final CdcData getCdcData() {
            return this.cdcData;
        }

        @NotNull
        public final SinkMessage component1() {
            return this.message;
        }

        @NotNull
        public final ChangeEvent component2() {
            return this.changeEvent;
        }

        @NotNull
        public final CdcData component3() {
            return this.cdcData;
        }

        @NotNull
        public final MessageToEvent copy(@NotNull SinkMessage message, @NotNull ChangeEvent changeEvent, @NotNull CdcData cdcData) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)changeEvent, (String)"changeEvent");
            Intrinsics.checkNotNullParameter((Object)cdcData, (String)"cdcData");
            return new MessageToEvent(message, changeEvent, cdcData);
        }

        public static /* synthetic */ MessageToEvent copy$default(MessageToEvent messageToEvent, SinkMessage sinkMessage, ChangeEvent changeEvent, CdcData cdcData, int n, Object object) {
            if ((n & 1) != 0) {
                sinkMessage = messageToEvent.message;
            }
            if ((n & 2) != 0) {
                changeEvent = messageToEvent.changeEvent;
            }
            if ((n & 4) != 0) {
                cdcData = messageToEvent.cdcData;
            }
            return messageToEvent.copy(sinkMessage, changeEvent, cdcData);
        }

        @NotNull
        public String toString() {
            return "MessageToEvent(message=" + this.message + ", changeEvent=" + this.changeEvent + ", cdcData=" + this.cdcData + ")";
        }

        public int hashCode() {
            int result = this.message.hashCode();
            result = result * 31 + this.changeEvent.hashCode();
            result = result * 31 + this.cdcData.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MessageToEvent)) {
                return false;
            }
            MessageToEvent messageToEvent = (MessageToEvent)other;
            if (!Intrinsics.areEqual((Object)this.message, (Object)messageToEvent.message)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.changeEvent, (Object)messageToEvent.changeEvent)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cdcData, (Object)messageToEvent.cdcData);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EntityOperation.values().length];
            try {
                nArray[EntityOperation.CREATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityOperation.UPDATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntityOperation.DELETE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

