/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy.cdc.batch;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cdc.client.model.EntityOperation;
import org.neo4j.connectors.kafka.events.EntityType;
import org.neo4j.connectors.kafka.sink.strategy.cdc.batch.GroupingKeyKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nB9\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u001e\u0010\u0006\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\r\"\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0004\b\t\u0010\u000eJ\u0012\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000H\u0096\u0082\u0004J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000H\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000H\u0002J$\u0010\u001b\u001a\u00020\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0002J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007H\u00c6\u0003J3\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007H\u00c6\u0001J\u0014\u0010\"\u001a\u00020#2\b\u0010\u0017\u001a\u0004\u0018\u00010$H\u00d6\u0083\u0004J\n\u0010%\u001a\u00020\u0016H\u00d6\u0081\u0004J\n\u0010&\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/cdc/batch/GroupingKey;", "", "entityType", "Lorg/neo4j/connectors/kafka/events/EntityType;", "operationType", "", "propertyKeys", "", "", "<init>", "(Lorg/neo4j/connectors/kafka/events/EntityType;Ljava/lang/String;Ljava/util/List;)V", "operation", "Lorg/neo4j/cdc/client/model/EntityOperation;", "", "(Lorg/neo4j/connectors/kafka/events/EntityType;Lorg/neo4j/cdc/client/model/EntityOperation;[Ljava/util/Set;)V", "getEntityType", "()Lorg/neo4j/connectors/kafka/events/EntityType;", "getOperationType", "()Ljava/lang/String;", "getPropertyKeys", "()Ljava/util/List;", "compareTo", "", "other", "compareEntityType", "compareOperationType", "comparePropertyKeys", "compareKeySets", "a", "b", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toString", "sink"})
@SourceDebugExtension(value={"SMAP\nGroupingKey.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupingKey.kt\norg/neo4j/connectors/kafka/sink/strategy/cdc/batch/GroupingKey\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class GroupingKey
implements Comparable<GroupingKey> {
    @NotNull
    private final EntityType entityType;
    @NotNull
    private final String operationType;
    @NotNull
    private final List<Set<String>> propertyKeys;

    public GroupingKey(@NotNull EntityType entityType, @NotNull String operationType, @NotNull List<? extends Set<String>> propertyKeys) {
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)operationType, (String)"operationType");
        Intrinsics.checkNotNullParameter(propertyKeys, (String)"propertyKeys");
        this.entityType = entityType;
        this.operationType = operationType;
        this.propertyKeys = propertyKeys;
    }

    @NotNull
    public final EntityType getEntityType() {
        return this.entityType;
    }

    @NotNull
    public final String getOperationType() {
        return this.operationType;
    }

    @NotNull
    public final List<Set<String>> getPropertyKeys() {
        return this.propertyKeys;
    }

    public GroupingKey(@NotNull EntityType entityType, @NotNull EntityOperation operation, Set<String> ... propertyKeys) {
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter(propertyKeys, (String)"propertyKeys");
        this(entityType, GroupingKeyKt.updateStrategy(operation, entityType), ArraysKt.toList((Object[])propertyKeys));
    }

    @Override
    public int compareTo(@NotNull GroupingKey other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Integer n2 = this.compareEntityType(other);
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = it != 0 ? n2 : null;
        if (n3 != null) {
            n = n3;
        } else {
            Integer n4 = this.compareOperationType(other);
            int it2 = ((Number)n4).intValue();
            boolean bl2 = false;
            Integer n5 = it2 != 0 ? n4 : null;
            n = n5 != null ? n5.intValue() : this.comparePropertyKeys(other);
        }
        return n;
    }

    private final int compareEntityType(GroupingKey other) {
        return this.entityType == other.entityType ? 0 : (this.entityType == EntityType.node ? -1 : 1);
    }

    private final int compareOperationType(GroupingKey other) {
        return this.operationType.compareTo(other.operationType);
    }

    private final int comparePropertyKeys(GroupingKey other) {
        int n = ((Collection)this.propertyKeys).size();
        for (int i = 0; i < n; ++i) {
            if (i >= other.propertyKeys.size()) {
                return 1;
            }
            int cmp = this.compareKeySets(this.propertyKeys.get(i), other.propertyKeys.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private final int compareKeySets(Set<String> a, Set<String> b) {
        int sizeCmp = Intrinsics.compare((int)a.size(), (int)b.size());
        if (sizeCmp != 0) {
            return sizeCmp;
        }
        List aSorted = CollectionsKt.sorted((Iterable)a);
        List bSorted = CollectionsKt.sorted((Iterable)b);
        int n = ((Collection)aSorted).size();
        for (int i = 0; i < n; ++i) {
            int cmp = ((String)aSorted.get(i)).compareTo((String)bSorted.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @NotNull
    public final EntityType component1() {
        return this.entityType;
    }

    @NotNull
    public final String component2() {
        return this.operationType;
    }

    @NotNull
    public final List<Set<String>> component3() {
        return this.propertyKeys;
    }

    @NotNull
    public final GroupingKey copy(@NotNull EntityType entityType, @NotNull String operationType, @NotNull List<? extends Set<String>> propertyKeys) {
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)operationType, (String)"operationType");
        Intrinsics.checkNotNullParameter(propertyKeys, (String)"propertyKeys");
        return new GroupingKey(entityType, operationType, propertyKeys);
    }

    public static /* synthetic */ GroupingKey copy$default(GroupingKey groupingKey, EntityType entityType, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            entityType = groupingKey.entityType;
        }
        if ((n & 2) != 0) {
            string = groupingKey.operationType;
        }
        if ((n & 4) != 0) {
            list = groupingKey.propertyKeys;
        }
        return groupingKey.copy(entityType, string, list);
    }

    @NotNull
    public String toString() {
        return "GroupingKey(entityType=" + this.entityType + ", operationType=" + this.operationType + ", propertyKeys=" + this.propertyKeys + ")";
    }

    public int hashCode() {
        int result = this.entityType.hashCode();
        result = result * 31 + this.operationType.hashCode();
        result = result * 31 + ((Object)this.propertyKeys).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GroupingKey)) {
            return false;
        }
        GroupingKey groupingKey = (GroupingKey)other;
        if (this.entityType != groupingKey.entityType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.operationType, (Object)groupingKey.operationType)) {
            return false;
        }
        return Intrinsics.areEqual(this.propertyKeys, groupingKey.propertyKeys);
    }
}

