/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy.cud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.connectors.kafka.exceptions.InvalidDataException;
import org.neo4j.connectors.kafka.sink.strategy.cud.HelpersKt;
import org.neo4j.connectors.kafka.sink.strategy.cud.Operation;
import org.neo4j.connectors.kafka.utils.MapUtils;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.ExposesWhere;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.Query;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eBA\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0017\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006H\u00c6\u0003J\u0017\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006H\u00c6\u0003JI\u0010\u0017\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006H\u00c6\u0001J\u0014\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u00d6\u0083\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u00d6\u0081\u0004J\n\u0010\u001d\u001a\u00020\u0004H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001f\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001f\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/cud/MergeNode;", "Lorg/neo4j/connectors/kafka/sink/strategy/cud/Operation;", "labels", "", "", "ids", "", "", "properties", "<init>", "(Ljava/util/Set;Ljava/util/Map;Ljava/util/Map;)V", "getLabels", "()Ljava/util/Set;", "getIds", "()Ljava/util/Map;", "getProperties", "toQuery", "Lorg/neo4j/driver/Query;", "renderer", "Lorg/neo4j/cypherdsl/core/renderer/Renderer;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "sink"})
public final class MergeNode
implements Operation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> labels;
    @NotNull
    private final Map<String, Object> ids;
    @NotNull
    private final Map<String, Object> properties;

    public MergeNode(@NotNull Set<String> labels, @NotNull Map<String, ? extends Object> ids, @NotNull Map<String, ? extends Object> properties) {
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.labels = labels;
        this.ids = ids;
        this.properties = properties;
    }

    @NotNull
    public final Set<String> getLabels() {
        return this.labels;
    }

    @NotNull
    public final Map<String, Object> getIds() {
        return this.ids;
    }

    @NotNull
    public final Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    @NotNull
    public Query toQuery(@NotNull Renderer renderer) {
        Statement statement;
        PatternElement[] patternElementArray;
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        if (this.ids.isEmpty()) {
            throw new InvalidDataException("Node must contain at least one ID property.");
        }
        Parameter parameter = Cypher.parameter((String)"keys");
        Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter(...)");
        Parameter keysParam = parameter;
        Parameter parameter2 = Cypher.parameter((String)"properties");
        Intrinsics.checkNotNullExpressionValue((Object)parameter2, (String)"parameter(...)");
        Parameter propertiesParam = parameter2;
        Node node = HelpersKt.buildNode(this.labels, this.ids, (Expression)keysParam).named("n");
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"named(...)");
        Node node2 = node;
        if (this.ids.containsKey("_id") || this.ids.containsKey("_elementId")) {
            patternElementArray = new PatternElement[]{node2};
            statement = ((StatementBuilder.OngoingReadingWithoutWhere)HelpersKt.applyFilter((ExposesWhere)Cypher.match((PatternElement[])patternElementArray), node2, this.ids, (Expression)keysParam)).mutate((Named)node2, (Expression)propertiesParam).build();
        } else {
            patternElementArray = new PatternElement[]{node2};
            statement = Cypher.merge((PatternElement[])patternElementArray).mutate((Named)node2, (Expression)propertiesParam).build();
        }
        String stmt = renderer.render(statement);
        patternElementArray = new Pair[]{TuplesKt.to((Object)"keys", this.ids), TuplesKt.to((Object)"properties", this.properties)};
        return new Query(stmt, MapsKt.mapOf((Pair[])patternElementArray));
    }

    @NotNull
    public final Set<String> component1() {
        return this.labels;
    }

    @NotNull
    public final Map<String, Object> component2() {
        return this.ids;
    }

    @NotNull
    public final Map<String, Object> component3() {
        return this.properties;
    }

    @NotNull
    public final MergeNode copy(@NotNull Set<String> labels, @NotNull Map<String, ? extends Object> ids, @NotNull Map<String, ? extends Object> properties) {
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        return new MergeNode(labels, ids, properties);
    }

    public static /* synthetic */ MergeNode copy$default(MergeNode mergeNode, Set set, Map map, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            set = mergeNode.labels;
        }
        if ((n & 2) != 0) {
            map = mergeNode.ids;
        }
        if ((n & 4) != 0) {
            map2 = mergeNode.properties;
        }
        return mergeNode.copy(set, map, map2);
    }

    @NotNull
    public String toString() {
        return "MergeNode(labels=" + this.labels + ", ids=" + this.ids + ", properties=" + this.properties + ")";
    }

    public int hashCode() {
        int result = ((Object)this.labels).hashCode();
        result = result * 31 + ((Object)this.ids).hashCode();
        result = result * 31 + ((Object)this.properties).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MergeNode)) {
            return false;
        }
        MergeNode mergeNode = (MergeNode)other;
        if (!Intrinsics.areEqual(this.labels, mergeNode.labels)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.ids, mergeNode.ids)) {
            return false;
        }
        return Intrinsics.areEqual(this.properties, mergeNode.properties);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a8\u0006\t"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/cud/MergeNode$Companion;", "", "<init>", "()V", "from", "Lorg/neo4j/connectors/kafka/sink/strategy/cud/MergeNode;", "values", "", "", "sink"})
    @SourceDebugExtension(value={"SMAP\nMergeNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeNode.kt\norg/neo4j/connectors/kafka/sink/strategy/cud/MergeNode$Companion\n+ 2 MapUtils.kt\norg/neo4j/connectors/kafka/utils/MapUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,66:1\n24#2,4:67\n28#2,7:74\n36#2:82\n41#2,5:83\n46#2,12:91\n59#2,2:104\n41#2,5:106\n46#2,12:114\n59#2,2:127\n1586#3:71\n1661#3,2:72\n1663#3:81\n129#4:88\n158#4,2:89\n160#4:103\n129#4:111\n158#4,2:112\n160#4:126\n*S KotlinDebug\n*F\n+ 1 MergeNode.kt\norg/neo4j/connectors/kafka/sink/strategy/cud/MergeNode$Companion\n*L\n57#1:67,4\n57#1:74,7\n57#1:82\n58#1:83,5\n58#1:91,12\n58#1:104,2\n60#1:106,5\n60#1:114,12\n60#1:127,2\n57#1:71\n57#1:72,2\n57#1:81\n58#1:88\n58#1:89,2\n58#1:103\n60#1:111\n60#1:112,2\n60#1:126\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MergeNode from(@NotNull Map<String, ? extends Object> values) {
            Map map;
            Map map2;
            boolean bl;
            Map map3;
            Map<String, ? extends Object> $this$getMap$iv;
            Object it$iv;
            Collection collection;
            Object item$iv$iv$iv;
            Iterator<Object> iterator;
            Object $this$mapTo$iv$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv$iv;
            boolean $i$f$map;
            Object $this$map$iv$iv;
            Iterable iterable;
            Map<String, ? extends Object> $this$getIterable$iv;
            Intrinsics.checkNotNullParameter(values, (String)"values");
            MapUtils mapUtils = MapUtils.INSTANCE;
            Map<String, ? extends Object> map4 = values;
            String key$iv = "labels";
            boolean $i$f$getIterable = false;
            Object value$iv = $this$getIterable$iv.get(key$iv);
            if (value$iv == null) {
                iterable = null;
            } else if (value$iv instanceof Iterable) {
                $this$map$iv$iv = (Iterable)value$iv;
                $i$f$map = false;
                Iterable iterable2 = $this$map$iv$iv;
                destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void v1;
                    item$iv$iv$iv = iterator.next();
                    Object t = item$iv$iv$iv;
                    collection = destination$iv$iv$iv;
                    boolean bl2 = false;
                    if (Reflection.getOrCreateKotlinClass(String.class).isInstance(it$iv)) {
                        v1 = it$iv;
                        if (v1 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                    } else {
                        throw new InvalidDataException("Elements of '" + key$iv + "' is not an instance of " + Reflection.getOrCreateKotlinClass(String.class).getSimpleName());
                    }
                    collection.add((String)v1);
                }
                iterable = (List)destination$iv$iv$iv;
            } else {
                throw new InvalidDataException("Map element '" + key$iv + "' is not an instance of Iterable");
            }
            Set set = iterable;
            if (iterable == null || (set = CollectionsKt.toSet(set)) == null) {
                set = SetsKt.emptySet();
            }
            MapUtils this_$iv = MapUtils.INSTANCE;
            $this$getIterable$iv = values;
            key$iv = "ids";
            Set set2 = set;
            boolean $i$f$getMap = false;
            value$iv = $this$getMap$iv.get(key$iv);
            if (value$iv == null) {
                map3 = null;
            } else if (value$iv instanceof Map) {
                $this$map$iv$iv = (Map)value$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv$iv = $this$map$iv$iv;
                destination$iv$iv$iv = new ArrayList($this$map$iv$iv.size());
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    it$iv = item$iv$iv$iv = (Map.Entry)iterator.next();
                    collection = destination$iv$iv$iv;
                    bl = false;
                    if (!Reflection.getOrCreateKotlinClass(String.class).isInstance(it$iv.getKey())) {
                        throw new InvalidDataException("Keys of '" + key$iv + "' is not an instance of " + Reflection.getOrCreateKotlinClass(String.class).getSimpleName());
                    }
                    if (!Reflection.getOrCreateKotlinClass(Object.class).isInstance(it$iv.getValue())) {
                        throw new InvalidDataException("Values of '" + key$iv + "' is not an instance of " + Reflection.getOrCreateKotlinClass(Object.class).getSimpleName());
                    }
                    Object k = it$iv.getKey();
                    if (k == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    collection.add(TuplesKt.to((Object)((String)k), it$iv.getValue()));
                }
                map3 = MapsKt.toMap((Iterable)((List)destination$iv$iv$iv));
            } else {
                throw new InvalidDataException("Map element '" + key$iv + "' is not an instance of Map");
            }
            if (map3 == null) {
                throw new InvalidDataException("No ids found");
            }
            this_$iv = MapUtils.INSTANCE;
            $this$getMap$iv = values;
            key$iv = "properties";
            Map map5 = map3;
            $i$f$getMap = false;
            value$iv = $this$getMap$iv.get(key$iv);
            if (value$iv == null) {
                map2 = null;
            } else if (value$iv instanceof Map) {
                $this$map$iv$iv = (Map)value$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv$iv = $this$map$iv$iv;
                destination$iv$iv$iv = new ArrayList($this$map$iv$iv.size());
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    it$iv = item$iv$iv$iv = (Map.Entry)iterator.next();
                    collection = destination$iv$iv$iv;
                    bl = false;
                    if (!Reflection.getOrCreateKotlinClass(String.class).isInstance(it$iv.getKey())) {
                        throw new InvalidDataException("Keys of '" + key$iv + "' is not an instance of " + Reflection.getOrCreateKotlinClass(String.class).getSimpleName());
                    }
                    if (!Reflection.getOrCreateKotlinClass(Object.class).isInstance(it$iv.getValue())) {
                        throw new InvalidDataException("Values of '" + key$iv + "' is not an instance of " + Reflection.getOrCreateKotlinClass(Object.class).getSimpleName());
                    }
                    Object k = it$iv.getKey();
                    if (k == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    collection.add(TuplesKt.to((Object)((String)k), it$iv.getValue()));
                }
                map2 = MapsKt.toMap((Iterable)((List)destination$iv$iv$iv));
            } else {
                throw new InvalidDataException("Map element '" + key$iv + "' is not an instance of Map");
            }
            Map map6 = map = map2;
            if (map6 == null) {
                throw new InvalidDataException("No properties found");
            }
            Map map7 = map6;
            Map map8 = map5;
            Set set3 = set2;
            return new MergeNode(set3, map8, map7);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

