/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy.cud;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.Error;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaRegistry;
import com.networknt.schema.SpecificationVersion;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.neo4j.connectors.kafka.exceptions.InvalidDataException;
import org.neo4j.connectors.kafka.sink.strategy.cud.CreateNode;
import org.neo4j.connectors.kafka.sink.strategy.cud.CreateRelationship;
import org.neo4j.connectors.kafka.sink.strategy.cud.DeleteNode;
import org.neo4j.connectors.kafka.sink.strategy.cud.DeleteRelationship;
import org.neo4j.connectors.kafka.sink.strategy.cud.MergeNode;
import org.neo4j.connectors.kafka.sink.strategy.cud.MergeRelationship;
import org.neo4j.connectors.kafka.sink.strategy.cud.OperationType;
import org.neo4j.connectors.kafka.sink.strategy.cud.Type;
import org.neo4j.connectors.kafka.sink.strategy.cud.UpdateNode;
import org.neo4j.connectors.kafka.sink.strategy.cud.UpdateRelationship;
import org.neo4j.connectors.kafka.utils.JSONUtils;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.Query;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0012\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/cud/Operation;", "", "toQuery", "Lorg/neo4j/driver/Query;", "renderer", "Lorg/neo4j/cypherdsl/core/renderer/Renderer;", "Companion", "sink"})
public interface Operation {
    @NotNull
    public static final Companion Companion = org.neo4j.connectors.kafka.sink.strategy.cud.Operation$Companion.$$INSTANCE;

    @NotNull
    public Query toQuery(@NotNull Renderer var1);

    public static /* synthetic */ Query toQuery$default(Operation operation, Renderer renderer, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toQuery");
        }
        if ((n & 1) != 0) {
            Renderer renderer2 = Renderer.getDefaultRenderer();
            Intrinsics.checkNotNullExpressionValue((Object)renderer2, (String)"getDefaultRenderer(...)");
            renderer = renderer2;
        }
        return operation.toQuery(renderer);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/cud/Operation$Companion;", "", "<init>", "()V", "SCHEMA", "Lcom/networknt/schema/Schema;", "from", "Lorg/neo4j/connectors/kafka/sink/strategy/cud/Operation;", "values", "", "", "sink"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Schema SCHEMA;

        private Companion() {
        }

        @NotNull
        public final Operation from(@NotNull Map<String, ? extends Object> values) {
            Operation operation;
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Object type = values.get("type");
            if (!(type instanceof String)) {
                throw new IllegalArgumentException("Unsupported data type ('" + type + "') in CUD file type.");
            }
            Type type2 = Type.Companion.fromString((String)type);
            if (type2 == null) {
                throw new IllegalArgumentException("CUD file type must be specified.");
            }
            Type type3 = type2;
            Object operation2 = values.get("op");
            if (!(operation2 instanceof String)) {
                throw new IllegalArgumentException("Unsupported data type ('" + operation2 + "') for CUD file operation");
            }
            OperationType operationType = OperationType.Companion.fromString((String)operation2);
            if (operationType == null) {
                throw new IllegalArgumentException("CUD file operation must be specified.");
            }
            OperationType operation3 = operationType;
            ObjectMapper mapper = JSONUtils.INSTANCE.getObjectMapper();
            JsonNode node = mapper.valueToTree(values);
            List errors = SCHEMA.validate(node);
            Intrinsics.checkNotNull((Object)errors);
            if (!((Collection)errors).isEmpty()) {
                throw new InvalidDataException(CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)", ", null, null, (int)0, null, Companion::from$lambda$0, (int)30, null));
            }
            Pair pair = TuplesKt.to((Object)((Object)type3), (Object)((Object)operation3));
            if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)Type.NODE), (Object)((Object)OperationType.CREATE)))) {
                operation = CreateNode.Companion.from(values);
            } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)Type.NODE), (Object)((Object)OperationType.UPDATE)))) {
                operation = UpdateNode.Companion.from(values);
            } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)Type.NODE), (Object)((Object)OperationType.MERGE)))) {
                operation = MergeNode.Companion.from(values);
            } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)Type.NODE), (Object)((Object)OperationType.DELETE)))) {
                operation = DeleteNode.Companion.from(values);
            } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)Type.RELATIONSHIP), (Object)((Object)OperationType.CREATE)))) {
                operation = CreateRelationship.Companion.from(values);
            } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)Type.RELATIONSHIP), (Object)((Object)OperationType.UPDATE)))) {
                operation = UpdateRelationship.Companion.from(values);
            } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)Type.RELATIONSHIP), (Object)((Object)OperationType.MERGE)))) {
                operation = MergeRelationship.Companion.from(values);
            } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)((Object)Type.RELATIONSHIP), (Object)((Object)OperationType.DELETE)))) {
                operation = DeleteRelationship.Companion.from(values);
            } else {
                throw new IllegalArgumentException("Unknown type ('" + type3 + "') and operation ('" + operation3 + "') for CUD file");
            }
            return operation;
        }

        private static final CharSequence from$lambda$0(Error it) {
            return it.getEvaluationPath() + ": " + it.getMessage();
        }

        static {
            $$INSTANCE = new Companion();
            Schema schema = SchemaRegistry.withDefaultDialect((SpecificationVersion)SpecificationVersion.DRAFT_2020_12).getSchema(Operation.class.getResourceAsStream("cud.schema.v1.json"));
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"getSchema(...)");
            SCHEMA = schema;
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static /* synthetic */ Query toQuery$default(Operation operation, Renderer renderer, int n, Object object) {
            return Operation.toQuery$default(operation, renderer, n, object);
        }
    }
}

