/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy.pattern;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.connectors.kafka.data.ConstraintData;
import org.neo4j.connectors.kafka.data.ConstraintEntityType;
import org.neo4j.connectors.kafka.data.ConstraintType;
import org.neo4j.connectors.kafka.data.PropertyConstraintsKt;
import org.neo4j.connectors.kafka.sink.strategy.pattern.NodePattern;
import org.neo4j.connectors.kafka.sink.strategy.pattern.PropertyMapping;
import org.neo4j.connectors.kafka.sink.strategy.pattern.RelationshipPattern;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J&\u0010\f\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0005J8\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0013H\u0002J8\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0013H\u0002J8\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0013H\u0002J8\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0013H\u0002J8\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0013H\u0002J8\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0013H\u0002J@\u0010\u001a\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00132\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J@\u0010\u001b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00052\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00132\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J6\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\n2\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00132\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0002J*\u0010!\u001a\u00020\u001d2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\"2\u0006\u0010#\u001a\u00020\u00052\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0002J\u001e\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J0\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0\"2\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00132\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J0\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0\"2\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00132\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J$\u0010)\u001a\u00020\u000f2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0002\u00a8\u0006,"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternConstraintValidator;", "", "<init>", "()V", "checkNodeWarning", "", "constraints", "", "Lorg/neo4j/connectors/kafka/data/ConstraintData;", "pattern", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/NodePattern;", "patternString", "checkRelationshipWarning", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/RelationshipPattern;", "checkNodeKey", "", "label", "keys", "typeConstraintMap", "", "checkNodeUniqueness", "checkNodePropertyExistence", "checkRelationshipKey", "type", "checkRelationshipUniqueness", "checkRelationshipPropertyExistence", "buildNodeWarningMessage", "buildRelationshipWarningMessage", "addLabelConstraintsText", "", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addExistingConstraints", "", "labelOrType", "getConstraintWarningText", "constraintType", "properties", "getLabelConstraints", "getRelationshipConstraints", "equalsIgnoreOrder", "first", "second", "sink"})
@SourceDebugExtension(value={"SMAP\nPatternConstraintValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatternConstraintValidator.kt\norg/neo4j/connectors/kafka/sink/strategy/pattern/PatternConstraintValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,314:1\n777#2:315\n873#2,2:316\n1512#2:318\n1538#2,3:319\n1541#2,3:329\n1586#2:332\n1661#2,3:333\n777#2:336\n873#2,2:337\n1512#2:339\n1538#2,3:340\n1541#2,3:350\n1586#2:353\n1661#2,3:354\n1391#2:357\n1480#2,5:358\n1391#2:363\n1480#2,5:364\n383#3,7:322\n383#3,7:343\n*S KotlinDebug\n*F\n+ 1 PatternConstraintValidator.kt\norg/neo4j/connectors/kafka/sink/strategy/pattern/PatternConstraintValidator\n*L\n33#1:315\n33#1:316,2\n38#1:318\n38#1:319,3\n38#1:329,3\n40#1:332\n40#1:333,3\n65#1:336\n65#1:337,2\n70#1:339\n70#1:340,3\n70#1:350,3\n72#1:353\n72#1:354,3\n126#1:357\n126#1:358,5\n167#1:363\n167#1:364,5\n38#1:322,7\n70#1:343,7\n*E\n"})
public final class PatternConstraintValidator {
    @NotNull
    public static final PatternConstraintValidator INSTANCE = new PatternConstraintValidator();

    private PatternConstraintValidator() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String checkNodeWarning(@NotNull List<ConstraintData> constraints, @NotNull NodePattern pattern, @NotNull String patternString) {
        void $this$mapTo$iv$iv;
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        ConstraintData it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)patternString, (String)"patternString");
        Iterable iterable = constraints;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ConstraintData)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getEntityType(), (Object)ConstraintEntityType.NODE.getValue()) && PropertyConstraintsKt.getNODE_CONSTRAINTS().contains(it.getConstraintType()) && pattern.getLabels().contains(it.getLabelOrType()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            it = (ConstraintData)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getConstraintType() + "-" + it.getLabelOrType();
            Object object2 = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object typeConstraintMap = destination$iv$iv;
        Iterable $this$map$iv = pattern.getKeyProperties();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            PropertyMapping bl = (PropertyMapping)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(it2.getTo());
        }
        List keys = (List)destination$iv$iv2;
        for (String label : pattern.getLabels()) {
            if (this.checkNodeKey(label, keys, (Map<String, ? extends List<ConstraintData>>)typeConstraintMap)) {
                return null;
            }
            if (!this.checkNodeUniqueness(label, keys, (Map<String, ? extends List<ConstraintData>>)typeConstraintMap) || !this.checkNodePropertyExistence(label, keys, (Map<String, ? extends List<ConstraintData>>)typeConstraintMap)) continue;
            return null;
        }
        return this.buildNodeWarningMessage(pattern, patternString, (Map<String, ? extends List<ConstraintData>>)typeConstraintMap, keys);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String checkRelationshipWarning(@NotNull List<ConstraintData> constraints, @NotNull RelationshipPattern pattern, @NotNull String patternString) {
        void $this$mapTo$iv$iv;
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        ConstraintData it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)patternString, (String)"patternString");
        Iterable iterable = constraints;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ConstraintData)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getEntityType(), (Object)ConstraintEntityType.RELATIONSHIP.getValue()) && PropertyConstraintsKt.getRELATIONSHIP_CONSTRAINTS().contains(it.getConstraintType()) && Intrinsics.areEqual((Object)pattern.getType(), (Object)it.getLabelOrType()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            it = (ConstraintData)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getConstraintType() + "-" + it.getLabelOrType();
            Object object2 = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object typeConstraintMap = destination$iv$iv;
        Iterable $this$map$iv = pattern.getKeyProperties();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            PropertyMapping bl = (PropertyMapping)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(it2.getTo());
        }
        List keys = (List)destination$iv$iv2;
        String type = pattern.getType();
        if (this.checkRelationshipKey(type, keys, (Map<String, ? extends List<ConstraintData>>)typeConstraintMap)) {
            return null;
        }
        if (this.checkRelationshipUniqueness(type, keys, (Map<String, ? extends List<ConstraintData>>)typeConstraintMap) && this.checkRelationshipPropertyExistence(type, keys, (Map<String, ? extends List<ConstraintData>>)typeConstraintMap)) {
            return null;
        }
        return this.buildRelationshipWarningMessage(pattern, patternString, (Map<String, ? extends List<ConstraintData>>)typeConstraintMap, keys);
    }

    private final boolean checkNodeKey(String label, List<String> keys, Map<String, ? extends List<ConstraintData>> typeConstraintMap) {
        List<ConstraintData> list = typeConstraintMap.get(ConstraintType.NODE_KEY.getValue() + "-" + label);
        if (list == null) {
            return false;
        }
        List<ConstraintData> nodeKeyConstraints = list;
        for (ConstraintData constraint : nodeKeyConstraints) {
            if (!this.equalsIgnoreOrder(keys, constraint.getProperties())) continue;
            return true;
        }
        return false;
    }

    private final boolean checkNodeUniqueness(String label, List<String> keys, Map<String, ? extends List<ConstraintData>> typeConstraintMap) {
        List<ConstraintData> list = typeConstraintMap.get(ConstraintType.NODE_UNIQUENESS.getValue() + "-" + label);
        if (list == null) {
            return false;
        }
        List<ConstraintData> uniquenessConstraints = list;
        for (ConstraintData constraint : uniquenessConstraints) {
            if (!this.equalsIgnoreOrder(keys, constraint.getProperties())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkNodePropertyExistence(String label, List<String> keys, Map<String, ? extends List<ConstraintData>> typeConstraintMap) {
        void $this$flatMapTo$iv$iv;
        List<ConstraintData> list = typeConstraintMap.get(ConstraintType.NODE_EXISTENCE.getValue() + "-" + label);
        if (list == null) {
            return false;
        }
        List<ConstraintData> existenceConstraints = list;
        Iterable $this$flatMap$iv = existenceConstraints;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ConstraintData it = (ConstraintData)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getProperties();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List properties = (List)destination$iv$iv;
        return properties.containsAll((Collection)keys);
    }

    private final boolean checkRelationshipKey(String type, List<String> keys, Map<String, ? extends List<ConstraintData>> typeConstraintMap) {
        List<ConstraintData> list = typeConstraintMap.get(ConstraintType.RELATIONSHIP_KEY.getValue() + "-" + type);
        if (list == null) {
            return false;
        }
        List<ConstraintData> relationshipKeyConstraints = list;
        for (ConstraintData constraint : relationshipKeyConstraints) {
            if (!this.equalsIgnoreOrder(keys, constraint.getProperties())) continue;
            return true;
        }
        return false;
    }

    private final boolean checkRelationshipUniqueness(String type, List<String> keys, Map<String, ? extends List<ConstraintData>> typeConstraintMap) {
        List<ConstraintData> list = typeConstraintMap.get(ConstraintType.RELATIONSHIP_UNIQUENESS.getValue() + "-" + type);
        if (list == null) {
            return false;
        }
        List<ConstraintData> uniquenessConstraints = list;
        for (ConstraintData constraint : uniquenessConstraints) {
            if (!this.equalsIgnoreOrder(keys, constraint.getProperties())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkRelationshipPropertyExistence(String type, List<String> keys, Map<String, ? extends List<ConstraintData>> typeConstraintMap) {
        void $this$flatMapTo$iv$iv;
        List<ConstraintData> list = typeConstraintMap.get(ConstraintType.RELATIONSHIP_EXISTENCE.getValue() + "-" + type);
        if (list == null) {
            return false;
        }
        List<ConstraintData> existenceConstraints = list;
        Iterable $this$flatMap$iv = existenceConstraints;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ConstraintData it = (ConstraintData)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getProperties();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List properties = (List)destination$iv$iv;
        return properties.containsAll((Collection)keys);
    }

    private final String buildNodeWarningMessage(NodePattern pattern, String patternString, Map<String, ? extends List<ConstraintData>> typeConstraintMap, List<String> keys) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = new StringBuilder();
        if (pattern.getLabels().size() > 1) {
            stringBuilder2.append("None of the labels " + CollectionsKt.joinToString$default((Iterable)pattern.getLabels(), (CharSequence)", ", null, null, (int)0, null, PatternConstraintValidator::buildNodeWarningMessage$lambda$0, (int)30, null) + " match the key(s) defined by the pattern " + patternString + ".");
            stringBuilder = stringBuilder2.append("\nPlease fix at least one of the following label constraints:");
        } else {
            stringBuilder2.append("Label '" + CollectionsKt.first((Iterable)pattern.getLabels()) + "' does not match the key(s) defined by the pattern " + patternString + ".");
            stringBuilder = stringBuilder2.append("\nPlease fix the label constraint:");
        }
        this.addLabelConstraintsText(pattern, typeConstraintMap, stringBuilder2);
        stringBuilder2.append("\nExpected constraints:");
        stringBuilder2.append("\n\t- " + this.getConstraintWarningText(ConstraintType.NODE_KEY.getValue(), keys));
        stringBuilder2.append("\nor:");
        stringBuilder2.append("\n\t- " + this.getConstraintWarningText(ConstraintType.NODE_UNIQUENESS.getValue(), keys));
        for (String key : keys) {
            stringBuilder2.append("\n\t- " + this.getConstraintWarningText(ConstraintType.NODE_EXISTENCE.getValue(), CollectionsKt.listOf((Object)key)));
        }
        String string = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String buildRelationshipWarningMessage(RelationshipPattern pattern, String patternString, Map<String, ? extends List<ConstraintData>> typeConstraintMap, List<String> keys) {
        StringBuilder stringBuilder = new StringBuilder();
        String type = pattern.getType();
        stringBuilder.append("Relationship '" + type + "' does not match the key(s) defined by the pattern " + patternString + ".");
        stringBuilder.append("\nPlease fix the relationship constraints:");
        List<ConstraintData> relationshipConstraints = this.getRelationshipConstraints(typeConstraintMap, type);
        this.addExistingConstraints(relationshipConstraints, type, stringBuilder);
        stringBuilder.append("\nExpected constraints:");
        stringBuilder.append("\n\t- " + this.getConstraintWarningText(ConstraintType.RELATIONSHIP_KEY.getValue(), keys));
        stringBuilder.append("\nor:");
        stringBuilder.append("\n\t- " + this.getConstraintWarningText(ConstraintType.RELATIONSHIP_UNIQUENESS.getValue(), keys));
        for (String key : keys) {
            stringBuilder.append("\n\t- " + this.getConstraintWarningText(ConstraintType.RELATIONSHIP_EXISTENCE.getValue(), CollectionsKt.listOf((Object)key)));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void addLabelConstraintsText(NodePattern pattern, Map<String, ? extends List<ConstraintData>> typeConstraintMap, StringBuilder stringBuilder) {
        for (String label : pattern.getLabels()) {
            List<ConstraintData> labelConstraints = this.getLabelConstraints(typeConstraintMap, label);
            this.addExistingConstraints(labelConstraints, label, stringBuilder);
        }
    }

    private final void addExistingConstraints(List<ConstraintData> constraints, String labelOrType, StringBuilder stringBuilder) {
        if (!((Collection)constraints).isEmpty()) {
            stringBuilder.append("\n\t'" + labelOrType + "' has:");
            for (ConstraintData constraint : constraints) {
                stringBuilder.append("\n\t\t- " + this.getConstraintWarningText(constraint.getConstraintType(), constraint.getProperties()));
            }
        } else {
            stringBuilder.append("\n\t'" + labelOrType + "' has no key constraints");
        }
    }

    private final String getConstraintWarningText(String constraintType, List<String> properties) {
        return constraintType + " (" + CollectionsKt.joinToString$default((Iterable)properties, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ")";
    }

    private final List<ConstraintData> getLabelConstraints(Map<String, ? extends List<ConstraintData>> typeConstraintMap, String label) {
        List labelConstraints = new ArrayList();
        List<ConstraintData> list = typeConstraintMap.get(ConstraintType.NODE_KEY.getValue() + "-" + label);
        labelConstraints.addAll(list != null ? (Collection)list : (Collection)CollectionsKt.emptyList());
        List<ConstraintData> list2 = typeConstraintMap.get(ConstraintType.NODE_UNIQUENESS.getValue() + "-" + label);
        labelConstraints.addAll(list2 != null ? (Collection)list2 : (Collection)CollectionsKt.emptyList());
        List<ConstraintData> list3 = typeConstraintMap.get(ConstraintType.NODE_EXISTENCE.getValue() + "-" + label);
        labelConstraints.addAll(list3 != null ? (Collection)list3 : (Collection)CollectionsKt.emptyList());
        return labelConstraints;
    }

    private final List<ConstraintData> getRelationshipConstraints(Map<String, ? extends List<ConstraintData>> typeConstraintMap, String type) {
        List relationshipConstraints = new ArrayList();
        List<ConstraintData> list = typeConstraintMap.get(ConstraintType.RELATIONSHIP_KEY.getValue() + "-" + type);
        relationshipConstraints.addAll(list != null ? (Collection)list : (Collection)CollectionsKt.emptyList());
        List<ConstraintData> list2 = typeConstraintMap.get(ConstraintType.RELATIONSHIP_UNIQUENESS.getValue() + "-" + type);
        relationshipConstraints.addAll(list2 != null ? (Collection)list2 : (Collection)CollectionsKt.emptyList());
        List<ConstraintData> list3 = typeConstraintMap.get(ConstraintType.RELATIONSHIP_EXISTENCE.getValue() + "-" + type);
        relationshipConstraints.addAll(list3 != null ? (Collection)list3 : (Collection)CollectionsKt.emptyList());
        return relationshipConstraints;
    }

    private final boolean equalsIgnoreOrder(List<String> first, List<String> second) {
        return first.size() == second.size() && Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)first), (Object)CollectionsKt.toSet((Iterable)second));
    }

    private static final CharSequence buildNodeWarningMessage$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it + "'";
    }
}

