/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy.pattern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.connectors.kafka.sink.strategy.pattern.NodePattern;
import org.neo4j.connectors.kafka.sink.strategy.pattern.Pattern;
import org.neo4j.connectors.kafka.sink.strategy.pattern.PatternException;
import org.neo4j.connectors.kafka.sink.strategy.pattern.PatternLexer;
import org.neo4j.connectors.kafka.sink.strategy.pattern.PatternParser;
import org.neo4j.connectors.kafka.sink.strategy.pattern.PatternParserBaseVisitor;
import org.neo4j.connectors.kafka.sink.strategy.pattern.PropertyMapping;
import org.neo4j.connectors.kafka.sink.strategy.pattern.RelationshipPattern;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0005\f\r\u000e\u000f\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/pattern/Visitors;", "", "<init>", "()V", "parse", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/Pattern;", "source", "", "extractPropertyNameOrAlias", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PropertyMapping;", "ctx", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParser$PropertyKeyNameOrAliasContext;", "PatternVisitor", "NodeLabelsVisitor", "LabelOrRelTypeVisitor", "PropertyKeyNameVisitor", "SymbolicNameStringVisitor", "sink"})
public final class Visitors {
    @NotNull
    public static final Visitors INSTANCE = new Visitors();

    private Visitors() {
    }

    @NotNull
    public final Pattern parse(@Nullable String source) {
        CodePointCharStream input = CharStreams.fromString((String)source);
        PatternLexer lexer = new PatternLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        PatternParser parser = new PatternParser((TokenStream)tokens);
        List errors = new ArrayList();
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(errors){
            final /* synthetic */ List<String> $errors;
            {
                this.$errors = $errors;
            }

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                Intrinsics.checkNotNullParameter((Object)offendingSymbol, (String)"offendingSymbol");
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                String string = "line %d:%d, %s";
                Object[] objectArray = new Object[]{line, charPositionInLine, msg};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                this.$errors.add(string2);
            }
        });
        PatternParser.PatternContext pattern = parser.pattern();
        if (!((Collection)errors).isEmpty()) {
            throw new PatternException("Invalid pattern: " + CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ".");
        }
        Intrinsics.checkNotNull((Object)((Object)pattern));
        return PatternVisitor.INSTANCE.visitPattern(pattern);
    }

    private final PropertyMapping extractPropertyNameOrAlias(PatternParser.PropertyKeyNameOrAliasContext ctx) {
        PropertyMapping propertyMapping;
        if (ctx.propertyKeyName() != null) {
            PatternParser.PropertyKeyNameContext propertyKeyNameContext = ctx.propertyKeyName();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)propertyKeyNameContext), (String)"propertyKeyName(...)");
            String property = PropertyKeyNameVisitor.INSTANCE.visitPropertyKeyName(propertyKeyNameContext);
            propertyMapping = new PropertyMapping(property, property);
        } else {
            PatternParser.PropertyKeyNameContext propertyKeyNameContext = ctx.aliasedPropertyKeyName().propertyKeyName(1);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)propertyKeyNameContext), (String)"propertyKeyName(...)");
            String string = PropertyKeyNameVisitor.INSTANCE.visitPropertyKeyName(propertyKeyNameContext);
            PatternParser.PropertyKeyNameContext propertyKeyNameContext2 = ctx.aliasedPropertyKeyName().propertyKeyName(0);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)propertyKeyNameContext2), (String)"propertyKeyName(...)");
            propertyMapping = new PropertyMapping(string, PropertyKeyNameVisitor.INSTANCE.visitPropertyKeyName(propertyKeyNameContext2));
        }
        return propertyMapping;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/pattern/Visitors$LabelOrRelTypeVisitor;", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParserBaseVisitor;", "", "<init>", "()V", "visitLabelOrRelType", "ctx", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParser$LabelOrRelTypeContext;", "sink"})
    private static final class LabelOrRelTypeVisitor
    extends PatternParserBaseVisitor<String> {
        @NotNull
        public static final LabelOrRelTypeVisitor INSTANCE = new LabelOrRelTypeVisitor();

        private LabelOrRelTypeVisitor() {
        }

        @Override
        @NotNull
        public String visitLabelOrRelType(@NotNull PatternParser.LabelOrRelTypeContext ctx) {
            Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
            PatternParser.SymbolicNameStringContext symbolicNameStringContext = ctx.symbolicNameString();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)symbolicNameStringContext), (String)"symbolicNameString(...)");
            return SymbolicNameStringVisitor.INSTANCE.visitSymbolicNameString(symbolicNameStringContext);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/pattern/Visitors$NodeLabelsVisitor;", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParserBaseVisitor;", "", "", "<init>", "()V", "visitNodeLabels", "ctx", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParser$NodeLabelsContext;", "sink"})
    @SourceDebugExtension(value={"SMAP\nVisitors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Visitors.kt\norg/neo4j/connectors/kafka/sink/strategy/pattern/Visitors$NodeLabelsVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,341:1\n1586#2:342\n1661#2,3:343\n*S KotlinDebug\n*F\n+ 1 Visitors.kt\norg/neo4j/connectors/kafka/sink/strategy/pattern/Visitors$NodeLabelsVisitor\n*L\n307#1:342\n307#1:343,3\n*E\n"})
    private static final class NodeLabelsVisitor
    extends PatternParserBaseVisitor<Set<? extends String>> {
        @NotNull
        public static final NodeLabelsVisitor INSTANCE = new NodeLabelsVisitor();

        private NodeLabelsVisitor() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Set<String> visitNodeLabels(@Nullable PatternParser.NodeLabelsContext ctx) {
            void $this$mapTo$iv$iv;
            PatternParser.NodeLabelsContext nodeLabelsContext = ctx;
            if ((nodeLabelsContext != null ? nodeLabelsContext.labelOrRelType() : null) == null) {
                return SetsKt.emptySet();
            }
            List<PatternParser.LabelOrRelTypeContext> list = ctx.labelOrRelType();
            Intrinsics.checkNotNullExpressionValue(list, (String)"labelOrRelType(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PatternParser.LabelOrRelTypeContext labelOrRelTypeContext = (PatternParser.LabelOrRelTypeContext)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(LabelOrRelTypeVisitor.INSTANCE.visitLabelOrRelType((PatternParser.LabelOrRelTypeContext)it));
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u000bH\u0016J\u001f\u0010\f\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u00022\u0006\u0010\u000e\u001a\u0002H\rH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J@\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0#2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0002\u00a8\u0006'"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/pattern/Visitors$PatternVisitor;", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParserBaseVisitor;", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/Pattern;", "<init>", "()V", "visitPattern", "ctx", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParser$PatternContext;", "visitCypherPattern", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParser$CypherPatternContext;", "visitSimplePattern", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParser$SimplePatternContext;", "ensureImplicitWildcard", "T", "pattern", "(Lorg/neo4j/connectors/kafka/sink/strategy/pattern/Pattern;)Lorg/neo4j/connectors/kafka/sink/strategy/pattern/Pattern;", "enforceKeyProperties", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/NodePattern;", "enforceExplicitInclusionOnly", "visitCypherNodePattern", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParser$CypherNodePatternContext;", "visitSimpleNodePattern", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParser$SimpleNodePatternContext;", "nodePattern", "labels", "", "", "properties", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParser$PropertiesContext;", "extractPropertySelectors", "", "selectors", "", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParser$PropSelectorContext;", "keyProperties", "", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PropertyMapping;", "includeProperties", "excludeProperties", "sink"})
    @SourceDebugExtension(value={"SMAP\nVisitors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Visitors.kt\norg/neo4j/connectors/kafka/sink/strategy/pattern/Visitors$PatternVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,341:1\n777#2:342\n873#2,2:343\n777#2:345\n873#2,2:346\n777#2:348\n873#2,2:349\n1915#2,2:351\n*S KotlinDebug\n*F\n+ 1 Visitors.kt\norg/neo4j/connectors/kafka/sink/strategy/pattern/Visitors$PatternVisitor\n*L\n111#1:342\n111#1:343,2\n148#1:345\n148#1:346,2\n252#1:348\n252#1:349,2\n263#1:351,2\n*E\n"})
    private static final class PatternVisitor
    extends PatternParserBaseVisitor<Pattern> {
        @NotNull
        public static final PatternVisitor INSTANCE = new PatternVisitor();

        private PatternVisitor() {
        }

        @Override
        @NotNull
        public Pattern visitPattern(@NotNull PatternParser.PatternContext ctx) {
            Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
            if (ctx.cypherPattern() != null) {
                PatternParser.CypherPatternContext cypherPatternContext = ctx.cypherPattern();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)cypherPatternContext), (String)"cypherPattern(...)");
                return this.visitCypherPattern(cypherPatternContext);
            }
            PatternParser.SimplePatternContext simplePatternContext = ctx.simplePattern();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)simplePatternContext), (String)"simplePattern(...)");
            return this.visitSimplePattern(simplePatternContext);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Pattern visitCypherPattern(@NotNull PatternParser.CypherPatternContext ctx) {
            Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
            if (ctx.cypherRelationshipPattern() != null) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                boolean bidirectional;
                PatternParser.CypherRelationshipPatternContext relPattern = ctx.cypherRelationshipPattern();
                boolean bl = bidirectional = relPattern.leftArrow() != null && relPattern.rightArrow() != null || relPattern.leftArrow() == null && relPattern.rightArrow() == null;
                if (bidirectional) {
                    throw new PatternException("Direction of relationship pattern must be explicitly set.");
                }
                Set keyProperties = new LinkedHashSet();
                Set includeProperties = new LinkedHashSet();
                Set excludeProperties = new LinkedHashSet();
                if (relPattern.properties() != null && relPattern.properties().propertySelector() != null) {
                    List<PatternParser.PropSelectorContext> list = relPattern.properties().propertySelector().propSelector();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"propSelector(...)");
                    this.extractPropertySelectors(list, keyProperties, includeProperties, excludeProperties);
                }
                PatternParser.CypherNodePatternContext cypherNodePatternContext = ctx.cypherNodePattern(relPattern.rightArrow() != null ? 0 : 1);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)cypherNodePatternContext), (String)"cypherNodePattern(...)");
                NodePattern startNode = this.enforceKeyProperties(this.visitCypherNodePattern(cypherNodePatternContext));
                PatternParser.CypherNodePatternContext cypherNodePatternContext2 = ctx.cypherNodePattern(relPattern.rightArrow() != null ? 1 : 0);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)cypherNodePatternContext2), (String)"cypherNodePattern(...)");
                NodePattern endNode = this.enforceKeyProperties(this.visitCypherNodePattern(cypherNodePatternContext2));
                PatternParser.LabelOrRelTypeContext labelOrRelTypeContext = relPattern.labelOrRelType();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)labelOrRelTypeContext), (String)"labelOrRelType(...)");
                Iterable iterable = includeProperties;
                Set set = keyProperties;
                boolean bl2 = includeProperties.contains(PropertyMapping.Companion.getWILDCARD());
                NodePattern nodePattern = this.enforceExplicitInclusionOnly(endNode);
                NodePattern nodePattern2 = this.enforceExplicitInclusionOnly(startNode);
                String string = LabelOrRelTypeVisitor.INSTANCE.visitLabelOrRelType(labelOrRelTypeContext);
                PatternVisitor patternVisitor = this;
                boolean $i$f$filter = false;
                void var11_17 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PropertyMapping it = (PropertyMapping)element$iv$iv;
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)PropertyMapping.Companion.getWILDCARD()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                Set set2 = excludeProperties;
                Set set3 = CollectionsKt.toSet((Iterable)list);
                Set set4 = set;
                boolean bl4 = bl2;
                NodePattern nodePattern3 = nodePattern;
                NodePattern nodePattern4 = nodePattern2;
                String string2 = string;
                return patternVisitor.ensureImplicitWildcard((Pattern)new RelationshipPattern(string2, nodePattern4, nodePattern3, bl4, set4, set3, set2));
            }
            PatternParser.CypherNodePatternContext cypherNodePatternContext = ctx.cypherNodePattern(0);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)cypherNodePatternContext), (String)"cypherNodePattern(...)");
            return this.ensureImplicitWildcard((Pattern)this.enforceKeyProperties(this.visitCypherNodePattern(cypherNodePatternContext)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Pattern visitSimplePattern(@NotNull PatternParser.SimplePatternContext ctx) {
            Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
            if (ctx.simpleRelationshipPattern() != null) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                PatternParser.SimpleRelationshipPatternContext relPattern = ctx.simpleRelationshipPattern();
                Set keyProperties = new LinkedHashSet();
                Set includeProperties = new LinkedHashSet();
                Set excludeProperties = new LinkedHashSet();
                if (relPattern.properties() != null && relPattern.properties().propertySelector() != null) {
                    List<PatternParser.PropSelectorContext> list = relPattern.properties().propertySelector().propSelector();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"propSelector(...)");
                    this.extractPropertySelectors(list, keyProperties, includeProperties, excludeProperties);
                }
                PatternParser.SimpleNodePatternContext simpleNodePatternContext = ctx.simpleNodePattern(0);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)simpleNodePatternContext), (String)"simpleNodePattern(...)");
                NodePattern startNode = this.enforceKeyProperties(this.visitSimpleNodePattern(simpleNodePatternContext));
                PatternParser.SimpleNodePatternContext simpleNodePatternContext2 = ctx.simpleNodePattern(1);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)simpleNodePatternContext2), (String)"simpleNodePattern(...)");
                NodePattern endNode = this.enforceKeyProperties(this.visitSimpleNodePattern(simpleNodePatternContext2));
                PatternParser.SymbolicNameStringContext symbolicNameStringContext = relPattern.symbolicNameString();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)symbolicNameStringContext), (String)"symbolicNameString(...)");
                Iterable iterable = includeProperties;
                Set set = keyProperties;
                boolean bl = includeProperties.contains(PropertyMapping.Companion.getWILDCARD());
                NodePattern nodePattern = this.enforceExplicitInclusionOnly(endNode);
                NodePattern nodePattern2 = this.enforceExplicitInclusionOnly(startNode);
                String string = SymbolicNameStringVisitor.INSTANCE.visitSymbolicNameString(symbolicNameStringContext);
                PatternVisitor patternVisitor = this;
                boolean $i$f$filter = false;
                void var10_16 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PropertyMapping it = (PropertyMapping)element$iv$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)PropertyMapping.Companion.getWILDCARD()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                Set set2 = excludeProperties;
                Set set3 = CollectionsKt.toSet((Iterable)list);
                Set set4 = set;
                boolean bl3 = bl;
                NodePattern nodePattern3 = nodePattern;
                NodePattern nodePattern4 = nodePattern2;
                String string2 = string;
                return patternVisitor.ensureImplicitWildcard((Pattern)new RelationshipPattern(string2, nodePattern4, nodePattern3, bl3, set4, set3, set2));
            }
            PatternParser.SimpleNodePatternContext simpleNodePatternContext = ctx.simpleNodePattern(0);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)simpleNodePatternContext), (String)"simpleNodePattern(...)");
            return this.ensureImplicitWildcard((Pattern)this.enforceKeyProperties(this.visitSimpleNodePattern(simpleNodePatternContext)));
        }

        private final <T extends Pattern> T ensureImplicitWildcard(T pattern) {
            T t = pattern;
            if (t instanceof NodePattern) {
                if (((NodePattern)pattern).getIncludeProperties().isEmpty()) {
                    return (T)new NodePattern(((NodePattern)pattern).getLabels(), true, ((NodePattern)pattern).getKeyProperties(), SetsKt.emptySet(), ((NodePattern)pattern).getExcludeProperties());
                }
            } else if (t instanceof RelationshipPattern) {
                if (((RelationshipPattern)pattern).getIncludeProperties().isEmpty()) {
                    return (T)new RelationshipPattern(((RelationshipPattern)pattern).getType(), ((RelationshipPattern)pattern).getStart(), ((RelationshipPattern)pattern).getEnd(), true, ((RelationshipPattern)pattern).getKeyProperties(), SetsKt.emptySet(), ((RelationshipPattern)pattern).getExcludeProperties());
                }
            } else {
                throw new IllegalArgumentException("Unsupported pattern type: " + pattern.getClass().getName() + ".");
            }
            return pattern;
        }

        private final NodePattern enforceKeyProperties(NodePattern pattern) {
            if (pattern.getKeyProperties().isEmpty()) {
                throw new PatternException("At least one key selector must be specified in node patterns.");
            }
            return pattern;
        }

        private final NodePattern enforceExplicitInclusionOnly(NodePattern pattern) {
            if (!((Collection)pattern.getExcludeProperties()).isEmpty()) {
                throw new PatternException("Property exclusions are not allowed on start and end node patterns.");
            }
            if (pattern.getIncludeAllValueProperties()) {
                throw new PatternException("Wildcard property inclusion is not allowed on start and end node patterns.");
            }
            return pattern;
        }

        @Override
        @NotNull
        public NodePattern visitCypherNodePattern(@NotNull PatternParser.CypherNodePatternContext ctx) {
            Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
            Object labels = NodeLabelsVisitor.INSTANCE.visitNodeLabels(ctx.nodeLabels());
            return this.nodePattern((Set<String>)labels, ctx.properties());
        }

        @Override
        @NotNull
        public NodePattern visitSimpleNodePattern(@NotNull PatternParser.SimpleNodePatternContext ctx) {
            Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
            PatternParser.SymbolicNameStringContext symbolicNameStringContext = ctx.symbolicNameString();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)symbolicNameStringContext), (String)"symbolicNameString(...)");
            Set labels = SetsKt.plus((Set)SetsKt.setOf((Object)SymbolicNameStringVisitor.INSTANCE.visitSymbolicNameString(symbolicNameStringContext)), (Iterable)((Iterable)NodeLabelsVisitor.INSTANCE.visitNodeLabels(ctx.nodeLabels())));
            return this.nodePattern(labels, ctx.properties());
        }

        /*
         * WARNING - void declaration
         */
        private final NodePattern nodePattern(Set<String> labels, PatternParser.PropertiesContext properties) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Set keyProperties = new LinkedHashSet();
            Set includeProperties = new LinkedHashSet();
            Set excludeProperties = new LinkedHashSet();
            PatternParser.PropertiesContext propertiesContext = properties;
            if ((propertiesContext != null ? propertiesContext.propertySelector() : null) != null) {
                List<PatternParser.PropSelectorContext> list = properties.propertySelector().propSelector();
                Intrinsics.checkNotNullExpressionValue(list, (String)"propSelector(...)");
                this.extractPropertySelectors(list, keyProperties, includeProperties, excludeProperties);
            }
            Iterable iterable = includeProperties;
            Set set = keyProperties;
            boolean bl = includeProperties.contains(PropertyMapping.Companion.getWILDCARD());
            Set<String> set2 = labels;
            boolean $i$f$filter = false;
            void var8_11 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PropertyMapping it = (PropertyMapping)element$iv$iv;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)PropertyMapping.Companion.getWILDCARD()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            Set set3 = excludeProperties;
            Set set4 = CollectionsKt.toSet((Iterable)list);
            Set set5 = set;
            boolean bl3 = bl;
            Set<String> set6 = set2;
            return new NodePattern(set6, bl3, set5, set4, set3);
        }

        private final void extractPropertySelectors(List<? extends PatternParser.PropSelectorContext> selectors, Set<PropertyMapping> keyProperties, Set<PropertyMapping> includeProperties, Set<String> excludeProperties) {
            Iterable $this$forEach$iv = selectors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Collection collection;
                PatternParser.PropSelectorContext child = (PatternParser.PropSelectorContext)((Object)element$iv);
                boolean bl = false;
                if (child.TIMES() != null) {
                    includeProperties.add(PropertyMapping.Companion.getWILDCARD());
                    continue;
                }
                if (child.MINUS() != null) {
                    PatternParser.PropertyKeyNameContext propertyKeyNameContext = child.propertyKeyName();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)propertyKeyNameContext), (String)"propertyKeyName(...)");
                    excludeProperties.add(PropertyKeyNameVisitor.INSTANCE.visitPropertyKeyName(propertyKeyNameContext));
                    continue;
                }
                if (child.EXCLAMATION() != null) {
                    collection = keyProperties;
                    PatternParser.PropertyKeyNameOrAliasContext propertyKeyNameOrAliasContext = child.propertyKeyNameOrAlias();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)propertyKeyNameOrAliasContext), (String)"propertyKeyNameOrAlias(...)");
                    collection.add(INSTANCE.extractPropertyNameOrAlias(propertyKeyNameOrAliasContext));
                    continue;
                }
                collection = includeProperties;
                PatternParser.PropertyKeyNameOrAliasContext propertyKeyNameOrAliasContext = child.propertyKeyNameOrAlias();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)propertyKeyNameOrAliasContext), (String)"propertyKeyNameOrAlias(...)");
                collection.add(INSTANCE.extractPropertyNameOrAlias(propertyKeyNameOrAliasContext));
            }
            if (!((Collection)includeProperties).isEmpty() && !((Collection)excludeProperties).isEmpty() && !includeProperties.contains(PropertyMapping.Companion.getWILDCARD())) {
                throw new PatternException("Property inclusions and exclusions are mutually exclusive.");
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/pattern/Visitors$PropertyKeyNameVisitor;", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParserBaseVisitor;", "", "<init>", "()V", "visitPropertyKeyName", "ctx", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParser$PropertyKeyNameContext;", "sink"})
    private static final class PropertyKeyNameVisitor
    extends PatternParserBaseVisitor<String> {
        @NotNull
        public static final PropertyKeyNameVisitor INSTANCE = new PropertyKeyNameVisitor();

        private PropertyKeyNameVisitor() {
        }

        @Override
        @NotNull
        public String visitPropertyKeyName(@NotNull PatternParser.PropertyKeyNameContext ctx) {
            Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
            PatternParser.SymbolicNameStringContext symbolicNameStringContext = ctx.symbolicNameString();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)symbolicNameStringContext), (String)"symbolicNameString(...)");
            return SymbolicNameStringVisitor.INSTANCE.visitSymbolicNameString(symbolicNameStringContext);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/pattern/Visitors$SymbolicNameStringVisitor;", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParserBaseVisitor;", "", "<init>", "()V", "visitSymbolicNameString", "ctx", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParser$SymbolicNameStringContext;", "visitEscapedSymbolicNameString", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParser$EscapedSymbolicNameStringContext;", "visitUnescapedSymbolicNameString", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PatternParser$UnescapedSymbolicNameStringContext;", "sink"})
    private static final class SymbolicNameStringVisitor
    extends PatternParserBaseVisitor<String> {
        @NotNull
        public static final SymbolicNameStringVisitor INSTANCE = new SymbolicNameStringVisitor();

        private SymbolicNameStringVisitor() {
        }

        @Override
        @NotNull
        public String visitSymbolicNameString(@NotNull PatternParser.SymbolicNameStringContext ctx) {
            Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
            Object t = super.visitSymbolicNameString(ctx);
            Intrinsics.checkNotNullExpressionValue(t, (String)"visitSymbolicNameString(...)");
            return (String)t;
        }

        @Override
        @NotNull
        public String visitEscapedSymbolicNameString(@NotNull PatternParser.EscapedSymbolicNameStringContext ctx) {
            Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
            String string = ctx.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string;
            int n = 1;
            int n2 = ctx.getText().length() - 1;
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            return string3;
        }

        @Override
        @NotNull
        public String visitUnescapedSymbolicNameString(@NotNull PatternParser.UnescapedSymbolicNameStringContext ctx) {
            Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
            String string = ctx.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }
    }
}

