{{/*
Expand the name of the chart.
*/}}
{{- define "neo4j-ops-manager-server.name" -}}
{{- default .Chart.Name .Values.nameOverride | trunc 63 | trimSuffix "-" }}
{{- end }}

{{/*
Resolves the secret based either on an existing Secret in K8s or with values set in values file.
Shows custom error if not set.
*/}}
{{- define "resolved-secret.value" -}}
  {{- $secretRef := .args.ref -}}
  {{- if (get .Values.secrets $secretRef) -}}
    {{ get .Values.secrets $secretRef | b64enc }}
  {{- else if (get .Values.secretsFromSecrets $secretRef) -}}
    {{ $secret := (get .Values.secretsFromSecrets $secretRef)}}
    {{- $secretName := $secret.secretName -}}
    {{- $secretKey := $secret.key -}}
    {{- if (and $secretName $secretKey) -}}
        {{- $srcSecret := (lookup "v1" "Secret" .Release.Namespace $secretName) -}}
        {{- if $srcSecret -}}
            {{ get $srcSecret.data $secretKey }}
        {{- end -}}
    {{- end -}}
  {{- end -}}
{{- end -}}
